/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:StatusBoolean", to="baja:Number"))
@NiagaraProperties(value={@NiagaraProperty(name="trueValue", type="int", defaultValue="BBoolean.TRUE.getOrdinal()"), @NiagaraProperty(name="falseValue", type="int", defaultValue="BBoolean.FALSE.getOrdinal()")})
public final class BStatusBooleanToNumber
extends BConverter
implements BIAgent {
    @Generated
    public static final Property trueValue = BStatusBooleanToNumber.newProperty((int)0, (int)BBoolean.TRUE.getOrdinal(), null);
    @Generated
    public static final Property falseValue = BStatusBooleanToNumber.newProperty((int)0, (int)BBoolean.FALSE.getOrdinal(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BStatusBooleanToNumber.class);

    @Generated
    public int getTrueValue() {
        return this.getInt(trueValue);
    }

    @Generated
    public void setTrueValue(int v) {
        this.setInt(trueValue, v, null);
    }

    @Generated
    public int getFalseValue() {
        return this.getInt(falseValue);
    }

    @Generated
    public void setFalseValue(int v) {
        this.setInt(falseValue, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        int value;
        BStatusBoolean statusBoolean = (BStatusBoolean)from;
        boolean bool = ((BBoolean)statusBoolean.getValueValue()).getBoolean();
        int n = value = bool ? this.getTrueValue() : this.getFalseValue();
        if (!statusBoolean.getStatus().isNull()) {
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': {
                    return BInteger.make((int)value);
                }
                case 'l': {
                    return BLong.make((long)value);
                }
                case 'f': {
                    return BFloat.make((float)value);
                }
                case 'd': {
                    return BDouble.make((double)value);
                }
            }
            throw new IllegalStateException();
        }
        switch (to.getType().getDataTypeSymbol()) {
            case 'i': 
            case 'l': {
                return to;
            }
            case 'f': {
                return BFloat.NaN;
            }
            case 'd': {
                return BDouble.NaN;
            }
        }
        throw new IllegalStateException();
    }
}

