/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.converters;

import javax.baja.agent.BIAgent;
import javax.baja.nre.annotations.Adapter;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BConverter;

@NiagaraType(agent={@AgentOn(types={"baja:ConversionLink"})}, adapter=@Adapter(from="baja:StatusString", to="baja:Number"))
public final class BStatusStringToNumber
extends BConverter
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BStatusStringToNumber.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObject convert(BObject from, BObject to, Context cx) {
        BStatusString statusString = (BStatusString)from;
        String value = statusString.getValue();
        try {
            if (!statusString.getStatus().isNull()) {
                switch (to.getType().getDataTypeSymbol()) {
                    case 'i': {
                        return BInteger.make((int)Integer.parseInt(value));
                    }
                    case 'l': {
                        return BLong.make((long)Long.parseLong(value));
                    }
                    case 'f': {
                        return BFloat.make((float)Float.parseFloat(value));
                    }
                    case 'd': {
                        return BDouble.make((double)Double.parseDouble(value));
                    }
                }
                throw new IllegalStateException();
            }
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': 
                case 'l': {
                    return to;
                }
                case 'f': {
                    return BFloat.NaN;
                }
                case 'd': {
                    return BDouble.NaN;
                }
            }
            throw new IllegalStateException();
        }
        catch (NumberFormatException nfe) {
            switch (to.getType().getDataTypeSymbol()) {
                case 'i': 
                case 'l': {
                    return to;
                }
                case 'f': {
                    return BFloat.NaN;
                }
                case 'd': {
                    return BDouble.NaN;
                }
            }
            throw new IllegalStateException();
        }
    }
}

