/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Uri;
import obix.Val;

public class Int
extends Val {
    public static final long MIN_DEFAULT = Long.MIN_VALUE;
    public static final long MAX_DEFAULT = Long.MAX_VALUE;
    private long val;
    private long min = Long.MIN_VALUE;
    private long max = Long.MAX_VALUE;
    private Uri unit = null;

    public Int(String name, long val) {
        super(name);
        this.set(val);
    }

    public Int(String name) {
        super(name);
        this.set(0L);
    }

    public Int(long val) {
        this.set(val);
    }

    public Int() {
        this.set(0L);
    }

    public long get() {
        return this.val;
    }

    public void set(long val) {
        this.val = val;
    }

    @Override
    public String getElement() {
        return "int";
    }

    @Override
    public int getBinCode() {
        return 12;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Int) {
            return ((Int)that).val == this.val;
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        long a = this.val;
        long b = ((Int)that).val;
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String encodeVal() {
        return String.valueOf(this.val);
    }

    @Override
    public void decodeVal(String val) throws Exception {
        this.val = Long.parseLong(val);
    }

    @Override
    public String encodeJava() {
        return String.valueOf(this.val) + "L";
    }

    public long getMin() {
        return this.min;
    }

    public void setMin(long min) {
        this.min = min;
    }

    public long getMax() {
        return this.max;
    }

    public void setMax(long max) {
        this.max = max;
    }

    public Uri getUnit() {
        return this.unit;
    }

    public void setUnit(Uri unit) {
        this.unit = unit;
    }
}

