/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.util.ArrayList;
import obix.asm.Assembler;
import obix.asm.AttributeInfo;
import obix.asm.Buffer;
import obix.asm.ConstantPool;

public abstract class MemberInfo {
    public final Assembler asm;
    public final ConstantPool cp;
    public final int name;
    public final int type;
    public final int accessFlags;
    ArrayList<AttributeInfo> attributes;

    MemberInfo(Assembler asm, int name, int type, int accessFlags) {
        this.asm = asm;
        this.cp = asm.cp;
        this.name = name;
        this.type = type;
        this.accessFlags = accessFlags;
    }

    MemberInfo(Assembler asm, String name, String type, int accessFlags) {
        this.asm = asm;
        this.cp = asm.cp;
        this.name = this.cp.utf(name);
        this.type = this.cp.utf(type);
        this.accessFlags = accessFlags;
    }

    MemberInfo(Assembler asm, int name, String type, int accessFlags) {
        this.asm = asm;
        this.cp = asm.cp;
        this.name = name;
        this.type = this.cp.utf(type);
        this.accessFlags = accessFlags;
    }

    public void addAttribute(AttributeInfo ai) {
        if (this.attributes == null) {
            this.attributes = new ArrayList(5);
        }
        this.attributes.add(ai);
    }

    void compile(Buffer buf) {
        int attrLen = this.attributes == null ? 0 : this.attributes.size();
        buf.u2(this.accessFlags);
        buf.u2(this.name);
        buf.u2(this.type);
        buf.u2(attrLen);
        for (int i = 0; i < attrLen; ++i) {
            this.attributes.get(i).compile(buf);
        }
    }
}

