/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import obix.ContractRegistry;
import obix.IObj;
import obix.asm.Assembler;
import obix.asm.Buffer;
import obix.asm.Code;
import obix.asm.MethodInfo;
import obix.asm.OpCodes;

public class ObixAssembler
extends Assembler
implements OpCodes {
    static AsmClassLoader classLoader = new AsmClassLoader();
    static final Object nameLock = new Object();
    static final Object loadLock = new Object();
    static HashMap<String, Buffer> loadClassFiles = new HashMap();
    static int nextName = 0;
    private int objAdd;
    private int objAddWithName;
    private int objGet;
    private int decoderFromString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> compile(Class<?> superClass, Class<?>[] interfaces) throws Exception {
        if (interfaces.length == 0) {
            return superClass;
        }
        String name = null;
        Object object = nameLock;
        synchronized (object) {
            name = "obix$" + nextName++;
        }
        ObixAssembler asm = new ObixAssembler(name, superClass, interfaces);
        Code ctor = new Code(asm);
        ctor.add(42);
        ctor.add(183, asm.cp.method(asm.superClass, "<init>", "()V"));
        HashMap<String, Method> done = new HashMap<String, Method>();
        for (int i = 0; i < interfaces.length; ++i) {
            asm.compileInterface(interfaces[i], done, ctor);
        }
        ctor.add(177);
        asm.addMethod(new MethodInfo((Assembler)asm, "<init>", "()V", 1, ctor));
        Buffer classFile = asm.compile();
        Object object2 = loadLock;
        synchronized (object2) {
            loadClassFiles.put(name, classFile);
        }
        return classLoader.loadClass(name);
    }

    private void compileInterface(Class<?> iface, HashMap<String, Method> done, Code ctor) {
        if (!iface.isInterface() || !IObj.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Invalid contract interface: + " + iface);
        }
        Method[] methods = iface.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getDeclaringClass() == IObj.class || done.get(m.getName()) != null) continue;
            done.put(m.getName(), m);
            this.compileSubObject(ctor, m);
        }
    }

    private void compileSubObject(Code ctor, Method m) {
        String name = m.getName();
        Class<?> type = m.getReturnType();
        if (m.getParameterTypes().length != 0 || !IObj.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Incorrect contract method: " + m);
        }
        String contract = null;
        try {
            Field field = m.getDeclaringClass().getField(name + "Contract");
            contract = (String)field.get(null);
        }
        catch (Exception field) {
            // empty catch block
        }
        int cpType = this.cp.cls(type);
        int cpName = this.cp.string(name);
        if (contract == null) {
            ctor.add(42);
            ctor.add(18, cpName);
            ctor.add(187, cpType);
            ctor.add(89);
            ctor.add(183, this.cp.method(cpType, "<init>", "()V"));
            ctor.add(182, this.objAddWithName());
            ctor.add(87);
        } else {
            ctor.add(42);
            ctor.add(18, this.cp.string(contract));
            ctor.add(184, this.decoderFromString());
            ctor.add(182, this.objAdd());
            ctor.add(87);
        }
        Code getter = new Code(this);
        getter.add(42);
        getter.add(18, cpName);
        getter.add(182, this.objGet());
        getter.add(192, cpType);
        getter.add(176);
        this.addMethod(new MethodInfo((Assembler)this, name, "()L" + type.getName().replace('.', '/') + ";", 1, getter));
    }

    private ObixAssembler(String thisClass, Class<?> superClass, Class<?>[] interfaces) {
        super(thisClass, superClass, 1, interfaces);
    }

    private int objAdd() {
        if (this.objAdd == 0) {
            this.objAdd = this.cp.method("obix/Obj", "add", "(Lobix/Obj;)Lobix/Obj;");
        }
        return this.objAdd;
    }

    private int objAddWithName() {
        if (this.objAddWithName == 0) {
            this.objAddWithName = this.cp.method("obix/Obj", "add", "(Ljava/lang/String;Lobix/Obj;)Lobix/Obj;");
        }
        return this.objAddWithName;
    }

    private int objGet() {
        if (this.objGet == 0) {
            this.objGet = this.cp.method("obix/Obj", "get", "(Ljava/lang/String;)Lobix/Obj;");
        }
        return this.objGet;
    }

    private int decoderFromString() {
        if (this.decoderFromString == 0) {
            this.decoderFromString = this.cp.method("obix/io/ObixDecoder", "fromString", "(Ljava/lang/String;)Lobix/Obj;");
        }
        return this.decoderFromString;
    }

    static class AsmClassLoader
    extends ClassLoader {
        AsmClassLoader() {
            super(ContractRegistry.getContractClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Buffer classFile = null;
            Object object = loadLock;
            synchronized (object) {
                classFile = loadClassFiles.get(name);
                if (classFile != null) {
                    loadClassFiles.remove(name);
                }
            }
            if (classFile != null) {
                return this.defineClass(name, classFile.bytes, 0, classFile.count);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

