/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.ContractRegistry;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.io.JException;
import obix.io.ObixDecoder;
import obix.xml.XElem;

public class ObixJsonDecoder
extends ObixDecoder {
    private JSONTokener tokener;

    public ObixJsonDecoder(InputStream in) throws Exception {
        super(in);
        this.tokener = new JSONTokener((Reader)new InputStreamReader(in));
    }

    @Override
    public Obj decode() throws Exception {
        JSONObject json = new JSONObject(this.tokener);
        return this.decode(null, json, null);
    }

    private Obj decode(Obj parent, JSONObject j, Contract defaultContract) throws Exception {
        Val r;
        String elemName = JSONUtil.getString((JSONObject)j, (String)"type");
        String name = j.optString("name", null);
        String val = j.optString("val", null);
        String href = j.optString("href", null);
        String is = j.optString("is", null);
        String of = j.optString("of", null);
        String in = j.optString("in", null);
        String out = j.optString("out", null);
        String display = j.optString("display", null);
        String displayName = j.optString("displayName", null);
        String icon = j.optString("icon", null);
        String isNull = j.optString("null", null);
        String writable = j.optString("writable", null);
        String status = j.optString("status", null);
        String range = j.optString("range", null);
        String min = j.optString("min", null);
        String max = j.optString("max", null);
        String unit = j.optString("unit", null);
        String precision = j.optString("precision", null);
        String tz = j.optString("tz", null);
        Class<?> cls = Obj.toClass(elemName);
        if (cls == null) {
            System.out.println("WARNING: Unknown element: " + elemName);
            return null;
        }
        Contract contract = null;
        if (is != null) {
            contract = this.decodeContract(is, j);
        }
        Obj obj = null;
        if (parent != null && name != null) {
            obj = parent.get(name);
        }
        if (obj == null) {
            if (this.getUseContracts()) {
                if (contract != null) {
                    cls = ContractRegistry.toClass(cls, contract);
                } else if (defaultContract != null) {
                    cls = ContractRegistry.toClass(cls, defaultContract);
                }
            }
            obj = (Obj)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        } else if (!elemName.equals(obj.getElement())) {
            if (elemName.equals("ref") || obj.getElement().equals("obj")) {
                Obj newObj = Obj.toObj(elemName);
                if (newObj != null) {
                    newObj.setName(name);
                    if (obj.getParent() != null) {
                        obj.getParent().replace(obj, newObj);
                    }
                    obj = newObj;
                }
            } else {
                throw this.err("Type name '" + elemName + "' conflicts with contract element '" + obj.getElement() + "'", j);
            }
        }
        if (name != null && obj.getName() == null) {
            obj.setName(name);
        }
        if (href != null) {
            if (obj instanceof Ref) {
                obj.setHref(this.decodeRefUri(href, j));
            } else {
                this.decodeHref(obj, href);
            }
        }
        if (contract != null) {
            obj.setIs(contract);
        }
        if (val != null) {
            if (isNull == null) {
                obj.setNull(false);
            }
            try {
                ((Val)obj).decodeVal(val);
            }
            catch (Exception e) {
                throw this.err("Invalid val attribte '" + val + "' for " + obj.getElement(), j, e);
            }
        }
        if (display != null) {
            obj.setDisplay(display);
        }
        if (displayName != null) {
            obj.setDisplayName(displayName);
        }
        if (icon != null) {
            obj.setIcon(new Uri(icon));
        }
        if (status != null) {
            obj.setStatus(Status.parse(status));
        }
        if (isNull != null) {
            obj.setNull(isNull.equals("true"));
        }
        if (writable != null) {
            obj.setWritable(writable.equals("true"));
        }
        Contract childrenDefaultContract = null;
        if (obj instanceof List) {
            List list = (List)obj;
            if (of != null) {
                childrenDefaultContract = this.decodeContract(of, j);
                list.setOf(childrenDefaultContract);
            }
            if (min != null) {
                list.setMin(Integer.parseInt(min));
            }
            if (max != null) {
                list.setMax(Integer.parseInt(max));
            }
        } else if (obj instanceof Op) {
            Op op = (Op)obj;
            if (in != null) {
                op.setIn(this.decodeContract(in, j));
            }
            if (out != null) {
                op.setOut(this.decodeContract(out, j));
            }
        } else if (obj instanceof Bool) {
            Bool b = (Bool)obj;
            if (range != null) {
                b.setRange(this.decodeRefUri(range, j));
            }
        } else if (obj instanceof Int) {
            Int i = (Int)obj;
            if (min != null) {
                i.setMin(Long.parseLong(min));
            }
            if (max != null) {
                i.setMax(Long.parseLong(max));
            }
            if (unit != null) {
                i.setUnit(this.decodeRefUri(unit, j));
            }
        } else if (obj instanceof Str) {
            Str s = (Str)obj;
            if (min != null) {
                s.setMin(Integer.parseInt(min));
            }
            if (max != null) {
                s.setMax(Integer.parseInt(max));
            }
        } else if (obj instanceof Real) {
            r = (Real)obj;
            if (min != null) {
                ((Real)r).setMin(Double.parseDouble(min));
            }
            if (max != null) {
                ((Real)r).setMax(Double.parseDouble(max));
            }
            if (unit != null) {
                ((Real)r).setUnit(this.decodeRefUri(unit, j));
            }
            if (precision != null) {
                ((Real)r).setPrecision(Integer.parseInt(precision));
            }
        } else if (obj instanceof Enum) {
            Enum e = (Enum)obj;
            if (range != null) {
                e.setRange(this.decodeRefUri(range, j));
            }
        } else if (obj instanceof Reltime) {
            r = (Reltime)obj;
            if (min != null) {
                ((Reltime)r).setMin(Reltime.parse(min));
            }
            if (max != null) {
                ((Reltime)r).setMax(Reltime.parse(max));
            }
        } else if (obj instanceof Abstime) {
            Abstime a = (Abstime)obj;
            if (min != null) {
                a.setMin(Abstime.parse(min));
            }
            if (max != null) {
                a.setMax(Abstime.parse(max));
            }
            if (tz != null) {
                a.setTz(tz);
            }
        } else if (obj instanceof Time) {
            Time t = (Time)obj;
            if (min != null) {
                t.setMin(Time.parse(min));
            }
            if (max != null) {
                t.setMax(Time.parse(max));
            }
            if (tz != null) {
                t.setTz(tz);
            }
        } else if (obj instanceof Date) {
            Date d = (Date)obj;
            if (min != null) {
                d.setMin(Date.parse(min));
            }
            if (max != null) {
                d.setMax(Date.parse(max));
            }
            if (tz != null) {
                d.setTz(tz);
            }
        } else if (obj instanceof Feed) {
            Feed feed = (Feed)obj;
            if (in != null) {
                feed.setIn(this.decodeContract(in, j));
            }
            if (of != null) {
                feed.setOf(this.decodeContract(of, j));
            }
        }
        JSONArray kids = j.optJSONArray("kids");
        if (kids != null) {
            for (int i = 0; i < kids.length(); ++i) {
                Obj kid = this.decode(obj, kids.getJSONObject(i), childrenDefaultContract);
                if (kid == null || kid.getParent() != null) continue;
                try {
                    obj.add(kid);
                    continue;
                }
                catch (Exception e) {
                    throw this.err("Cannot add child '" + name + "'", kids.optJSONObject(i), e);
                }
            }
        }
        return obj;
    }

    void decodeHref(Obj obj, String href) {
        Uri uri = new Uri(null, href);
        obj.setHref(uri);
        if (!uri.isFragment()) {
            return;
        }
        this.fragIds.put(href, obj);
        ObixDecoder.FragRefs refs = (ObixDecoder.FragRefs)this.fragRefs.get(href);
        if (refs == null) {
            return;
        }
        this.fragRefs.remove(href);
        for (int i = 0; i < refs.uris.size(); ++i) {
            refs.uris.get(i).setResolved(obj);
        }
    }

    Uri decodeRefUri(String s, JSONObject j) {
        Uri uri = new Uri(s);
        if (!uri.isFragment()) {
            return uri;
        }
        Obj resolved = (Obj)this.fragIds.get(s);
        if (resolved != null) {
            uri.setResolved(resolved);
            return uri;
        }
        ObixDecoder.FragRefs refs = (ObixDecoder.FragRefs)this.fragRefs.get(s);
        if (refs == null) {
            refs = new ObixDecoder.FragRefs();
            this.fragRefs.put(s, refs);
        }
        refs.uris.add(uri);
        refs.elems.add(j);
        return uri;
    }

    Contract decodeContract(String s, JSONObject j) {
        StringTokenizer st = new StringTokenizer(s, " ");
        ArrayList<Uri> acc = new ArrayList<Uri>();
        while (st.hasMoreTokens()) {
            acc.add(this.decodeRefUri(st.nextToken(), j));
        }
        return new Contract(acc.toArray(new Uri[0]));
    }

    void warningsForUnresolvedFragRefs() {
        ObixDecoder.FragRefs[] unresolved = this.fragRefs.values().toArray(new ObixDecoder.FragRefs[0]);
        for (int i = 0; i < unresolved.length; ++i) {
            ObixDecoder.FragRefs r = unresolved[i];
            for (int j = 0; j < r.uris.size(); ++j) {
                Uri uri = r.uris.get(j);
                XElem elem = (XElem)r.elems.get(j);
                this.warning("Unresolved fragment reference '" + uri + "'", elem);
            }
        }
    }

    JException err(String msg, JSONObject j, Throwable cause) {
        return new JException(msg, j, cause);
    }

    JException err(String msg, JSONObject j) {
        return new JException(msg, j);
    }

    void warning(String msg, XElem elem) {
        String line = "";
        if (elem != null) {
            line = " [line " + elem.line() + "]";
        }
        System.out.println("WARNING: " + msg + line);
    }
}

