/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import com.tridium.json.JSONException;
import com.tridium.json.JSONWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;

public class ObixJsonEncoder
extends ObixEncoder {
    private Writer writer;
    private JSONWriter jout;
    private final ObixEncoder.Buffer buffer = new ObixEncoder.Buffer();

    public ObixJsonEncoder(File file) throws IOException {
        super(file);
        this.init();
    }

    public ObixJsonEncoder(OutputStream out) throws IOException {
        super(out);
        this.init();
    }

    private void init() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.buffer, "UTF8");
            this.jout = new JSONWriter((Appendable)this.writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void encode(Obj obj) {
        try {
            this.jout.object();
            this.jout.key("type").value((Object)obj.getElement());
            this.encodeAttribs(obj);
            if (obj.size() > 0) {
                this.jout.key("kids").array();
                Obj[] kids = obj.list();
                for (int i = 0; i < kids.length; ++i) {
                    this.encode(kids[i]);
                }
                this.jout.endArray();
            }
            this.jout.endObject();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
            int size = this.buffer.size();
            if (size > 0) {
                this.out.write(this.buffer.getBytes(), 0, size);
                this.out.flush();
            }
            this.buffer.reset();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public String getContentType() {
        return "application/vnd.tridium.com-obix+json";
    }

    private void encodeAttribs(Obj obj) throws JSONException {
        Val r;
        Uri href;
        String name = obj.getName();
        if (name != null) {
            this.jout.key("name").value((Object)name);
        }
        if ((href = obj.getHref()) != null) {
            this.jout.key("href").value((Object)href.encodeVal());
        }
        if (obj instanceof Val) {
            this.encodeVal((Val)obj);
        } else if (obj instanceof List) {
            List list = (List)obj;
            Contract of = list.getOf();
            if (!of.containsOnlyObj()) {
                this.jout.key("of").value((Object)of.toString());
            }
        } else if (obj instanceof Op) {
            Op op = (Op)obj;
            this.jout.key("in").value((Object)op.getIn().toString());
            this.jout.key("out").value((Object)op.getOut().toString());
        } else if (obj instanceof Feed) {
            Feed feed = (Feed)obj;
            this.jout.key("in").value((Object)feed.getIn().toString());
            this.jout.key("of").value((Object)feed.getOf().toString());
        }
        Contract is = obj.getIs();
        if (is != null) {
            this.jout.key("is").value((Object)is.toString());
        }
        if (obj.getDisplay() != null) {
            this.jout.key("display").value((Object)obj.getDisplay().toString());
        }
        if (obj.getDisplayName() != null) {
            this.jout.key("displayName").value((Object)obj.getDisplayName().toString());
        }
        if (obj.getIcon() != null) {
            this.jout.key("icon").value((Object)obj.getIcon().toString());
        }
        if (obj.getStatus() != Status.ok) {
            this.jout.key("status").value((Object)obj.getStatus().toString());
        }
        if (obj.isNull()) {
            this.jout.key("null").value((Object)"true");
        }
        if (obj.isWritable()) {
            this.jout.key("writable").value((Object)"true");
        }
        if (obj instanceof Bool) {
            Bool b = (Bool)obj;
            if (b.getRange() != null) {
                this.jout.key("range").value((Object)b.getRange().toString());
            }
        } else if (obj instanceof Int) {
            Int i = (Int)obj;
            if (i.getMin() != Long.MIN_VALUE) {
                this.jout.key("min").value((Object)String.valueOf(i.getMin()));
            }
            if (i.getMax() != Long.MAX_VALUE) {
                this.jout.key("max").value((Object)String.valueOf(i.getMax()));
            }
            if (i.getUnit() != null) {
                this.jout.key("unit").value((Object)i.getUnit().toString());
            }
        } else if (obj instanceof Str) {
            Str s = (Str)obj;
            if (s.getMin() != 0) {
                this.jout.key("min").value((Object)String.valueOf(s.getMin()));
            }
            if (s.getMax() != Integer.MAX_VALUE) {
                this.jout.key("max").value((Object)String.valueOf(s.getMax()));
            }
        } else if (obj instanceof Enum) {
            Enum e = (Enum)obj;
            if (e.getRange() != null) {
                this.jout.key("range").value((Object)e.getRange().toString());
            }
        } else if (obj instanceof Real) {
            r = (Real)obj;
            if (((Real)r).getMin() != Double.NEGATIVE_INFINITY) {
                this.jout.key("min").value((Object)String.valueOf(((Real)r).getMin()));
            }
            if (((Real)r).getMax() != Double.POSITIVE_INFINITY) {
                this.jout.key("max").value((Object)String.valueOf(((Real)r).getMax()));
            }
            if (((Real)r).getUnit() != null) {
                this.jout.key("unit").value((Object)((Real)r).getUnit().toString());
            }
            if (((Real)r).getPrecision() != 1) {
                this.jout.key("precision").value((Object)String.valueOf(((Real)r).getPrecision()));
            }
        } else if (obj instanceof Reltime) {
            r = (Reltime)obj;
            if (((Reltime)r).getMin() != null) {
                this.jout.key("min").value((Object)((Reltime)r).getMin().encodeVal());
            }
            if (((Reltime)r).getMax() != null) {
                this.jout.key("max").value((Object)((Reltime)r).getMax().encodeVal());
            }
        } else if (obj instanceof Abstime) {
            Abstime a = (Abstime)obj;
            if (a.getMin() != null) {
                this.jout.key("min").value((Object)a.getMin().encodeVal());
            }
            if (a.getMax() != null) {
                this.jout.key("max").value((Object)a.getMax().encodeVal());
            }
            if (a.getTz() != null) {
                this.jout.key("tz").value((Object)a.getTz());
            }
        } else if (obj instanceof Time) {
            Time t = (Time)obj;
            if (t.getMin() != null) {
                this.jout.key("min").value((Object)t.getMin().encodeVal());
            }
            if (t.getMax() != null) {
                this.jout.key("max").value((Object)t.getMax().encodeVal());
            }
            if (t.getTz() != null) {
                this.jout.key("tz").value((Object)t.getTz());
            }
        } else if (obj instanceof Date) {
            Date d = (Date)obj;
            if (d.getMin() != null) {
                this.jout.key("min").value((Object)d.getMin().encodeVal());
            }
            if (d.getMax() != null) {
                this.jout.key("max").value((Object)d.getMax().encodeVal());
            }
            if (d.getTz() != null) {
                this.jout.key("tz").value((Object)d.getTz());
            }
        } else if (obj instanceof List) {
            List l = (List)obj;
            if (l.getMin() != 0) {
                this.jout.key("min").value((Object)String.valueOf(l.getMin()));
            }
            if (l.getMax() != Integer.MAX_VALUE) {
                this.jout.key("max").value((Object)String.valueOf(l.getMax()));
            }
        }
    }

    private void encodeVal(Val v) throws JSONException {
        if (v instanceof Bool) {
            this.jout.key("val").value(((Bool)v).get());
        } else if (v instanceof Real) {
            this.jout.key("val").value(((Real)v).get());
        } else if (v instanceof Int) {
            this.jout.key("val").value(((Int)v).get());
        } else {
            this.jout.key("val").value((Object)v.encodeVal());
        }
    }
}

