/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;
import obix.xml.XWriter;

public class ObixXmlEncoder
extends ObixEncoder {
    private static String OBIX_NS = "http://obix.org/ns/schema/1.0";
    private XWriter writer;
    private final ObixEncoder.Buffer buffer = new ObixEncoder.Buffer();
    private String xslPath = null;
    private String xsdPath = null;

    public ObixXmlEncoder(File file) throws IOException {
        super(file);
        this.init();
    }

    public ObixXmlEncoder(OutputStream out) throws IOException {
        super(out);
        this.init();
    }

    @Override
    public void encode(Obj obj) {
        this.doEncode(obj, 0);
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
            int size = this.buffer.size();
            if (size > 0) {
                this.out.write(this.buffer.getBytes(), 0, size);
                this.out.flush();
            }
            this.buffer.reset();
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    @Override
    public String getContentType() {
        return "application/vnd.tridium.com-obix+xml";
    }

    private void init() {
        try {
            this.writer = new XWriter(this.buffer);
            this.writer.prolog();
            if (this.xslPath != null) {
                this.writer.w("<?xml-stylesheet type='text/xsl' href='");
                this.writer.w(this.xslPath).w("'?>\n");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void encodeMagicXmlAttributes() {
        this.writer.w(' ').attr("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.xsdPath != null) {
            this.writer.w(' ').attr("xsi:schemaLocation", OBIX_NS + " " + this.xsdPath);
        }
        this.writer.w(' ').attr("xmlns", OBIX_NS);
    }

    private void doEncode(Obj obj, int indent) {
        Val r;
        Uri href;
        String elemName = obj.getElement();
        this.writer.indent(indent * 2).w('<').w(elemName);
        String name = obj.getName();
        if (name != null) {
            this.writer.attr(" name", name);
        }
        if ((href = obj.getHref()) != null) {
            this.writer.attr(" href", href.encodeVal());
        }
        if (obj instanceof Val) {
            Val val = (Val)obj;
            this.writer.attr(" val", val.encodeVal());
        } else if (obj instanceof List) {
            List list = (List)obj;
            Contract of = list.getOf();
            if (!of.containsOnlyObj()) {
                this.writer.attr(" of", of.toString());
            }
        } else if (obj instanceof Op) {
            Op op = (Op)obj;
            this.writer.attr(" in", op.getIn().toString());
            this.writer.attr(" out", op.getOut().toString());
        } else if (obj instanceof Feed) {
            Feed feed = (Feed)obj;
            this.writer.attr(" in", feed.getIn().toString());
            this.writer.attr(" of", feed.getOf().toString());
        }
        Contract is = obj.getIs();
        if (is != null) {
            this.writer.attr(" is", is.toString());
        }
        if (obj.getDisplay() != null) {
            this.writer.attr(" display", obj.getDisplay().toString());
        }
        if (obj.getDisplayName() != null) {
            this.writer.attr(" displayName", obj.getDisplayName().toString());
        }
        if (obj.getIcon() != null) {
            this.writer.attr(" icon", obj.getIcon().toString());
        }
        if (obj.getStatus() != Status.ok) {
            this.writer.attr(" status", obj.getStatus().toString());
        }
        if (obj.isNull()) {
            this.writer.attr(" null", "true");
        }
        if (obj.isWritable()) {
            this.writer.attr(" writable", "true");
        }
        if (obj instanceof Bool) {
            Bool b = (Bool)obj;
            if (b.getRange() != null) {
                this.writer.attr(" range", b.getRange().toString());
            }
        } else if (obj instanceof Int) {
            Int i = (Int)obj;
            if (i.getMin() != Long.MIN_VALUE) {
                this.writer.attr(" min", String.valueOf(i.getMin()));
            }
            if (i.getMax() != Long.MAX_VALUE) {
                this.writer.attr(" max", String.valueOf(i.getMax()));
            }
            if (i.getUnit() != null) {
                this.writer.attr(" unit", i.getUnit().toString());
            }
        } else if (obj instanceof Str) {
            Str s = (Str)obj;
            if (s.getMin() != 0) {
                this.writer.attr(" min", String.valueOf(s.getMin()));
            }
            if (s.getMax() != Integer.MAX_VALUE) {
                this.writer.attr(" max", String.valueOf(s.getMax()));
            }
        } else if (obj instanceof Enum) {
            Enum e = (Enum)obj;
            if (e.getRange() != null) {
                this.writer.attr(" range", e.getRange().toString());
            }
        } else if (obj instanceof Real) {
            r = (Real)obj;
            if (((Real)r).getMin() != Double.NEGATIVE_INFINITY) {
                this.writer.attr(" min", String.valueOf(((Real)r).getMin()));
            }
            if (((Real)r).getMax() != Double.POSITIVE_INFINITY) {
                this.writer.attr(" max", String.valueOf(((Real)r).getMax()));
            }
            if (((Real)r).getUnit() != null) {
                this.writer.attr(" unit", ((Real)r).getUnit().toString());
            }
            if (((Real)r).getPrecision() != 1) {
                this.writer.attr(" precision", String.valueOf(((Real)r).getPrecision()));
            }
        } else if (obj instanceof Reltime) {
            r = (Reltime)obj;
            if (((Reltime)r).getMin() != null) {
                this.writer.attr(" min", ((Reltime)r).getMin().encodeVal());
            }
            if (((Reltime)r).getMax() != null) {
                this.writer.attr(" max", ((Reltime)r).getMax().encodeVal());
            }
        } else if (obj instanceof Abstime) {
            Abstime a = (Abstime)obj;
            if (a.getMin() != null) {
                this.writer.attr(" min", a.getMin().encodeVal());
            }
            if (a.getMax() != null) {
                this.writer.attr(" max", a.getMax().encodeVal());
            }
            if (a.getTz() != null) {
                this.writer.attr(" tz", a.getTz());
            }
        } else if (obj instanceof Time) {
            Time t = (Time)obj;
            if (t.getMin() != null) {
                this.writer.attr(" min", t.getMin().encodeVal());
            }
            if (t.getMax() != null) {
                this.writer.attr(" max", t.getMax().encodeVal());
            }
            if (t.getTz() != null) {
                this.writer.attr(" tz", t.getTz());
            }
        } else if (obj instanceof Date) {
            Date d = (Date)obj;
            if (d.getMin() != null) {
                this.writer.attr(" min", d.getMin().encodeVal());
            }
            if (d.getMax() != null) {
                this.writer.attr(" max", d.getMax().encodeVal());
            }
            if (d.getTz() != null) {
                this.writer.attr(" tz", d.getTz());
            }
        } else if (obj instanceof List) {
            List l = (List)obj;
            if (l.getMin() != 0) {
                this.writer.attr(" min", String.valueOf(l.getMin()));
            }
            if (l.getMax() != Integer.MAX_VALUE) {
                this.writer.attr(" max", String.valueOf(l.getMax()));
            }
        }
        if (indent == 0) {
            this.encodeMagicXmlAttributes();
        }
        if (obj.size() == 0) {
            this.writer.w("/>\n");
            return;
        }
        this.writer.w(">\n");
        Obj[] kids = obj.list();
        for (int i = 0; i < kids.length; ++i) {
            this.doEncode(kids[i], indent + 1);
        }
        this.writer.indent(indent * 2).w("</").w(elemName).w(">\n");
    }
}

