/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import obix.Contract;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.net.ObixSession;

public class BatchIn
extends List {
    public static final Contract uriContract = new Contract("obix:uri");
    public static final Contract batchInContract = new Contract("obix:BatchIn");
    public static final Contract readContract = new Contract("obix:Read");
    public static final Contract writeContract = new Contract("obix:Write");
    public static final Contract invokeContract = new Contract("obix:Invoke");
    ObixSession session;

    BatchIn(ObixSession session) {
        this.setOf(uriContract);
        this.setIs(batchInContract);
        this.session = session;
    }

    public ObixSession getSession() {
        return this.session;
    }

    public void read(Uri uri) throws Exception {
        uri.setIs(readContract);
        this.add(uri);
    }

    public void write(Obj obj) throws Exception {
        Uri uri = obj.getHref();
        uri.setIs(writeContract);
        obj.setName("in");
        uri.add(obj);
        this.add(uri);
    }

    public void invoke(Op op, Obj in) throws Exception {
        Uri href = op.getHref();
        if (href == null) {
            throw new Exception("op.href is null");
        }
        this.invoke(href, in);
    }

    public void invoke(Uri uri, Obj in) throws Exception {
        if (in == null) {
            in = new Obj();
            in.setNull(true);
        }
        uri.setIs(invokeContract);
        in.setName("in");
        uri.add(in);
        this.add(uri);
    }

    public List commit() throws Exception {
        return (List)this.session.invoke(this.session.batchUri, (Obj)this);
    }
}

