/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.util.SimpleTimeZone;
import java.util.TimeZone;
import obix.Abstime;
import obix.test.Test;

public class AbstimeTest
extends Test {
    public static TimeZone[] timeZones = new TimeZone[]{TimeZone.getDefault(), TimeZone.getTimeZone("GMT"), TimeZone.getTimeZone("America/New_York"), TimeZone.getTimeZone("America/Phoenix"), TimeZone.getTimeZone("America/Los_Angeles"), TimeZone.getTimeZone("US/Mountain"), TimeZone.getTimeZone("Europe/Brussels"), TimeZone.getTimeZone("Europe/Vienna"), TimeZone.getTimeZone("Asia/Tokyo"), TimeZone.getTimeZone("Asia/Hong_Kong"), new SimpleTimeZone(-14400000, "Offset1"), new SimpleTimeZone(-18000000, "Offset2")};
    public static final int january = 1;
    public static final int february = 2;
    public static final int march = 3;
    public static final int april = 4;
    public static final int may = 5;
    public static final int june = 6;
    public static final int july = 7;
    public static final int august = 8;
    public static final int september = 9;
    public static final int october = 10;
    public static final int november = 11;
    public static final int december = 12;
    public static final int sunday = 0;
    public static final int monday = 1;
    public static final int tuesday = 2;
    public static final int wednesday = 3;
    public static final int thursday = 4;
    public static final int friday = 5;
    public static final int saturday = 6;

    @Override
    public void run() throws Exception {
        this.verifyBasics();
        this.verifyCodec();
        this.verifyLeapYears();
        this.verifyDaysInMonth();
        this.verifyTimeOfDayMillis();
        this.verifyNextPrevDay();
        this.verifyNextPrevMonth();
        this.verifyNextPrevYear();
        this.verifyNextPrevWeekdays();
    }

    public void verifyBasics() {
        TimeZone est = TimeZone.getTimeZone("America/New_York");
        Abstime t = new Abstime(2005, 9, 21, 10, 59, 7, 654, est);
        this.verify(t.getTimeZone() == est);
        this.verify(t.getYear() == 2005);
        this.verify(t.getMonth() == 9);
        this.verify(t.getDay() == 21);
        this.verify(t.getHour() == 10);
        this.verify(t.getMinute() == 59);
        this.verify(t.getSecond() == 7);
        this.verify(t.getMillisecond() == 654);
        this.verify(t.inDaylightTime());
        this.verify(t.getTimeZoneOffset() == -14400000);
        t = new Abstime(2005, 12, 25, 13, 2, 0, 0, est);
        this.verify(t.getTimeZone() == est);
        this.verify(t.getYear() == 2005);
        this.verify(t.getMonth() == 12);
        this.verify(t.getDay() == 25);
        this.verify(t.getHour() == 13);
        this.verify(t.getMinute() == 2);
        this.verify(t.getSecond() == 0);
        this.verify(t.getMillisecond() == 0);
        this.verify(!t.inDaylightTime());
        this.verify(t.getTimeZoneOffset() == -18000000);
        t = new Abstime(1127314741310L, est);
        this.verify(t.getYear() == 2005);
        this.verify(t.getMonth() == 9);
        this.verify(t.getDay() == 21);
        this.verify(t.getHour() == 10);
        this.verify(t.getMinute() == 59);
        this.verify(t.getSecond() == 1);
        this.verify(t.getMillisecond() == 310);
        this.verify(t.inDaylightTime());
        this.verify(t.getTimeZoneOffset() == -14400000);
        t = t.toUtcTime();
        this.verify(t.getYear() == 2005);
        this.verify(t.getMonth() == 9);
        this.verify(t.getDay() == 21);
        this.verify(t.getHour() == 14);
        this.verify(t.getMinute() == 59);
        this.verify(t.getSecond() == 1);
        this.verify(t.getMillisecond() == 310);
        this.verify(!t.inDaylightTime());
        this.verify(t.getTimeZoneOffset() == 0);
        this.verify(t.encodeVal().equals("2005-09-21T14:59:01.310Z"));
        t = t.toLocalTime();
        this.verify(t.getYear() == 2005);
        this.verify(t.getMonth() == 9);
        this.verify(t.getDay() == 21);
        this.verify(t.getHour() == 10);
        this.verify(t.getMinute() == 59);
        this.verify(t.getSecond() == 1);
        this.verify(t.getMillisecond() == 310);
        this.verify(t.inDaylightTime());
        this.verify(t.getTimeZoneOffset() == -14400000);
        this.verify(t.encodeVal().equals("2005-09-21T10:59:01.310-04:00"));
    }

    public void verifyCodec() throws Exception {
        for (int i = 0; i < timeZones.length; ++i) {
            for (int j = 0; j < timeZones.length; ++j) {
                TimeZone iz = timeZones[i];
                TimeZone jz = timeZones[j];
                Abstime[] times = new Abstime[]{new Abstime(System.currentTimeMillis()), new Abstime(System.currentTimeMillis(), iz), new Abstime(System.currentTimeMillis(), jz), new Abstime(2001, 6, 7, 0, 0, 0, 0, iz), new Abstime(2001, 6, 7, 0, 0, 0, 0, jz), new Abstime(2001, 11, 30, 0, 0, 0, 0, iz), new Abstime(2001, 11, 30, 0, 0, 0, 0, jz), new Abstime(1004553579152L, iz), new Abstime(1004553579152L, jz)};
                for (int k = 0; k < times.length; ++k) {
                    for (int m = 0; m < times.length; ++m) {
                        Abstime t = times[k];
                        Abstime x = new Abstime();
                        x.decodeVal(t.encodeVal());
                        this.verify(t.equals(x));
                    }
                }
            }
        }
        Abstime t = new Abstime();
        t.decodeVal("2005-09-21T13:14:02.1234567Z");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 123, TimeZone.getTimeZone("UTC"))));
        t.decodeVal("2005-09-21T13:14:02.1234567-05:00");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 123, TimeZone.getTimeZone("EST"))));
        t.decodeVal("2005-09-21T13:14:02Z");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 0, TimeZone.getTimeZone("UTC"))));
        t.decodeVal("2005-09-21T13:14:02.7Z");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 700, TimeZone.getTimeZone("UTC"))));
        t.decodeVal("2005-09-21T13:14:02.74Z");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 740, TimeZone.getTimeZone("UTC"))));
        t.decodeVal("2005-09-21T13:14:02.005Z");
        this.verify(t.equals(new Abstime(2005, 9, 21, 13, 14, 2, 5, TimeZone.getTimeZone("UTC"))));
    }

    public void verifyNextPrevDay() {
        Abstime start = new Abstime(2001, 10, 28, 0, 0, 0, 0);
        Abstime next = start.nextDay();
        this.verify(next.equals(new Abstime(2001, 10, 29, 0, 0, 0, 0)));
        this.verify(next.prevDay().equals(start));
        start = next;
        next = start.nextDay();
        this.verify(next.equals(new Abstime(2001, 10, 30, 0, 0, 0, 0)));
        this.verify(next.prevDay().equals(start));
        start = new Abstime(2001, 12, 31, 0, 0, 0, 0);
        next = start.nextDay();
        this.verify(next.equals(new Abstime(2002, 1, 1, 0, 0, 0, 0)));
        this.verify(next.prevDay().equals(start));
    }

    public void verifyNextPrevMonth() {
        this.verify(new Abstime(2003, 7, 17).nextMonth().equals(new Abstime(2003, 8, 17)));
        this.verify(new Abstime(2003, 7, 17).prevMonth().equals(new Abstime(2003, 6, 17)));
        this.verify(new Abstime(2003, 12, 17).nextMonth().equals(new Abstime(2004, 1, 17)));
        this.verify(new Abstime(2003, 1, 17).prevMonth().equals(new Abstime(2002, 12, 17)));
        this.verify(new Abstime(2003, 1, 31).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 30).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 29).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 28).nextMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 1, 27).nextMonth().equals(new Abstime(2003, 2, 27)));
        this.verify(new Abstime(2004, 3, 31).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 30).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 29).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 3, 28).prevMonth().equals(new Abstime(2004, 2, 28)));
        this.verify(new Abstime(2003, 2, 28).nextMonth().equals(new Abstime(2003, 3, 31)));
        this.verify(new Abstime(2004, 2, 29).nextMonth().equals(new Abstime(2004, 3, 31)));
        this.verify(new Abstime(2004, 3, 31).nextMonth().equals(new Abstime(2004, 4, 30)));
        this.verify(new Abstime(2004, 4, 30).prevMonth().equals(new Abstime(2004, 3, 31)));
        this.verify(new Abstime(2004, 3, 31).prevMonth().equals(new Abstime(2004, 2, 29)));
        this.verify(new Abstime(2004, 2, 28).prevMonth().equals(new Abstime(2004, 1, 28)));
        this.verify(new Abstime(2004, 2, 29).prevMonth().equals(new Abstime(2004, 1, 31)));
        this.verify(new Abstime(2003, 3, 31).prevMonth().equals(new Abstime(2003, 2, 28)));
        this.verify(new Abstime(2003, 2, 28).prevMonth().equals(new Abstime(2003, 1, 31)));
    }

    public void verifyNextPrevYear() {
        this.verify(new Abstime(2003, 4, 30).nextYear().equals(new Abstime(2004, 4, 30)));
        this.verify(new Abstime(2003, 2, 28).nextYear().equals(new Abstime(2004, 2, 28)));
        this.verify(new Abstime(2004, 2, 29).nextYear().equals(new Abstime(2005, 2, 28)));
        this.verify(new Abstime(2003, 4, 30).prevYear().equals(new Abstime(2002, 4, 30)));
        this.verify(new Abstime(2003, 2, 28).prevYear().equals(new Abstime(2002, 2, 28)));
        this.verify(new Abstime(2004, 2, 29).prevYear().equals(new Abstime(2003, 2, 28)));
    }

    public void verifyNextPrevWeekdays() {
        this.verify(new Abstime(2003, 7, 17).nextWeekday(4).equals(new Abstime(2003, 7, 24)));
        this.verify(new Abstime(2003, 7, 17).nextWeekday(5).equals(new Abstime(2003, 7, 18)));
        this.verify(new Abstime(2003, 7, 17).nextWeekday(3).equals(new Abstime(2003, 7, 23)));
        this.verify(new Abstime(2003, 12, 30).nextWeekday(5).equals(new Abstime(2004, 1, 2)));
        this.verify(new Abstime(2003, 11, 3).prevWeekday(4).equals(new Abstime(2003, 10, 30)));
        this.verify(new Abstime(2003, 11, 3).prevWeekday(1).equals(new Abstime(2003, 10, 27)));
    }

    public void verifyLeapYears() {
        this.verify(Abstime.isLeapYear(1996));
        this.verify(!Abstime.isLeapYear(1997));
        this.verify(!Abstime.isLeapYear(1998));
        this.verify(!Abstime.isLeapYear(1999));
        this.verify(Abstime.isLeapYear(2000));
        this.verify(!Abstime.isLeapYear(2001));
        this.verify(!Abstime.isLeapYear(2002));
        this.verify(!Abstime.isLeapYear(2003));
        this.verify(Abstime.isLeapYear(2004));
        this.verify(!Abstime.isLeapYear(2005));
        this.verify(!Abstime.isLeapYear(2006));
        this.verify(!Abstime.isLeapYear(2007));
        this.verify(Abstime.isLeapYear(2008));
        this.verify(Abstime.getDaysInYear(2000) == 366);
        this.verify(Abstime.getDaysInYear(2001) == 365);
    }

    public void verifyDaysInMonth() {
        this.verify(Abstime.getDaysInMonth(2000, 1) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 2) == 29);
        this.verify(Abstime.getDaysInMonth(2001, 2) == 28);
        this.verify(Abstime.getDaysInMonth(2000, 3) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 4) == 30);
        this.verify(Abstime.getDaysInMonth(2000, 5) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 6) == 30);
        this.verify(Abstime.getDaysInMonth(2000, 7) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 8) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 9) == 30);
        this.verify(Abstime.getDaysInMonth(2000, 10) == 31);
        this.verify(Abstime.getDaysInMonth(2000, 11) == 30);
        this.verify(Abstime.getDaysInMonth(2000, 12) == 31);
    }

    public void verifyTimeOfDayMillis() {
        this.verify(0L == new Abstime(2000, 1, 30, 0, 0, 0, 0).getTimeOfDayMillis());
        this.verify(1L == new Abstime(2000, 1, 30, 0, 0, 0, 1).getTimeOfDayMillis());
        this.verify(1000L == new Abstime(2000, 1, 30, 0, 0, 1, 0).getTimeOfDayMillis());
        this.verify(7000L == new Abstime(2000, 1, 30, 0, 0, 7, 0).getTimeOfDayMillis());
        this.verify(60000L == new Abstime(2000, 1, 30, 0, 1, 0, 0).getTimeOfDayMillis());
        this.verify(120000L == new Abstime(2000, 1, 30, 0, 2, 0, 0).getTimeOfDayMillis());
        this.verify(3600000L == new Abstime(2000, 1, 30, 1, 0, 0, 0).getTimeOfDayMillis());
        this.verify(86399999L == new Abstime(2000, 1, 30, 23, 59, 59, 999).getTimeOfDayMillis());
        this.verify(0L == new Abstime(2000, 1, 30, 24, 0, 0, 0).getTimeOfDayMillis());
    }

    public static void dump(TimeZone tz) {
        System.out.println(tz.getID() + " = " + tz.getRawOffset() / 3600000);
    }
}

