/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Uri;
import obix.test.Test;

public class UriTest
extends Test {
    @Override
    public void run() throws Exception {
        this.verifyAbs("http://foo/", "http", "foo", -1, "/");
        this.verifyAbs("http://foo:81/", "http", "foo", 81, "/");
        this.verifyAbs("https://foo/", "https", "foo", -1, "/");
        this.verifyAbs("http://foo.com/", "http", "foo.com", -1, "/");
        this.verifyAbs("http://foo/x", "http", "foo", -1, "/x");
        this.verifyAbs("http://foo/x#f", "http", "foo", -1, "/x", null, "f");
        this.verifyAbs("http://foo/x?q", "http", "foo", -1, "/x", "q", null);
        this.verifyAbs("http://foo/x?q#f", "http", "foo", -1, "/x", "q", "f");
        this.verifyAbs("http://foo/x#f?q", "http", "foo", -1, "/x", null, "f?q");
        this.verifyRel("/", "/", null, null);
        this.verifyRel("/x", "/x", null, null);
        this.verifyRel("", "", null, null);
        this.verifyRel("x", "x", null, null);
        this.verifyRel("/x?q", "/x", "q", null);
        this.verifyRel("x?q", "x", "q", null);
        this.verifyRel("?q", "", "q", null);
        this.verifyRel("#f", "", null, "f");
        this.verifyRel("/x?q#f", "/x", "q", "f");
        this.verifyRel("x?q#f", "x", "q", "f");
        this.verifyRel("?q#f", "", "q", "f");
        this.verifyRel(".", ".", null, null);
        this.verifyRel("..", "..", null, null);
        this.verifyRel("../x", "../x", null, null);
        this.verifyRel("../..", "../..", null, null);
        this.verifyRel("../../x", "../../x", null, null);
        this.verifyNorm("http://foo/", "/", "http://foo/");
        this.verifyNorm("http://foo/", "/x", "http://foo/x");
        this.verifyNorm("http://foo/x", "/y", "http://foo/y");
        this.verifyNorm("http://foo/x", "y", "http://foo/y");
        this.verifyNorm("http://foo/x/", "y", "http://foo/x/y");
        this.verifyNorm("http://foo/x/y", "/z", "http://foo/z");
        this.verifyNorm("http://foo/x/y", "z", "http://foo/x/z");
        this.verifyNorm("http://foo/x/y/", "z", "http://foo/x/y/z");
        this.verifyNorm("http://foo/", "#f", "http://foo/#f");
        this.verifyNorm("http://foo/x", "#f", "http://foo/x#f");
        this.verifyNorm("http://foo/x", "/y#f", "http://foo/y#f");
        this.verifyNorm("http://foo/x", "y#f", "http://foo/y#f");
        this.verifyNorm("http://foo/x/", "y#f", "http://foo/x/y#f");
        this.verifyNorm("http://foo/x/", "..", "http://foo/");
        this.verifyNorm("http://foo/x/y", "..", "http://foo/");
        this.verifyNorm("http://foo/x/y/", "..", "http://foo/x/");
        this.verifyNorm("http://foo/x/y", "../z", "http://foo/z");
        this.verifyNorm("http://foo/x/y/", "../z", "http://foo/x/z");
        this.verifyNorm("http://foo/x/y/", "../..", "http://foo/");
        this.verifyNorm("http://foo/x/y/", "../../z", "http://foo/z");
        this.verifyNorm("http://foo/", "obix:obj", "obix:obj");
        this.verifyAuth("http://foo/", "http://foo/");
        this.verifyAuth("http://foo/file", "http://foo/");
        this.verifyAuth("http://foo/bar#frag", "http://foo/");
        this.verifyAuth("http://foo/bar?query", "http://foo/");
        this.verifyAuth("http://foo:81/", "http://foo:81/");
        this.verifyAuth("http://foo:81/x", "http://foo:81/");
        this.verifyAuth("http://www.acme.com/x", "http://www.acme.com/");
        this.verifyAuth("ftp://www.acme.com/x", "ftp://www.acme.com/");
        this.verify(this.contains("http://foo/", "http://foo/"));
        this.verify(!this.contains("http://foo/", "http://foox/"));
        this.verify(this.contains("http://foo:81/", "http://foo:81/"));
        this.verify(!this.contains("http://foo/", "http://foo:81/"));
        this.verify(this.contains("http://foo/", "http://foo/x"));
        this.verify(this.contains("http://foo/", "http://foo/x#frag"));
        this.verify(this.contains("http://foo/", "http://foo/x/y.txt"));
        this.verify(!this.contains("http://foo:81/", "http://foox/x"));
        this.verify(!this.contains("http://foo/", "http://foox/x"));
        this.verify(!this.contains("http://foo/", "http://foo:81/x"));
        this.verify(this.contains("http://foo/", ""));
        this.verify(this.contains("http://foo/", ".."));
        this.verify(this.contains("http://foo/", "/"));
        this.verify(this.contains("http://foo/", "/x"));
        this.verify(this.contains("http://foo/", "x"));
        this.verify(this.contains("http://foo/", "x#frag"));
        this.verifyParent("http://foo/", null);
        this.verifyParent("http://foo/x", "http://foo/");
        this.verifyParent("http://foo/x/", "http://foo/");
        this.verifyParent("http://foo/x/y", "http://foo/x");
        this.verifyParent("http://foo/x/y/", "http://foo/x");
        this.verifyParent("http://foo/x/y/z?query", "http://foo/x/y");
        this.verifyParent("/foo/x/y/", "/foo/x");
        this.verifyParent("/foo", null);
        this.verifyQuery("k=v", new String[]{"k", "v"});
        this.verifyQuery("a=b&c=d", new String[]{"a", "b", "c", "d"});
        this.verifyQuery("foo=bar&darn=cat&rock=roll", new String[]{"foo", "bar", "darn", "cat", "rock", "roll"});
        this.verifyQuery("v", new String[]{"v", "true"});
        this.verifyQuery("v=false", new String[]{"v", "false"});
        this.verifyQuery("a&b=false&c", new String[]{"a", "true", "b", "false", "c", "true"});
        this.verifyAddQuery("http://foo/", "v", "true", "http://foo/?v=true");
        this.verifyAddQuery("http://foo/obix", "v", "true", "http://foo/obix?v=true");
        this.verifyAddQuery("http://foo/obix?a=b", "v", "true", "http://foo/obix?a=b&v=true");
        this.verifyAddQuery("http://foo/obix?a=b&c", "v", "true", "http://foo/obix?a=b&c=true&v=true");
        this.verifyAddQuery("http://foo/obix?v=false", "v", "true", "http://foo/obix?v=true");
        this.verifyAddQuery("http://foo/obix?v", "v", "foo", "http://foo/obix?v=foo");
        this.verifyAddQuery("http://foo/obix?a=b&v=x", "v", "foo", "http://foo/obix?a=b&v=foo");
        this.verifyAddQuery("http://foo/obix?v=x&a=b", "v", "foo", "http://foo/obix?v=foo&a=b");
        this.verifyAddQuery("http://foo/obix", "v", null, "http://foo/obix");
        this.verifyAddQuery("http://foo/obix?v=x", "v", null, "http://foo/obix");
        this.verifyAddQuery("http://foo/obix?a=b", "v", null, "http://foo/obix?a=b");
        this.verifyAddQuery("http://foo/obix?a=b&v=x", "v", null, "http://foo/obix?a=b");
        this.verifyAddQuery("http://foo/obix?v=x&a=b", "v", null, "http://foo/obix?a=b");
    }

    public void verifyAbs(String uriStr, String scheme, String host, int port, String path) throws Exception {
        this.verifyAbs(uriStr, scheme, host, port, path, null, null);
    }

    public void verifyAbs(String uriStr, String scheme, String host, int port, String path, String query, String frag) throws Exception {
        Uri uri = new Uri(uriStr);
        this.verify(uri.isAbsolute());
        this.verify(!uri.isRelative());
        this.verify(uri.getScheme().equals(scheme));
        this.verify(uri.getHost().equals(host));
        this.verify(uri.getPort() == port);
        if (port == -1) {
            this.verify(uri.getAddress().equals(host));
        } else {
            this.verify(uri.getAddress().equals(host + ":" + port));
        }
        this.verify(uri.getPath().equals(path));
        Uri.Query q = uri.getQuery();
        if (q == null) {
            this.verify(query == null);
        } else {
            this.verify(q.toString(), (Object)query);
        }
        this.verify(uri.getFragment(), (Object)frag);
    }

    public void verifyRel(String uriStr, String path, String query, String frag) throws Exception {
        Uri uri = new Uri(uriStr);
        this.verify(!uri.isAbsolute());
        this.verify(uri.isRelative());
        this.verify(uri.getScheme() == null);
        this.verify(uri.getHost() == null);
        this.verify(uri.getPort() == -1);
        this.verify(uri.getAuthority() == null);
        this.verify(uri.getPath().equals(path));
        Uri.Query q = uri.getQuery();
        if (q == null) {
            this.verify(query == null);
        } else {
            this.verify(q.toString(), (Object)query);
        }
        this.verify(uri.getFragment(), (Object)frag);
    }

    public void verifyNorm(String base, String rel, String norm) throws Exception {
        Uri uri = new Uri(rel).normalize(new Uri(base));
        this.verify(uri.toString().equals(norm));
    }

    public void verifyAuth(String uriStr, String authStr) throws Exception {
        Uri uri = new Uri(uriStr);
        Uri auth = uri.getAuthorityUri();
        this.verify(uri.getAuthority().equals(authStr));
        this.verify(auth.toString().equals(authStr));
    }

    public boolean contains(String base, String sub) {
        return new Uri(base).contains(new Uri(sub));
    }

    public void verifyParent(String uri, String parentStr) {
        Uri parent = new Uri(uri).parent();
        if (parent == null) {
            this.verify(parentStr == null);
        } else {
            this.verify(parent.toString().equals(parentStr));
        }
    }

    public void verifyQuery(String qstr, String[] pairs) {
        Uri.Query q = new Uri("http://foo/?" + qstr).getQuery();
        this.verify(q.toString().equals(qstr));
        String[] keys = q.keys();
        this.verify(keys.length == pairs.length / 2);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            this.verify(key.equals(pairs[i * 2]));
            this.verify(q.get(key, null).equals(pairs[i * 2 + 1]));
        }
    }

    public void verifyAddQuery(String base, String key, String val, String result) {
        Uri actual = new Uri(base).addQueryParam(key, val);
        this.verify(actual.toString().equals(result));
    }
}

