/*
 * Decompiled with CFR 0.152.
 */
package obix.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import obix.Contract;
import obix.Obj;
import obix.Ref;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;

public class Obixc {
    static boolean verbose;
    File destDir;
    String packageName;
    String href;
    PrintWriter out;
    Type[] types;

    public Obixc(File destDir, String packageName) {
        this.destDir = destDir;
        this.packageName = packageName;
    }

    public void compile(InputStream in) throws Exception {
        ObixDecoder decoder = ObixDecoder.make(in);
        decoder.setUseContracts(false);
        Obj root = decoder.decodeDocument();
        this.map(root);
        for (int i = 0; i < this.types.length; ++i) {
            this.writeInterface(this.types[i]);
        }
        this.writeContractInit();
    }

    public void map(Obj proto) throws Exception {
        int i;
        ArrayList<Type> acc = new ArrayList<Type>();
        this.map(proto, acc);
        this.types = acc.toArray(new Type[0]);
        for (i = 0; i < this.types.length; ++i) {
            this.mapContracts(this.types[i]);
        }
        for (i = 0; i < this.types.length; ++i) {
            this.mapChildren(this.types[i]);
        }
        for (i = 0; i < this.types.length; ++i) {
            this.mapChildren(this.types[i]);
        }
    }

    private void map(Obj proto, ArrayList<Type> acc) {
        Uri href = proto.getHref();
        if (href != null && !href.isFragment()) {
            acc.add(this.toType(proto));
        }
        Obj[] kids = proto.list();
        for (int i = 0; i < kids.length; ++i) {
            this.map(kids[i], acc);
        }
    }

    private Type toType(Obj proto) {
        String name = proto.getName();
        if (name == null) {
            String href = proto.getHref().toString();
            int end = href.lastIndexOf(47);
            if (end < 0) {
                end = href.lastIndexOf(58);
            }
            name = href.substring(end + 1);
        }
        Type type = new Type();
        type.name = name;
        type.proto = proto;
        type.href = proto.getHref();
        return type;
    }

    private void mapContracts(Type type) {
        ArrayList<Type> acc = new ArrayList<Type>();
        acc.add(type);
        Contract c = type.proto.getIs();
        if (c == null) {
            c = new Contract("");
        }
        Uri[] list = c.list();
        for (int i = 0; i < list.length; ++i) {
            Type t = this.hrefToType(list[i]);
            if (t == null) continue;
            acc.add(t);
        }
        type.contracts = acc.toArray(new Type[0]);
    }

    private void mapChildren(Type type) {
        ArrayList<Child> acc = new ArrayList<Child>();
        Obj[] kids = type.proto.list();
        for (int i = 0; i < kids.length; ++i) {
            Obj kid = kids[i];
            if (kid.getName() == null) continue;
            acc.add(this.mapChild(type, kids[i]));
        }
        type.children = acc.toArray(new Child[0]);
    }

    private Child mapChild(Type type, Obj kid) {
        Child child = new Child();
        child.parent = type;
        child.name = kid.getName();
        child.obj = kid;
        child.className = this.toClassName(kid, false);
        child.implClassName = this.toClassName(kid, true);
        child.retClassName = child.className;
        return child;
    }

    private Type hrefToType(Uri href) {
        for (int i = 0; i < this.types.length; ++i) {
            if (!this.types[i].href.equals(href)) continue;
            return this.types[i];
        }
        return null;
    }

    public void writeInterface(Type type) throws Exception {
        int i;
        String name = type.name;
        this.openFile(name);
        this.wheader("interface", name);
        this.w("  extends IObj");
        for (i = 1; i < type.contracts.length; ++i) {
            this.w(", ").w(type.contracts[i].name);
        }
        this.w("\n");
        this.w("{\n").flush();
        for (i = 0; i < type.children.length; ++i) {
            Child kid = type.children[i];
            this.w("\n");
            if (this.needsContractField(kid.obj)) {
                this.w("  public static final String ").w(kid.name).w("Contract = \"").w(this.toContract(kid.obj)).w("\";\n");
            }
            this.w("  public ").w(kid.className).w(" ").w(kid.name).w("();\n");
        }
        this.w("\n");
        this.w("}\n");
        this.closeFile();
    }

    boolean needsContractField(Obj obj) {
        Obj def = Obj.toObj(obj.getElement());
        def.setName(obj.getName());
        String a = this.toContract(obj);
        String b = this.toContract(def);
        return !a.equals(b);
    }

    String toContract(Obj obj) {
        String xml = ObixEncoder.toString(obj);
        xml = xml.replace('\"', '\'');
        xml = xml.replace('\n', ' ');
        xml = xml.replace('\r', ' ');
        return xml.trim();
    }

    public void writeContractInit() throws Exception {
        String name = "ContractInit";
        this.openFile(name);
        this.wheader("class", name);
        this.w("{\n");
        this.w("\n");
        this.w("  public static void init()\n");
        this.w("  {\n");
        for (int i = 0; i < this.types.length; ++i) {
            Type type = this.types[i];
            this.w("    ContractRegistry.put(\"").w(type.href.get()).w("\", \"").w(this.packageName).w(".").w(type.name).w("\");\n");
        }
        this.w("  }\n");
        this.w("\n");
        this.w("}\n");
        this.closeFile();
    }

    String toClassName(Obj obj, boolean impl) {
        Type use;
        if (obj instanceof Ref) {
            return "Ref";
        }
        Contract is = obj.getIs();
        if (is != null && is.size() > 0 && (use = this.hrefToType(is.primary())) != null) {
            return use.name;
        }
        return this.capitalize(obj.getElement());
    }

    String capitalize(String s) {
        return "" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    Obixc w(String s) {
        this.out.print(s);
        return this;
    }

    Obixc wdate() {
        return this.w(new SimpleDateFormat("dd MMM yy").format(new Date()));
    }

    void openFile(String name) throws Exception {
        File outFile = new File(this.destDir, name + ".java");
        System.out.println("Compile " + name + " -> " + outFile);
        this.out = new PrintWriter(new FileOutputStream(outFile));
    }

    void closeFile() throws Exception {
        this.out.flush();
        this.out.close();
    }

    void wheader(String classType, String name) {
        this.w("package ").w(this.packageName).w(";\n");
        this.w("\n");
        this.w("import obix.*;");
        this.w("\n");
        this.w("\n");
        this.w("/**\n");
        this.w(" * ").w(name).w("\n");
        this.w(" *\n");
        this.w(" * @author    obix.tools.Obixc\n");
        this.w(" * @creation  ").wdate().w("\n");
        this.w(" * @version   $Revision$ $Date$\n");
        this.w(" */\n");
        this.w("public ").w(classType).w(" ").w(name).w("\n");
    }

    Obixc flush() {
        this.out.flush();
        return null;
    }

    Exception err(String msg) {
        return new Exception(msg);
    }

    public static void usage() {
        System.out.println("usage: obixc <src> <destDir> <package>");
        System.out.println("  Compiles obix prototypes into Java source files");
        System.out.println("Params:");
        System.out.println("  <src>      URI or file name for prototype XML file");
        System.out.println("  <destDir>  Directory to output .java files");
        System.out.println("  <package>  Package name for .java files");
    }

    public static void main(String[] args) {
        block3: {
            try {
                if (args.length < 3) {
                    Obixc.usage();
                    return;
                }
                String src = args[0];
                File destDir = new File(args[1]);
                destDir.mkdirs();
                String packageName = args[2];
                File file = new File(src);
                BufferedInputStream in = file.exists() ? new BufferedInputStream(new FileInputStream(file)) : new BufferedInputStream(new URL(src).openStream());
                Obixc obixc = new Obixc(destDir, packageName);
                obixc.compile(in);
            }
            catch (Exception e) {
                System.out.println("Could not compile obix prototype:" + e);
                if (!verbose) break block3;
                e.printStackTrace();
            }
        }
    }

    static class Child {
        Type parent;
        String name;
        Obj obj;
        String className;
        String implClassName;
        String retClassName;

        Child() {
        }
    }

    static class Type {
        Obj proto;
        Uri href;
        String name;
        Type[] contracts;
        Child[] children;

        Type() {
        }

        public String toString() {
            return this.name;
        }
    }
}

