/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.hx;

import com.tridium.alarm.BConsoleRecipient;
import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.ToggleCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.util.LexiconModule;
import javax.baja.xml.XWriter;

@NiagaraType(agent={@AgentOn(types={"alarm:AlarmConsole", "alarm:ConsoleRecipient"}, requiredPermissions="r")})
@NiagaraSingleton
@Deprecated
public class BHxAlarmConsole
extends BHxView {
    @Generated
    public static final BHxAlarmConsole INSTANCE = new BHxAlarmConsole();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxAlarmConsole.class);
    BAlarmService alarmService;
    private int minToRefresh = Integer.getInteger("hx.alarmConsole.autoRefresh.interval", -1);
    public static final LexiconModule lexicon = LexiconModule.make(BHxAlarmConsole.class);
    public static final BFacets HX_TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.FALSE);
    private static BImage yellowAlarmImg = BImage.make((String)"module://icons/x16/alarm.png");
    private static BImage redAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmRed.png");
    private static BImage greenAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmGreen.png");
    private static BImage orangeAlarmImg = BImage.make((String)"module://alarm/com/tridium/alarm/icons/alarmOrange.png");
    private static BImage sortAsc = BImage.make((BIcon)BIcon.std((String)"moveUp.png"));
    private static BImage sortDesc = BImage.make((BIcon)BIcon.std((String)"moveDown.png"));
    private static BImage arrow = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    private static BImage linkImg = BImage.make((BIcon)BIcon.std((String)"link.png"));
    private static BImage blankImg = BImage.make((BIcon)BIcon.std((String)"blank.png"));
    public String sheetClass = "window-bg hx-AlarmConsole";
    public String headClass = "window-bg control-border font hx-AlarmConsole-header";
    public String rowClass = "window-bg control-border hx-AlarmConsole-row";
    public AlarmCommand acknowledge = new Acknowledge(this);
    public AlarmCommand forceClear;
    public AlarmCommand showRecurring;
    public AlarmCommand showAll;
    public AlarmCommand showDetails;
    public AlarmCommand addNotes;
    private AutoRefreshToggle autoRefreshToggle;
    public Command sort;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxAlarmConsole() {
        this.registerEvent((Event)this.acknowledge);
        this.showRecurring = new ShowRecurring(this);
        this.registerEvent((Event)this.showRecurring);
        this.showAll = new ShowAll(this);
        this.registerEvent((Event)this.showAll);
        this.showDetails = new ShowDetails(this);
        this.registerEvent((Event)this.showDetails);
        this.forceClear = new ForceClear(this);
        this.registerEvent((Event)this.forceClear);
        this.sort = new SortCommand(this);
        this.registerEvent((Event)this.sort);
        this.addNotes = new AddNotes(this);
        this.registerEvent((Event)this.addNotes);
        this.autoRefreshToggle = new AutoRefreshToggle(this);
        this.registerEvent((Event)this.autoRefreshToggle);
    }

    public void write(HxOp op) throws Exception {
        String themeName;
        HtmlWriter out = op.getHtmlWriter();
        op.setDynamic();
        op.addJavaScript(BOrd.make((String)"module://alarm/com/tridium/alarm/hx/alarm.js"));
        op.addStyleSheet(BOrd.make((String)"module://alarm/com/tridium/alarm/hx/alarm.css"));
        BDynamicEnum theme = (BDynamicEnum)op.getProfileConfig().get("selectedHxTheme");
        String string = themeName = theme == null ? null : theme.getTag();
        if (themeName != null && !themeName.isEmpty()) {
            op.addStyleSheet(BOrd.make((String)("module://theme" + themeName + "/ux/theme.css")));
        }
        out.w((Object)"<div class=\"alarmconsole-background\">");
        out.w((Object)"<table height='100%' width='100%' cellspacing='0' cellpadding='0' >");
        out.w((Object)"<tr><td>");
        out.w((Object)("<div id=\"" + op.scope("tableTitle") + "\"class=\"ux-table ux-table-head\">"));
        this.writeTableTitle(false, op);
        out.w((Object)"</div>");
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr><td valign='top' height='100%' >");
        out.w((Object)("<div id=\"" + op.scope("tableRecords") + "\""));
        out.w((Object)" style=\"overflow:auto; width:100%;\"");
        out.w((Object)">");
        out.w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + op.scope("records") + "\">"));
        this.writeTableHeader(op, false);
        out.w((Object)"<tr><td colspan=\"9\">Loading...</td></tr>");
        out.w((Object)"</table></div>");
        out.w((Object)"</td></tr>");
        out.w((Object)"<tr class=\"ux-table-row\"><td>");
        out.w((Object)("<div style=\"padding:10px; align:center; text-align:center;\" id=\"" + op.scope("commands") + "\">"));
        out.w((Object)"</div>");
        out.w((Object)"</td></tr>");
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        op.addOnload(this.sort.getInvokeCode(op));
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
    }

    private String addTimeRangeFilter(BConsoleRecipient recip, String query) {
        BDynamicTimeRange timeRange = recip.getDefaultTimeRange();
        if (!timeRange.equals((Object)BDynamicTimeRange.DEFAULT)) {
            BAbsTimeFilter timeFilter = new BAbsTimeFilter();
            timeFilter.initFromDynamicTimeRange(timeRange);
            String predicate = timeFilter.getPredicate(BAlarmRecord.timestamp.getName());
            if (predicate != null && !predicate.isEmpty()) {
                return query + " and " + predicate;
            }
        }
        return query;
    }

    public void showAll(HxOp op) throws Exception {
        SourceAlarm rec;
        BConsoleRecipient recip = (BConsoleRecipient)op.get();
        String query = recip.getInitialAlarmQuery(op.getUser());
        query = this.addTimeRangeFilter(recip, query);
        BOrd ord = BOrd.make((String)query);
        BITable result = (BITable)ord.resolve((BObject)recip).get();
        HashMap<BOrdList, SourceAlarm> sources = new HashMap<BOrdList, SourceAlarm>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                if (!recip.accept(alarm)) continue;
                BOrdList alarmSource = alarm.getSource();
                rec = null;
                rec = sources.containsKey(alarmSource) ? (SourceAlarm)sources.get(alarmSource) : new SourceAlarm();
                rec.update((BAlarmRecord)alarm.newCopy());
                sources.put(alarm.getSource(), rec);
            }
        }
        ArrayList<SourceAlarm> alarms = new ArrayList<SourceAlarm>(sources.values());
        String sortCol = "timestamp";
        boolean sortAscending = false;
        if (op.getUnsafePostBody() != null) {
            if (op.getFormValue("sortBy") != null) {
                sortCol = op.getFormValue("sortBy");
            }
            try {
                sortAscending = Boolean.parseBoolean(op.getFormValue("sortAscending"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (sortAscending) {
            this.sortSourceAlarms(alarms, sortCol, SortUtil.ASCENDING);
        } else {
            this.sortSourceAlarms(alarms, sortCol, SortUtil.DESCENDING);
        }
        this.writeTableHeader(op, true);
        for (int i = 0; i < alarms.size(); ++i) {
            rec = (SourceAlarm)alarms.get(i);
            BAlarmRecord alarm = rec.alarm;
            this.writeAlarmRow(op, alarm, rec);
        }
    }

    public void writeCommands(AlarmCommand[] cmds, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        for (int i = 0; i < cmds.length; ++i) {
            out.w((Object)"<span class=\"ux-btn\"").w((Object)" onclick=\"").w((Object)cmds[i].getInvokeCode(op)).w((Object)"\">");
            if (cmds[i].getIcon(op) != null) {
                HxUtil.makeImageJS((BImage)cmds[i].getIcon(op), null, null, (String)"\"", (HxOp)op);
                out.w((Object)"&nbsp;");
            }
            out.safe((Object)cmds[i].getDisplayName(op));
            out.w((Object)"</span>&nbsp;");
        }
        this.writeAutoRefreshToggle(op);
    }

    private void writeAutoRefreshToggle(HxOp op) throws Exception {
        if (this.hasAutoRefresh()) {
            AutoRefreshToggle cmd = this.autoRefreshToggle;
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<span class=\"ux-btn\"").w((Object)" onclick=\"").w((Object)cmd.getInvokeCode(op)).w((Object)"\">");
            if (cmd.getIcon(op) != null) {
                HxUtil.makeImageJS((BImage)cmd.getIcon(op), null, null, (String)"\"", (HxOp)op);
                out.w((Object)"&nbsp;");
            }
            out.safe((Object)cmd.getDisplayName(op));
            out.w((Object)"</span>&nbsp;");
        }
    }

    public void ackAlarmByUuid(String uuid, String notes, HxOp op) throws Exception {
        if (uuid == null) {
            return;
        }
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        for (int j = 0; j < arr.size(); ++j) {
            this.ackAlarm((BAlarmRecord)arr.get(j), notes, op);
        }
    }

    public void addAlarmNoteByUuid(String uuid, String notes, HxOp op) throws AlarmException, IOException {
        if (uuid == null) {
            return;
        }
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        var8_8 = null;
        try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                this.addNotes(alarm, notes, op);
                conn.update(alarm);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    public void ackAlarmBySource(String src, String notes, HxOp op) throws Exception {
        if (src == null) {
            return;
        }
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + src + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        for (int j = 0; j < arr.size(); ++j) {
            this.ackAlarm((BAlarmRecord)arr.get(j), notes, op);
        }
    }

    public void addAlarmNoteBySource(String src, String notes, HxOp op) throws AlarmException, IOException {
        if (src == null) {
            return;
        }
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + src + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        var8_8 = null;
        try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                this.addNotes(alarm, notes, op);
                conn.update(alarm);
            }
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
    }

    public void ackAlarm(BAlarmRecord alarm, String notes, HxOp op) throws Exception {
        BAlarmClass alarmClass = this.getAlarmService().lookupAlarmClass(alarm.getAlarmClass());
        if (alarmClass == null) {
            alarmClass = this.getAlarmService().getDefaultAlarmClass();
        }
        op.getUser().check((BIProtected)alarmClass, BPermissions.operatorWrite);
        alarm.setUser(op.getUser().getUsername());
        alarm.setAckTime(BAbsTime.now());
        alarm.setAckState(BAckState.ackPending);
        this.addNotes(alarm, notes, op);
        try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(alarm.getUuid());
            if (rec == null || rec.getAckState() != BAckState.ackPending) {
                conn.update(alarm);
            }
        }
        this.getAlarmService().ackAlarm(alarm);
    }

    protected void addNotes(BAlarmRecord rec, String newNotes, HxOp op) {
        if (newNotes == null) {
            return;
        }
        BFacets alarmData = rec.getAlarmData();
        String oldNotes = "";
        if (alarmData.get("notes") != null) {
            oldNotes = alarmData.get("notes").toString();
        }
        StringBuilder notes = new StringBuilder();
        notes.append("## " + BAbsTime.now() + " - " + op.getUser().getUsername() + " ##\n");
        notes.append(newNotes);
        notes.append("\n\n");
        notes.append(oldNotes);
        BFacets f = BFacets.make((BFacets)alarmData, (BFacets)BFacets.make((String)"notes", (BIDataValue)BString.make((String)notes.toString())));
        rec.setAlarmData(f);
    }

    public void forceClearBySource(String src, HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + src + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        try {
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                BAlarmClass alarmClass = this.getAlarmService().lookupAlarmClass(alarm.getAlarmClass());
                if (alarmClass == null) {
                    alarmClass = this.getAlarmService().getDefaultAlarmClass();
                }
                op.getUser().check((BIProtected)alarmClass, BPermissions.adminWrite);
                alarm.setUser(op.getUser().getUsername());
                alarm.setAckTime(BAbsTime.now());
                alarm.setAckState(BAckState.acked);
                alarm.setSourceState(BSourceState.normal);
                alarm.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)op.getUser().getUsername()));
                try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
                    conn.update(alarm);
                }
                this.getAlarmService().auditForceClear(alarm);
            }
        }
        catch (PermissionException e) {
            System.out.println("Invalid Permissions");
        }
        catch (Exception e) {
            System.out.println("Cannot find: " + src);
        }
    }

    public void forceClearByUuid(String uuid, HxOp op) throws Exception {
        BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
        BITable result = (BITable)ord.resolve(op.get()).get();
        ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
            }
        }
        try {
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                BAlarmClass alarmClass = this.getAlarmService().lookupAlarmClass(alarm.getAlarmClass());
                if (alarmClass == null) {
                    alarmClass = this.getAlarmService().getDefaultAlarmClass();
                }
                op.getUser().check((BIProtected)alarmClass, BPermissions.adminWrite);
                alarm.setUser(op.getUser().getUsername());
                alarm.setAckTime(BAbsTime.now());
                alarm.setAckState(BAckState.acked);
                alarm.setSourceState(BSourceState.normal);
                alarm.addAlarmFacet("forceCleared", (BIDataValue)BString.make((String)op.getUser().getUsername()));
                try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
                    conn.update(alarm);
                }
                this.getAlarmService().auditForceClear(alarm);
            }
        }
        catch (PermissionException e) {
            System.out.println("Invalid Permissions");
        }
        catch (Exception e) {
            System.out.println("Cannot find: " + uuid);
        }
    }

    protected void writeTableTitle(boolean recurring, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<span class=\"alarmConsole-title\">").safe((Object)lexicon.getText("HxAlarmConsole.displayName", (Context)op)).w((Object)"</span>");
        if (recurring) {
            out.w((Object)"<span class=\"alarmConsole-title\">&nbsp;");
            HxUtil.makeImageJS((BImage)arrow, null, null, (String)"\"", (HxOp)op);
            out.w((Object)"&nbsp;").safe((Object)lexicon.getText("hx.recurringAlarms", (Context)op)).w((Object)"</span>");
        }
    }

    public void showRecurringAlarms(String src, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BConsoleRecipient recip = (BConsoleRecipient)op.get();
        String query = recip.getInitialAlarmQuery(op.getUser());
        query = query + " and source='" + src + "'";
        query = this.addTimeRangeFilter(recip, query);
        BOrd ord = BOrd.make((String)query);
        BITable result = (BITable)ord.resolve((BObject)recip).get();
        ArrayList<BAlarmRecord> alarmArray = new ArrayList<BAlarmRecord>();
        try (TableCursor cur = result.cursor();){
            while (cur.next()) {
                BAlarmRecord alarm = (BAlarmRecord)cur.get();
                if (!recip.accept(alarm)) continue;
                alarmArray.add((BAlarmRecord)alarm.newCopy());
            }
        }
        String sortCol = "timestamp";
        boolean sortAscending = false;
        if (op.getUnsafePostBody() != null) {
            if (op.getFormValue("sortBy") != null) {
                sortCol = op.getFormValue("sortBy");
            }
            try {
                sortAscending = Boolean.parseBoolean(op.getFormValue("sortAscending"));
            }
            catch (Exception alarm) {
                // empty catch block
            }
        }
        if (sortAscending) {
            this.sortAlarms(alarmArray, sortCol, SortUtil.ASCENDING);
        } else {
            this.sortAlarms(alarmArray, "timestamp", SortUtil.DESCENDING);
        }
        out.w((Object)("<input type=\"hidden\" name=\"" + op.scope("recurringAlarms") + "\" value=\"true\" />"));
        out.w((Object)("<input type=\"hidden\" name=\"" + op.scope("source") + "\" value=\"" + src + "\" />"));
        this.writeTableHeader(op, true);
        for (int i = 0; i < alarmArray.size(); ++i) {
            BString msg;
            BAlarmRecord alarm = (BAlarmRecord)alarmArray.get(i);
            BString source = (BString)alarm.getAlarmData().get("sourceName");
            if (source == null) {
                source = BString.make((String)alarm.getSource().toString());
            }
            if ((msg = (BString)alarm.getAlarmData().get("msgText")) == null) {
                msg = BString.make((String)"");
            }
            this.writeAlarmRow(op, alarm, null);
        }
    }

    protected void writeTableHeader(HxOp op, boolean showJs) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)"<thead class=\"ux-table-head\">");
        out.w((Object)"<tr>");
        out.w((Object)"<th>");
        out.w((Object)"<input type=\"checkbox\" onclick=\"ac.selectAll(event);\"/>");
        out.w((Object)"</th>");
        out.w((Object)"<th>&nbsp;</th>");
        this.writeColumnHeader(op, BAlarmRecord.timestamp, showJs);
        this.writeColumnHeader(op, BAlarmRecord.source, showJs);
        this.writeColumnHeader(op, BAlarmRecord.sourceState, showJs);
        this.writeColumnHeader(op, BAlarmRecord.ackState, showJs);
        this.writeColumnHeader(op, BAlarmRecord.priority, showJs);
        this.writeColumnHeader(op, BAlarmRecord.alarmClass, showJs);
        out.w((Object)"<th>").safe((Object)lexicon.getText("alarmData.msgText", (Context)op)).w((Object)"</th>");
        out.w((Object)"</tr>");
        out.w((Object)"</thead>");
    }

    protected void writeColumnHeader(HxOp op, Property p, boolean showJs) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        String sortCol = "timestamp";
        boolean sortAscending = false;
        if (op.getUnsafePostBody() != null) {
            if (op.getFormValue("sortBy") != null) {
                sortCol = op.getFormValue("sortBy");
            }
            try {
                sortAscending = Boolean.parseBoolean(op.getFormValue("sortAscending"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        out.w((Object)"<th>");
        boolean writeSort = false;
        if (p.getName().equals(sortCol)) {
            writeSort = !sortAscending;
        }
        out.w((Object)"<span style=\"cursor: pointer; cursor: hand;\" ");
        if (showJs) {
            out.w((Object)("onclick=\"hx.setFormValue(&quot;" + op.scope("sortBy") + "&quot;,&quot;" + p.getName() + "&quot;);hx.setFormValue(&quot;" + op.scope("sortAscending") + "&quot;,&quot;" + writeSort + "&quot;);hx.fireEvent(&quot;" + op.getPath() + "&quot;,&quot;" + this.sort.getId() + "&quot;);\""));
        }
        out.w((Object)">");
        out.safe((Object)p.getDefaultDisplayName((Context)op));
        if (p.getName().equals(sortCol)) {
            if (sortAscending) {
                HxUtil.makeImageJS((BImage)sortAsc, null, null, (String)"\"", (HxOp)op);
            } else {
                HxUtil.makeImageJS((BImage)sortDesc, null, null, (String)"\"", (HxOp)op);
            }
        }
        out.w((Object)"</span>");
        out.w((Object)"</th>");
    }

    protected void writeAlarmRow(HxOp op, BAlarmRecord alarm, SourceAlarm rec) throws Exception {
        BString msg;
        HtmlWriter out = op.getHtmlWriter();
        BString source = (BString)alarm.getAlarmData().get("sourceName");
        if (source == null) {
            source = BString.make((String)alarm.getSource().toString());
        }
        if ((msg = (BString)alarm.getAlarmData().get("msgText")) == null) {
            msg = BString.make((String)"");
        }
        BFormat msgFormat = BFormat.make((String)msg.toString());
        String msgText = msgFormat.format((Object)alarm);
        BImage img = greenAlarmImg;
        if (alarm.getSourceState() == BSourceState.alert) {
            img = orangeAlarmImg;
        } else if (alarm.isAcknowledged() && !alarm.isNormal()) {
            img = yellowAlarmImg;
        } else if (!alarm.isAcknowledged() && !alarm.isNormal()) {
            img = redAlarmImg;
        }
        String rowClass = "ux-table-row";
        out.w((Object)("<tr class=\"" + rowClass + "\">"));
        out.w((Object)"<td align=\"center\" valign=\"middle\" style=\"padding:0;\">");
        out.w((Object)"<input type=checkbox ");
        out.w((Object)("id=\"" + op.scope(alarm.getUuid().toString()) + "\" "));
        out.w((Object)("name=\"" + op.scope("_" + alarm.getUuid().toString()) + "\" "));
        out.w((Object)("value=\"" + SlotPath.escape((String)alarm.getSource().encodeToString()) + "\">"));
        out.w((Object)"</td>");
        out.w((Object)"<td align=\"right\">");
        if (alarm.getAlarmData().get("icon") != null) {
            BImage iconImg = BImage.make((BOrd)BOrd.make((BOrd)((BComponent)op.get()).getNavOrd(), (String)alarm.getAlarmData().get("icon").toString()));
            HxUtil.makeImageJS((BImage)iconImg, null, null, (String)"\"", (HxOp)op);
        }
        if (alarm.getAlarmData().get("hyperlinkOrd") != null) {
            this.makeAlarmHyperlink(alarm.getAlarmData().get("hyperlinkOrd").toString(), op);
        } else {
            HxUtil.makeImageJS((BImage)blankImg, null, null, (String)"\"", (HxOp)op);
        }
        BImage cameraIcon = this.getVideoImage(alarm);
        if (cameraIcon != null) {
            HxUtil.makeImageJS((BImage)cameraIcon, null, null, (String)"\"", (HxOp)op);
        }
        HxUtil.makeImageJS((BImage)img, null, null, (String)"\"", (HxOp)op);
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        BasicContext timestampContext = new BasicContext((Context)op, HX_TIMESTAMP_FACETS);
        BHxAlarmConsole.safe(out, alarm.getTimestamp().toString((Context)timestampContext));
        out.w((Object)"</td>");
        out.w((Object)"<td>");
        BHxAlarmConsole.safe(out, source.toString());
        out.w((Object)"</td>");
        out.w((Object)"<td >");
        BHxAlarmConsole.safe(out, alarm.getSourceState().toString((Context)op));
        out.w((Object)"</td>");
        if (rec != null) {
            if (rec.pendingCount == 0) {
                out.w((Object)"<td >");
                BHxAlarmConsole.safe(out, rec.ackedCount + " Acked / " + rec.unackedCount + " Unacked");
                out.w((Object)"</td>");
            } else {
                out.w((Object)"<td >");
                BHxAlarmConsole.safe(out, rec.ackedCount + " Acked / " + rec.unackedCount + " Unacked / " + rec.pendingCount + " Ack Pending");
                out.w((Object)"</td>");
            }
        } else {
            out.w((Object)"<td >");
            BHxAlarmConsole.safe(out, alarm.getAckState().toString((Context)op));
            out.w((Object)"</td>");
        }
        out.w((Object)"<td >");
        BHxAlarmConsole.safe(out, "" + alarm.getPriority());
        out.w((Object)"</td>");
        out.w((Object)"<td >");
        BHxAlarmConsole.safe(out, SlotPath.unescape((String)this.getAlarmService().getAlarmClassDisplayName((Object)BString.make((String)alarm.getAlarmClass()), (Context)op).toString()));
        out.w((Object)"</td>");
        out.w((Object)"<td >");
        BHxAlarmConsole.safe(out, msgText);
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
    }

    public static void safe(HtmlWriter out, Object object) {
        if (object == null) {
            out.w((Object)"&nbsp;");
        } else {
            String s = object.toString();
            if (s == null) {
                out.w((Object)"&nbsp;");
            }
            if (s.equals("") || s.equals(" ") || s.equals("&nbsp;")) {
                out.w((Object)"&nbsp;");
                return;
            }
            out.safe((Object)s);
        }
    }

    public BImage getVideoImage(BAlarmRecord alarm) {
        return null;
    }

    protected void makeAlarmHyperlink(String ord, HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        HxUtil.writeSafeAnchorStart((BOrd)BOrd.make((String)ord), (HxOp)op);
        out.w((Object)">");
        HxUtil.makeImageJS((BImage)linkImg, (String)"class=\"hx-AlarmConsole-sortImg\"", null, (String)"\"", (HxOp)op);
        out.w((Object)"</a>");
    }

    public BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public AlarmCommand[] getCommands(boolean recurring, HxOp op) {
        ArrayList<AlarmCommand> arr = new ArrayList<AlarmCommand>();
        arr.add(this.acknowledge);
        if (!recurring) {
            arr.add(this.showRecurring);
        } else {
            arr.add(this.showAll);
        }
        BPermissions permissions = op.getPermissionsForTarget();
        if (permissions.hasOperatorWrite()) {
            arr.add(this.addNotes);
        }
        arr.add(this.showDetails);
        if (permissions.hasAdminWrite() || permissions.hasAdminInvoke()) {
            arr.add(this.forceClear);
        }
        return arr.toArray(new AlarmCommand[0]);
    }

    private void sortSourceAlarms(List<SourceAlarm> entries, String p, Comparator<? super Object> comparator) {
        int n = entries.size();
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                int j;
                SourceAlarm tempValue = entries.get(i);
                Object tempKey = tempValue.get(p);
                for (j = i; j >= incr && comparator.compare(tempKey, entries.get(j - incr).get(p)) <= 0; j -= incr) {
                    if (comparator.compare(tempKey, entries.get(j - incr).get(p)) == 0) {
                        BAbsTime ts1 = (BAbsTime)tempValue.get(BAlarmRecord.timestamp.getName());
                        BAbsTime ts2 = (BAbsTime)entries.get(j - incr).get(BAlarmRecord.timestamp.getName());
                        if (!ts2.isBefore(ts1)) break;
                        entries.set(j, entries.get(j - incr));
                        continue;
                    }
                    entries.set(j, entries.get(j - incr));
                }
                entries.set(j, tempValue);
            }
        }
    }

    private void sortAlarms(List<BAlarmRecord> entries, String p, Comparator<? super Object> comparator) {
        int n = entries.size();
        for (int incr = n / 2; incr >= 1; incr /= 2) {
            for (int i = incr; i < n; ++i) {
                int j;
                BAlarmRecord tempValue = entries.get(i);
                BValue tempKey = tempValue.get(p);
                for (j = i; j >= incr && comparator.compare(tempKey, entries.get(j - incr).get(p)) <= 0; j -= incr) {
                    if (comparator.compare(tempKey, entries.get(j - incr).get(p)) == 0) {
                        BAbsTime ts1 = tempValue.getTimestamp();
                        BAbsTime ts2 = entries.get(j - incr).getTimestamp();
                        if (!ts2.isBefore(ts1)) break;
                        entries.set(j, entries.get(j - incr));
                        continue;
                    }
                    entries.set(j, entries.get(j - incr));
                }
                entries.set(j, tempValue);
            }
        }
    }

    public String[] getSelection(HxOp op) {
        ArrayList<String> list = new ArrayList<String>();
        String[] keys = op.getFormKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith("_")) continue;
            list.add(keys[i]);
        }
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            String temp;
            ids[i] = temp = ((String)list.get(i)).substring(1);
        }
        return ids;
    }

    private String sessionScope(String name, HxOp op) {
        String ord = op.getOrd().relativizeToSession().toString();
        int index = ord.indexOf("|view:");
        if (index > -1) {
            ord = ord.substring(0, index);
        }
        return ord + "|" + op.getPath() + "|" + name;
    }

    private void insertAutoRefreshJavaScript(HxOp op) {
        if (this.hasAutoRefresh() && !this.autoRefreshToggle.isDisabled(op)) {
            String invokeCode = this.sort.getInvokeCode(op).replaceAll("&quot;", "'");
            String scope = SmartCommand.scopeWithOrd((String)"", (HxOp)op);
            String refreshCode = "ac.startAutoRefresh(\"" + scope + "\"," + this.minToRefresh + ",\"" + invokeCode + "\");";
            op.addOnload(refreshCode);
        }
    }

    private boolean hasAutoRefresh() {
        return this.minToRefresh > 0 && this.minToRefresh < 10000;
    }

    private void updateTable(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        out.w((Object)("document.getElementById('" + op.scope("tableRecords") + "').innerHTML='"));
        String content = HxUtil.marshal(sOp -> {
            sOp.getHtmlWriter().w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + sOp.scope("records") + "\">"));
            if (sOp.getFormValue("recurringAlarms") == null) {
                this.showAll((HxOp)sOp);
            } else {
                this.showRecurringAlarms(sOp.getUnsafeFormValue("source"), (HxOp)sOp);
            }
        }, (HxOp)op);
        out.w((Object)HxUtil.escapeJsStringLiteral((String)content)).w((Object)"';");
        HxUtil.addJavascriptOnload((HxOp)op);
    }

    public class SortCommand
    extends Command {
        public SortCommand(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return "sortCommand";
        }

        public void handle(HxOp op) throws Exception {
            String formRecurring;
            HtmlWriter out = op.getHtmlWriter();
            boolean showAll = true;
            Object sessionRecurring = op.getRequest().getSession().getAttribute(BHxAlarmConsole.this.sessionScope("recurring", op));
            Object sessionSource = op.getRequest().getSession().getAttribute(BHxAlarmConsole.this.sessionScope("source", op));
            if (sessionRecurring != null) {
                showAll = false;
            }
            if ((formRecurring = op.getFormValue("recurringAlarms")) != null) {
                showAll = false;
            }
            out.w((Object)("document.getElementById('" + op.scope("tableRecords") + "').innerHTML='"));
            String content = "";
            content = showAll ? HxUtil.marshal(sOp -> {
                sOp.getHtmlWriter().w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + sOp.scope("records") + "\">"));
                BHxAlarmConsole.this.showAll((HxOp)sOp);
            }, (HxOp)op) : HxUtil.marshal(sOp -> {
                sOp.getHtmlWriter().w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + sOp.scope("records") + "\">"));
                String source = "";
                source = sessionSource != null ? sessionSource.toString() : sOp.getUnsafeFormValue("source");
                BHxAlarmConsole.this.showRecurringAlarms(source, (HxOp)sOp);
            }, (HxOp)op);
            out.w((Object)HxUtil.escapeJsStringLiteral((String)content)).w((Object)"';");
            out.w((Object)("document.getElementById('" + op.scope("commands") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(false, (HxOp)sOp), (HxOp)sOp), (HxOp)op)));
            out.w((Object)"';");
            BHxAlarmConsole.this.insertAutoRefreshJavaScript(op);
            HxUtil.addJavascriptOnload((HxOp)op);
        }
    }

    public class DetailsDialog
    extends Dialog {
        public DetailsDialog(Command handler) {
            super("Alarm Details", handler);
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this)};
        }

        public void writeContent(HxOp op) throws Exception {
            HtmlWriter out = op.getHtmlWriter();
            String[] selection = BHxAlarmConsole.this.getSelection(op);
            String uuidStr = selection[0];
            String bqlQuery = "alarm:|bql:SELECT * FROM openAlarms WHERE uuid='" + uuidStr + "'";
            BOrd ord = BOrd.make((String)bqlQuery);
            BITable result = (BITable)ord.resolve(op.get()).get();
            try (TableCursor cur = result.cursor();){
                if (cur.next()) {
                    BAlarmRecord alarm = (BAlarmRecord)cur.get();
                    Property[] props = alarm.loadSlots().getPropertiesArray();
                    out.w((Object)"<div ");
                    out.w((Object)" class='hx-AlarmConsole-detailsRow' style='overflow:auto; width:100%;'");
                    out.w((Object)">");
                    String detailsRowClass = "hx-AlarmConsole-detailsRow window-bg control-border hx-PropertySheet-row";
                    out.w((Object)"<table width='100%' cellpadding='3' cellspacing='0' style='padding:5px'>");
                    for (int i = 0; i < props.length; ++i) {
                        if (Flags.isHidden((BComplex)alarm, (Slot)props[i])) continue;
                        out.w((Object)"<tr>");
                        out.w((Object)("<td nowrap width='1%' class='" + detailsRowClass + "'><b>"));
                        BHxAlarmConsole.safe(out, props[i].getDefaultDisplayName((Context)op));
                        out.w((Object)"</b></td>");
                        if (props[i].equals(BAlarmRecord.alarmData)) {
                            BFacets facets = alarm.getAlarmData();
                            Object[] keys = facets.list();
                            SortUtil.sort((Object[])keys, (Object[])keys, (s1, s2) -> s1.compareToIgnoreCase((String)s2));
                            out.w((Object)("<td class='" + detailsRowClass + "'>"));
                            out.w((Object)"<table cellpadding='3' cellspacing='0'>");
                            for (int k = 0; k < keys.length; ++k) {
                                if (((String)keys[k]).equals("notes") || ((String)keys[k]).equals("instructions")) {
                                    String notes = SlotPath.unescape((String)facets.get((String)keys[k]).toString((Context)op));
                                    String[] split = TextUtil.split((String)notes, (char)'\n');
                                    for (int j = 0; j < split.length; ++j) {
                                        split[j] = XWriter.safeToString((String)split[j], (boolean)true);
                                    }
                                    notes = TextUtil.join((String[])split, (char)'\n');
                                    notes = TextUtil.replace((String)notes, (String)"\n", (String)"<br/>");
                                    out.w((Object)"<tr>");
                                    out.w((Object)"<td nowrap><b>");
                                    BHxAlarmConsole.safe(out, keys[k]);
                                    out.w((Object)"</b></td>");
                                    out.w((Object)"<td>");
                                    out.w((Object)notes);
                                    out.w((Object)"</td>");
                                    out.w((Object)"</tr>");
                                    continue;
                                }
                                if (props[i].getName().equals("alarmClass")) {
                                    String value = alarm.get(props[i]).toString((Context)op);
                                    value = BHxAlarmConsole.this.getAlarmService().getAlarmClassDisplayName((Object)BString.make((String)value), (Context)op).toString();
                                    out.w((Object)("<td class='" + detailsRowClass + "'>"));
                                    BHxAlarmConsole.safe(out, value);
                                    out.w((Object)"</td>");
                                    continue;
                                }
                                if ("unconvertedHyperlinkOrd".equals(keys[k])) continue;
                                out.w((Object)"<tr>");
                                out.w((Object)("<td nowrap><b>" + (String)keys[k] + "</b></td>"));
                                out.w((Object)"<td>");
                                BHxAlarmConsole.safe(out, BFormat.format((String)SlotPath.unescape((String)facets.get((String)keys[k]).toString((Context)op)), (Object)alarm));
                                out.w((Object)"</td>");
                                out.w((Object)"</tr>");
                            }
                            out.w((Object)"</table></div>");
                            out.w((Object)"</td>");
                        } else if (props[i].getType().equals(BAbsTime.TYPE)) {
                            out.w((Object)("<td class='" + detailsRowClass + "'>"));
                            BHxAlarmConsole.safe(out, SlotPath.unescape((String)alarm.get(props[i]).toString((Context)BFacets.make((BFacets)op.getFacets(), (BFacets)HX_TIMESTAMP_FACETS))));
                            out.w((Object)"</td>");
                        } else {
                            out.w((Object)("<td class='" + detailsRowClass + "'>"));
                            BHxAlarmConsole.safe(out, SlotPath.unescape((String)alarm.get(props[i]).toString((Context)op)));
                            out.w((Object)"</td>");
                        }
                        out.w((Object)"</tr>");
                    }
                    out.w((Object)"</table>");
                    out.w((Object)"</div>");
                }
            }
        }
    }

    public class ShowDetails
    extends AlarmCommand {
        DetailsDialog dlg;

        public ShowDetails(BHxView view) {
            super(view);
            this.dlg = new DetailsDialog(this);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.showDetails.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showDetails.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            String[] selection = BHxAlarmConsole.this.getSelection(op);
            if (selection.length < 1) {
                return;
            }
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
        }
    }

    public class ShowAll
    extends AlarmCommand {
        public ShowAll(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.showAll.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showAll.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            op.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("recurring", op), null);
            op.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("source", op), null);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("document.getElementById('" + op.scope("tableTitle") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> BHxAlarmConsole.this.writeTableTitle(false, (HxOp)sOp), (HxOp)op)));
            out.w((Object)"';");
            out.w((Object)("document.getElementById('" + op.scope("tableRecords") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> {
                sOp.getHtmlWriter().w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + sOp.scope("records") + "\">"));
                BHxAlarmConsole.this.showAll((HxOp)sOp);
            }, (HxOp)op)));
            out.w((Object)"';");
            out.w((Object)("document.getElementById('" + op.scope("commands") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(false, (HxOp)sOp), (HxOp)sOp), (HxOp)op)));
            out.w((Object)"';");
            HxUtil.addJavascriptOnload((HxOp)op);
        }
    }

    public class ShowRecurring
    extends AlarmCommand {
        public ShowRecurring(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.showRecurring.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.showRecurring.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            if (BHxAlarmConsole.this.getSelection(op).length == 0) {
                return;
            }
            op.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("recurring", op), (Object)"true");
            op.getRequest().getSession().setAttribute(BHxAlarmConsole.this.sessionScope("source", op), (Object)op.getFormValue("_" + BHxAlarmConsole.this.getSelection(op)[0]));
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)("document.getElementById('" + op.scope("tableTitle") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> BHxAlarmConsole.this.writeTableTitle(false, (HxOp)sOp), (HxOp)op)));
            out.w((Object)"';");
            out.w((Object)("document.getElementById('" + op.scope("tableRecords") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> {
                sOp.getHtmlWriter().w((Object)("<table width=\"100%\" cellspacing=\"0\" class=\"ux-table\" id=\"" + sOp.scope("records") + "\">"));
                BHxAlarmConsole.this.showRecurringAlarms(sOp.getFormValue("_" + BHxAlarmConsole.this.getSelection(op)[0]), (HxOp)sOp);
            }, (HxOp)op)));
            out.w((Object)"';");
            out.w((Object)("document.getElementById('" + op.scope("commands") + "').innerHTML='"));
            out.w((Object)HxUtil.escapeJsStringLiteral((String)HxUtil.marshal(sOp -> BHxAlarmConsole.this.writeCommands(BHxAlarmConsole.this.getCommands(false, (HxOp)sOp), (HxOp)sOp), (HxOp)op)));
            out.w((Object)"';");
            HxUtil.addJavascriptOnload((HxOp)op);
        }
    }

    private class AutoRefreshToggle
    extends ToggleCommand {
        AutoRefreshToggle(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "autoRefreshToggle";
        }

        public String getDisplayName(HxOp op) {
            if (this.isDisabled(op)) {
                return lexicon.getText("hx.enableAutoRefreshToggle.label", (Context)op);
            }
            return lexicon.getText("hx.disableAutoRefreshToggle.label", (Context)op);
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.always;
        }

        public boolean isSelected(HxOp op) {
            return this.isDisabled(op);
        }

        public boolean handle(boolean selected, HxOp op) throws Exception {
            this.flipIsDisabled(op);
            if (this.isDisabled(op)) {
                String scope = SmartCommand.scopeWithOrd((String)"", (HxOp)op);
                String refreshCode = "ac.stopAutoRefresh(\"" + scope + "\");";
                op.addOnload(refreshCode);
            }
            BHxAlarmConsole.this.sort.handle(op);
            return !selected;
        }

        public void update(boolean selected, HxOp op) throws Exception {
            this.updateText(op);
        }

        private boolean isDisabled(HxOp op) {
            Object attribute = op.getRequest().getSession().getAttribute(this.getIsDisabledAttributeName(op));
            return attribute != null;
        }

        private void flipIsDisabled(HxOp op) {
            if (this.isDisabled(op)) {
                op.getRequest().getSession().removeAttribute(this.getIsDisabledAttributeName(op));
            } else {
                op.getRequest().getSession().setAttribute(this.getIsDisabledAttributeName(op), (Object)true);
            }
        }

        private String getIsDisabledAttributeName(HxOp op) {
            return SmartCommand.scopeWithOrd((String)"autoRefreshDisabled", (HxOp)op);
        }
    }

    public class ForceClear
    extends AlarmCommand {
        public ForceClear(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.forceClear.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.forceClear.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            if (op.getPermissionsForTarget().hasAdminInvoke() || op.getPermissionsForTarget().hasAdminWrite()) {
                if (op.getUnsafePostBody() == null || op.getFormValue("recurringAlarms") == null) {
                    String[] uuids = BHxAlarmConsole.this.getSelection(op);
                    for (int i = 0; i < uuids.length; ++i) {
                        BHxAlarmConsole.this.forceClearBySource(op.getFormValue("_" + uuids[i]), op);
                    }
                } else {
                    String[] uuids = BHxAlarmConsole.this.getSelection(op);
                    for (int i = 0; i < uuids.length; ++i) {
                        BHxAlarmConsole.this.forceClearByUuid(uuids[i], op);
                    }
                }
                BHxAlarmConsole.this.updateTable(op);
            }
        }
    }

    public class AlarmNotesDialog
    extends Dialog {
        public AlarmNotesDialog(Command handler) {
            super("Alarm Notes", handler);
        }

        public Command[] getCommands() {
            return new Command[]{new Dialog.Submit((Dialog)this), new Dialog.Cancel((Dialog)this)};
        }

        public void writeContent(HxOp op) throws Exception {
            String alarmNotes = this.getAlarmNotes(op);
            HtmlWriter out = op.getHtmlWriter();
            out.w((Object)"<div style='display:block;' >");
            out.w((Object)"<textarea rows='4' cols='40' readonly='yes' wrap='hard'>");
            out.safe((Object)alarmNotes);
            out.w((Object)"</textarea><br />");
            out.w((Object)"</div>");
            out.w((Object)("<textarea rows='4' cols='40' name='" + op.scope("notes") + "' >"));
            out.w((Object)"</textarea>");
        }

        private String getAlarmNotes(HxOp op) {
            String[] uuids = BHxAlarmConsole.this.getSelection(op);
            String notes = "";
            if (op.getUnsafePostBody() == null || op.getFormValue("recurringAlarms") == null) {
                for (int i = 0; i < uuids.length; ++i) {
                    String source = op.getFormValue("_" + uuids[i]);
                    notes = notes + this.getAlarmNotesBySource(op, source);
                }
            } else {
                for (int i = 0; i < uuids.length; ++i) {
                    notes = notes + this.getAlarmNotesByUUID(op, uuids[i]);
                }
            }
            return notes;
        }

        private String getAlarmNotesBySource(HxOp op, String src) {
            if (src == null) {
                return "";
            }
            BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where source = OrdList '" + src + "'"));
            BITable result = (BITable)ord.resolve(op.get()).get();
            ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
            try (TableCursor cur = result.cursor();){
                while (cur.next()) {
                    arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
                }
            }
            StringBuilder buffer = new StringBuilder();
            if (arr.size() > 1) {
                buffer.append(lexicon.getText("hx.notes.multiple", (Context)op) + "\n");
            }
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                BObject value = alarm.getAlarmData().get("notes");
                if (null == value) continue;
                buffer.append(value.toString());
            }
            return buffer.toString();
        }

        private String getAlarmNotesByUUID(HxOp op, String uuid) {
            if (uuid == null) {
                return "";
            }
            StringBuilder buffer = new StringBuilder();
            BOrd ord = BOrd.make((String)("alarm:|bql:select * from openAlarms where uuid = Uuid '" + uuid + "'"));
            BITable result = (BITable)ord.resolve(op.get()).get();
            ArrayList<BAlarmRecord> arr = new ArrayList<BAlarmRecord>();
            try (TableCursor cur = result.cursor();){
                while (cur.next()) {
                    arr.add((BAlarmRecord)((BAlarmRecord)cur.get()).newCopy());
                }
            }
            if (arr.size() > 1) {
                buffer.append(lexicon.getText("hx.notes.multiple", (Context)op) + "\n");
            }
            for (int j = 0; j < arr.size(); ++j) {
                BAlarmRecord alarm = (BAlarmRecord)arr.get(j);
                BObject value = alarm.getAlarmData().get("notes");
                if (null == value) continue;
                buffer.append(value.toString());
            }
            return buffer.toString();
        }
    }

    public class AddNotes
    extends AlarmCommand {
        Dialog dlg;

        public AddNotes(BHxView view) {
            super(view);
            this.dlg = new AlarmNotesDialog(this);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.addNotes.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.notes.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            if (!this.dlg.isSubmit(op)) {
                this.dlg.open(op);
                return;
            }
            String notes = op.getFormValue("notes");
            String[] uuids = BHxAlarmConsole.this.getSelection(op);
            if (op.getUnsafePostBody() == null || op.getFormValue("recurringAlarms") == null) {
                for (int i = 0; i < uuids.length; ++i) {
                    String source = op.getFormValue("_" + uuids[i]);
                    BHxAlarmConsole.this.addAlarmNoteBySource(source, notes, op);
                }
            } else {
                for (int i = 0; i < uuids.length; ++i) {
                    BHxAlarmConsole.this.addAlarmNoteByUuid(uuids[i], notes, op);
                }
            }
            BHxAlarmConsole.this.updateTable(op);
        }
    }

    public class Acknowledge
    extends AlarmCommand {
        public Acknowledge(BHxView view) {
            super(view);
        }

        public String getDisplayName(HxOp op) {
            return lexicon.getText("hx.acknowledge.label", (Context)op);
        }

        @Override
        public BImage getIcon(HxOp op) {
            return BImage.make((BIcon)BIcon.make((String)lexicon.getText("hx.acknowledge.icon", (Context)op)));
        }

        public void handle(HxOp op) throws Exception {
            if (op.getUnsafePostBody() == null || op.getFormValue("recurringAlarms") == null) {
                String[] uuids;
                for (String uuid : uuids = BHxAlarmConsole.this.getSelection(op)) {
                    BHxAlarmConsole.this.ackAlarmBySource(op.getFormValue("_" + uuid), null, op);
                }
            } else {
                String[] uuids;
                for (String uuid : uuids = BHxAlarmConsole.this.getSelection(op)) {
                    BHxAlarmConsole.this.ackAlarmByUuid(uuid, null, op);
                }
            }
            BHxAlarmConsole.this.updateTable(op);
        }
    }

    public class AlarmCommand
    extends Command {
        public AlarmCommand(BHxView view) {
            super(view);
        }

        public BImage getIcon(HxOp op) {
            return null;
        }
    }

    protected class SourceAlarm {
        public BAlarmRecord alarm = new BAlarmRecord(BUuid.DEFAULT);
        public int ackedCount = 0;
        public int unackedCount = 0;
        public int pendingCount = 0;

        public SourceAlarm() {
            this.alarm.setTimestamp(BAbsTime.NULL);
        }

        public Object get(String s) {
            if (s.equals(BAlarmRecord.ackState.getName())) {
                return this.ackedCount + "/" + this.unackedCount + "/" + this.pendingCount;
            }
            return this.alarm.get(s);
        }

        public void update(BAlarmRecord rec) {
            if (this.alarm.getTimestamp().isBefore(rec.getTimestamp())) {
                this.alarm = rec;
            }
            if (rec.isAcknowledged()) {
                ++this.ackedCount;
            } else if (rec.isAckPending()) {
                ++this.pendingCount;
            } else {
                ++this.unackedCount;
            }
        }
    }
}

