/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ui;

import com.tridium.nrio.components.BUIPointEntry;
import com.tridium.nrio.conv.BNrioThermistorType3Conversion;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.enums.BUniversalInputTypeEnum;
import com.tridium.nrio.ext.BLinearCalibrationExt;
import com.tridium.nrio.points.BNrio16ModulePoints;
import com.tridium.nrio.points.BNrio16ProxyExt;
import com.tridium.nrio.points.BNrio34ModulePoints;
import com.tridium.nrio.points.BNrio34PriSecPoints;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridium.nrio.points.BNrioResistiveInputProxyExt;
import com.tridium.nrio.points.BNrioVoltageInputProxyExt;
import com.tridium.nrio.points.BUiProxyExt;
import com.tridium.nrio.ui.BNrioPointManager;
import java.util.ArrayList;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BIWritablePoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BProxyConversion;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nrio:Nrio16Points", "nrio:Nrio16PointFolder"}, requiredPermissions="r")})
public class BNrio16PointManager
extends BNrioPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNrio16PointManager.class);
    static final Lexicon lex = Lexicon.make(MgrController.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colInstance = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BUiProxyExt.instance}, 1);
    MgrColumn colUiType = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BUiProxyExt.uiType}, 6);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNrioProxyExt.conversion}, 3);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colString = new MgrColumn.ToString("Value", 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colInstance, this.colUiType, this.colConversion, this.colString, this.colFacets};
    static final Log log = Log.getLog((String)"nrio");
    private static final NrioMgrTypeInfo[] aoType = new NrioMgrTypeInfo[]{new NrioMgrTypeInfo(Sys.getRegistry().getType("control:NumericWritable"), Sys.getRegistry().getType("nrio:NrioVoltageOutputProxyExt"), null, null, "type.VoltageOutput")};
    private static final NrioMgrTypeInfo[] roType = new NrioMgrTypeInfo[]{new NrioMgrTypeInfo(Sys.getRegistry().getType("control:BooleanWritable"), Sys.getRegistry().getType("nrio:NrioRelayOutputProxyExt"), null, null, "type.BooleanOutput")};
    private static final NrioMgrTypeInfo uiDiType = new NrioMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), Sys.getRegistry().getType("nrio:NrioBooleanInputProxyExt"), BUniversalInputTypeEnum.di_Normal, null, "type.UiBooleanInput");
    private static final NrioMgrTypeInfo uiViType = new NrioMgrTypeInfo(Sys.getRegistry().getType("control:NumericPoint"), Sys.getRegistry().getType("nrio:NrioVoltageInputProxyExt"), BUniversalInputTypeEnum.ai_0to10_vdc, null, "type.UiVoltageInput");
    private static final NrioMgrTypeInfo uiRiType = new NrioMgrTypeInfo(Sys.getRegistry().getType("control:NumericPoint"), Sys.getRegistry().getType("nrio:NrioResistiveInputProxyExt"), BUniversalInputTypeEnum.ai_Resistive, null, "type.UiResistiveInput");
    private static final NrioMgrTypeInfo uiTiType = new NrioMgrTypeInfo(Sys.getRegistry().getType("control:NumericPoint"), Sys.getRegistry().getType("nrio:NrioResistiveInputProxyExt"), BUniversalInputTypeEnum.ai_Resistive, (BProxyConversion)BNrioThermistorType3Conversion.DEFAULT, "type.UiThermistorInput");
    private static final NrioMgrTypeInfo uiCiType = new NrioMgrTypeInfo(Sys.getRegistry().getType("control:NumericPoint"), Sys.getRegistry().getType("nrio:NrioCounterInputProxyExt"), BUniversalInputTypeEnum.di_HighSpeed, null, "type.UiCounterInput");
    private static final NrioMgrTypeInfo[] uiTypes = new NrioMgrTypeInfo[]{uiDiType, uiViType, uiRiType, uiTiType, uiCiType};
    private static final NrioMgrTypeInfo[] uiDiTypes = new NrioMgrTypeInfo[]{uiDiType};
    private static final NrioMgrTypeInfo[] uiViTypes = new NrioMgrTypeInfo[]{uiViType};
    private static final NrioMgrTypeInfo[] uiRiTypes = new NrioMgrTypeInfo[]{uiRiType};
    private static final NrioMgrTypeInfo[] uiTiTypes = new NrioMgrTypeInfo[]{uiTiType};
    private static final NrioMgrTypeInfo[] uiCiTypes = new NrioMgrTypeInfo[]{uiCiType};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Class<?> getPointEntryClass() {
        return BUIPointEntry.class;
    }

    @Override
    protected MgrModel makeModel() {
        return new Io16Model(this);
    }

    @Override
    protected MgrLearn makeLearn() {
        return new Io16Learn(this);
    }

    @Override
    protected MgrState makeState() {
        return new BNrioPointManager.State();
    }

    @Override
    protected MgrController makeController() {
        return new Io16Controller(this);
    }

    static class NrioMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo extType;
        private TypeInfo pntType;
        private String displayName;
        private BUniversalInputTypeEnum uiType;
        private BProxyConversion converter;

        NrioMgrTypeInfo(TypeInfo pntType, TypeInfo extType, BUniversalInputTypeEnum uiType, BProxyConversion converter, String displayKey) {
            this.extType = extType;
            this.pntType = pntType;
            this.uiType = uiType;
            this.converter = converter;
            this.displayName = BNrioPointManager.gpioLex.getText(displayKey);
            if (this.converter == null) {
                this.converter = BDefaultProxyConversion.DEFAULT;
            }
        }

        NrioMgrTypeInfo(BComponent c) {
            BControlPoint cp = (BControlPoint)c;
            BUiProxyExt cpe = (BUiProxyExt)cp.getProxyExt();
            this.pntType = cp.getType().getTypeInfo();
            this.extType = cpe.getType().getTypeInfo();
            this.uiType = (BUniversalInputTypeEnum)cpe.getUiType();
            this.converter = cpe.getConversion();
            this.displayName = this.converter instanceof BNrioThermistorType3Conversion ? BNrioPointManager.gpioLex.getText("type.UiThermistorInput") : (this.pntType.is(BIWritablePoint.TYPE) ? BNrioPointManager.gpioLex.getText("type." + this.extType.getTypeName() + "Writable") : BNrioPointManager.gpioLex.getText("type." + this.extType.getTypeName() + "Point"));
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public TypeInfo getExtTypeInfo() {
            return this.extType;
        }

        public BProxyConversion getConverter() {
            return this.converter;
        }

        public BImage getIcon() {
            return null;
        }

        public BComponent newInstance() {
            BControlPoint pnt = (BControlPoint)this.pntType.getInstance();
            BNrio16ProxyExt ext = (BNrio16ProxyExt)this.extType.getInstance();
            ext.setConversion(this.converter);
            pnt.setProxyExt((BAbstractProxyExt)ext);
            BFacets facets = pnt.getFacets();
            if (this.converter instanceof BNrioThermistorType3Conversion) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)BUnit.getUnit((String)"celsius"));
            } else {
                BIDataValue facetsValue = (BIDataValue)ext.getDeviceFacets().get("units");
                if (facetsValue != null) {
                    facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)facetsValue);
                }
            }
            pnt.setFacets(facets);
            if (ext instanceof BNrioVoltageInputProxyExt) {
                pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"volt")), 0);
            }
            if (ext instanceof BNrioResistiveInputProxyExt) {
                if (this.converter instanceof BNrioThermistorType3Conversion) {
                    pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"celsius")), 0);
                } else {
                    pnt.add("linearCalibration", (BValue)new BLinearCalibrationExt(BUnit.getUnit((String)"ohm")), 0);
                }
            }
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class Io16Learn
    extends BNrioPointManager.Learn {
        Io16Learn(BNrio16PointManager mgr) {
            super(mgr);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BUIPointEntry.ioType, 0), new MgrColumn.Prop(BUIPointEntry.instance, 0), new MgrColumn.Prop(BUIPointEntry.usedByPoint, 0)};
        }

        public BImage getIcon(Object dis) {
            BUIPointEntry entry = (BUIPointEntry)dis;
            if (entry.getIoType() == BNrioIoTypeEnum.universalInput) {
                return BNrioPointManager.mixIcon;
            }
            if (entry.getIoType() == BNrioIoTypeEnum.analogOutput) {
                return BNrioPointManager.floatIcon;
            }
            return BNrioPointManager.booleanIcon;
        }

        @Override
        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            BUIPointEntry disc = (BUIPointEntry)discovery;
            if (disc.getIoType().equals((Object)BNrioIoTypeEnum.universalInput)) {
                return uiTypes;
            }
            if (disc.getIoType().equals((Object)BNrioIoTypeEnum.analogOutput)) {
                return aoType;
            }
            return roType;
        }

        @Override
        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BUIPointEntry entry = (BUIPointEntry)discovery;
            row.setDefaultName(entry.getName());
            row.setCell(BNrio16PointManager.this.colInstance, (BValue)BInteger.make((int)entry.getInstance()));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            BUIPointEntry entry = (BUIPointEntry)discovery;
            try {
                if (component == null || component.getName() == null) {
                    entry.setUsedByPoint("");
                    return false;
                }
                if (entry.matches(component)) {
                    entry.setUsedByPoint(component.getParent().getDisplayName(null) + "." + component.getDisplayName(null));
                    return true;
                }
                entry.setUsedByPoint("");
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                entry.setUsedByPoint("");
                return false;
            }
        }
    }

    public class Io16Model
    extends BNrioPointManager.Model {
        Io16Model(BNrio16PointManager mgr) {
            super(mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNrio16PointManager.this.cols;
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            NrioMgrTypeInfo nrioType = (NrioMgrTypeInfo)type;
            BControlPoint pt = (BControlPoint)nrioType.newInstance();
            return pt;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList<NrioMgrTypeInfo> list = new ArrayList<NrioMgrTypeInfo>();
            list.add(aoType[0]);
            list.add(roType[0]);
            for (int i = 0; i < uiTypes.length; ++i) {
                list.add(uiTypes[i]);
            }
            return list.toArray(new MgrTypeInfo[0]);
        }
    }

    public class Io16Controller
    extends BNrioPointManager.Controller {
        Io16Controller(BNrio16PointManager manager) {
            super(manager);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            this.allDescendants.setSelected(true);
            super.doDiscover(context);
            if (BNrio16PointManager.this.deviceExt instanceof BNrio34PriSecPoints) {
                BNrio16PointManager.this.updateDiscoveryRows((BComponent)new BNrio34ModulePoints());
            } else {
                BNrio16PointManager.this.updateDiscoveryRows((BComponent)new BNrio16ModulePoints());
            }
            return null;
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrModel model = this.getManager().getModel();
            MgrTypeInfo[] types = model.getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem(types[i].getIcon(), (Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.count")));
            grid.add(null, (BValue)countField);
            String title = this.newCommand.getLabel();
            int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
            if (r == 2) {
                return null;
            }
            NrioMgrTypeInfo type = (NrioMgrTypeInfo)((Object)typeField.getSelectedItem());
            int count = Integer.parseInt(countField.getText());
            MgrEdit edit = this.makeEdit(title);
            BControlPoint newPoint = (BControlPoint)model.newInstance((MgrTypeInfo)type);
            if (type.pntType.is(BNumericWritable.TYPE)) {
                types = aoType;
            } else if (type.pntType.is(BBooleanWritable.TYPE)) {
                types = roType;
            } else {
                types = uiTypes;
                int uiType = ((BUiProxyExt)newPoint.getProxyExt()).getUiType().getOrdinal();
                switch (uiType) {
                    case 5: {
                        types = uiViTypes;
                        break;
                    }
                    case 2: {
                        types = uiCiTypes;
                        break;
                    }
                    case 1: {
                        types = uiDiTypes;
                        break;
                    }
                    case 3: {
                        if (type.getConverter() == null) {
                            types = uiRiTypes;
                            break;
                        }
                        types = uiTiTypes;
                        break;
                    }
                    default: {
                        types = uiTypes;
                    }
                }
            }
            for (int i = 0; i < count; ++i) {
                edit.addRow(new MgrEditRow(model.newInstance((MgrTypeInfo)type), null, types));
            }
            return edit;
        }
    }
}

