/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ui;

import com.tridium.nrio.BNrio16Module;
import com.tridium.nrio.BNrio34Module;
import com.tridium.nrio.BNrio34SecModule;
import com.tridium.nrio.BNrioDevice;
import com.tridium.nrio.BNrioDeviceFolder;
import com.tridium.nrio.BNrioInputOutputModule;
import com.tridium.nrio.BNrioNetwork;
import com.tridium.nrio.components.BNrioLearnDeviceEntry;
import com.tridium.nrio.enums.BNrioDeviceTypeEnum;
import com.tridium.nrio.job.BNrioLearnDevicesJob;
import com.tridium.nrio.ui.NrioDeviceState;
import com.tridium.util.ArrayUtil;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.space.Mark;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nrio:NrioNetwork"}, requiredPermissions="r")})
public class BNrioDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioDeviceManager.class);
    static String lexName = UiLexicon.bajaui().getText("name");
    DiscoveryListSubscriber discoveryListSubscriber;
    static final Lexicon superLexicon = Lexicon.make(MgrController.class);
    static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BNrioDeviceManager.class);
    static final Lexicon lex = Lexicon.make(BNrioDeviceManager.class);
    static BImage stationIcon = BImage.make((String)"module://icons/x16/device.png");
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colDevType = new MgrColumn.Prop(BNrioDevice.deviceType, 5);
    MgrColumn colExts = new DeviceExtsColumn((BDevice)new BNrioDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnable = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 2);
    MgrColumn colAddress = new MgrColumn.Prop(BNrioDevice.address, 5);
    MgrColumn colSecAddr = new PropPath("SecAddr", new Property[]{BNrio34Module.io34Sec, BNrioDevice.address}, 5);
    MgrColumn colUid = new BlobColumn(BNrioDevice.uid, 5);
    MgrColumn colInsVer = new MgrColumn.Prop(BNrioDevice.installedVersion);
    MgrColumn colSecVer = new MgrColumn.Prop(BNrio34Module.secVersion);
    MgrColumn colAvaVer = new MgrColumn.Prop(BNrioDevice.availableVersion);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNrioDeviceManager() {
        this.discoveryListSubscriber = new DiscoveryListSubscriber();
    }

    public BNrioNetwork getNrioNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BNrioDeviceFolder) {
            return (BNrioNetwork)((BNrioDeviceFolder)owner).getNetwork();
        }
        if (owner instanceof BNrioNetwork) {
            return (BNrioNetwork)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        BNrioDeviceManager bNrioDeviceManager = this;
        synchronized (bNrioDeviceManager) {
            super.paint(g);
        }
    }

    void updateLearnData() {
        try {
            BNrioLearnDevicesJob learnJob = (BNrioLearnDevicesJob)this.getLearn().getJob();
            if (learnJob != null) {
                this.getLearn().updateRoots(learnJob.getLearnedDevices().getChildren(BNrioLearnDeviceEntry.class));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BNrioDevice[] getSelectedDevices() {
        if (this.getModel() == null || this.getModel().getTable() == null) {
            return new BNrioDevice[0];
        }
        BComponent[] selection = this.getModel().getTable().getSelectedComponents();
        Object[] devices = new BNrioDevice[]{};
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i].getType().is(BNrioDevice.TYPE)) continue;
            devices = (BNrioDevice[])ArrayUtil.addOne((Object[])devices, (Object)((BNrioDevice)selection[i]));
        }
        return devices;
    }

    public void deactivated() {
        super.deactivated();
        Object[] learnEntries = this.getLearn().getRoots();
        for (int i = 0; i < learnEntries.length; ++i) {
            BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)learnEntries[i];
            entry.stopWink(this.getCurrentContext());
        }
    }

    public boolean isThisDeviceValid(BNrioLearnDeviceEntry disc) {
        int ordinal = disc.getDeviceType().getOrdinal();
        return ordinal == 4 || ordinal == 6 || ordinal == 7 || ordinal == 5 || ordinal == 3 || ordinal == 2;
    }

    protected MgrModel makeModel() {
        return new NrioDeviceModel(this);
    }

    protected MgrLearn makeLearn() {
        return new NrioDeviceLearn();
    }

    protected MgrController makeController() {
        return new NrioDeviceController(this);
    }

    protected MgrState makeState() {
        return new NrioDeviceState();
    }

    public static class PropPath
    extends MgrColumn.PropPath {
        public PropPath(Property[] props) {
            super(props, 0);
        }

        public PropPath(String name, Property[] props, int flags) {
            super(name, props, flags);
            this.props = props;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComplex target = this.getTargetBase(row);
            int len = this.props.length;
            for (int i = 0; i < len - 1; ++i) {
                try {
                    target = (BComplex)target.get(this.props[i]);
                    continue;
                }
                catch (Exception e) {
                    return;
                }
            }
            Property prop = this.props[len - 1];
            BValue old = target.get(prop);
            if (!old.equivalent((Object)value)) {
                target.set(prop, value.newCopy(), cx);
            }
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            BComplex val = this.getRowBase(row);
            for (int i = 0; i < this.props.length - 1; ++i) {
                try {
                    val = (BComplex)val.get(this.props[i]);
                    continue;
                }
                catch (Exception e) {
                    return "";
                }
            }
            Property prop = this.props[this.props.length - 1];
            BFacets facets = val.getSlotFacets((Slot)prop);
            if (!facets.isNull()) {
                cx = new BasicContext(cx, facets);
            }
            return ((BObject)value).toString(cx);
        }

        public BValue load(MgrEditRow row) {
            BComplex val = this.getTargetBase(row);
            for (int i = 0; i < this.props.length; ++i) {
                try {
                    val = val.get(this.props[i]);
                    continue;
                }
                catch (Exception e) {
                    val = BString.make((String)"");
                    break;
                }
            }
            return val.newCopy();
        }
    }

    class DiscoveryListSubscriber
    extends Subscriber {
        DiscoveryListSubscriber() {
        }

        public void event(BComponentEvent event) {
            BNrioDeviceManager.this.updateLearnData();
        }
    }

    public class NrioDeviceController
    extends DeviceController {
        public final MgrController.MgrCommand installFirmware;
        public final MgrController.MgrCommand addOfflineHardware;

        public NrioDeviceController(BDeviceManager manager) {
            super(manager);
            this.installFirmware = new InstallFirmware((BWidget)manager);
            this.installFirmware.setFlags(15);
            this.installFirmware.setEnabled(false);
            this.addOfflineHardware = new AddOfflineHardware((BWidget)manager);
            this.addOfflineHardware.setFlags(4);
            this.addOfflineHardware.setEnabled(false);
        }

        public BMenu makePopup(BLearnTable table, TreeTableSubject subject, BMenu menu) {
            BNrioLearnDeviceEntry subjectEntry;
            menu = super.makePopup(table, subject, menu);
            if (subject.size() == 1 && (subjectEntry = (BNrioLearnDeviceEntry)subject.get(0)).getAddress() > 0) {
                boolean isInStation = this.getManager().getLearn().getExisting(subject.get(0)) != null;
                boolean isWinkActive = subjectEntry.isWinkActive();
                menu.add("wink", (Command)new Wink((BWidget)table, !isInStation & !isWinkActive, "wink"));
            }
            return menu;
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            this.allDescendants.setSelected(true);
            return new MgrController.IMgrCommand[]{this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.match, this.quickMatch, this.templateMode, this.installFirmware, this.addOfflineHardware};
        }

        public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
            if (this.add.isEnabled()) {
                this.add.invoke();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCommands() {
            BNrioDeviceManager bNrioDeviceManager = BNrioDeviceManager.this;
            synchronized (bNrioDeviceManager) {
                BComponent entry;
                int i;
                BNrioDevice device;
                super.updateCommands();
                BNrioNetwork network = BNrioDeviceManager.this.getNrioNetwork();
                int maxDevicesCount = network.getMaxDevices();
                BComponent[] selectedRows = this.getSelectedComponents();
                boolean enableInstallFirmware = false;
                for (int i2 = 0; !(i2 >= selectedRows.length || (device = (BNrioDevice)selectedRows[i2]).isFault() || device.isDown() || device.isDown()); ++i2) {
                    if (device.isFirmwareUptodate()) continue;
                    enableInstallFirmware = true;
                    break;
                }
                this.installFirmware.setEnabled(enableInstallFirmware);
                boolean enableAdd = false;
                if (this.getLearnTable() != null) {
                    Object[] disSelRows = this.getLearnTable().getSelectedObjects();
                    enableAdd = disSelRows.length > 0;
                    for (int i3 = 0; i3 < disSelRows.length; ++i3) {
                        if (BNrioDeviceManager.this.getLearn().getExisting(disSelRows[i3]) == null) continue;
                        enableAdd = false;
                        break;
                    }
                }
                int moduleCount = 0;
                if (this.getTable() != null && this.getTable().getComponentModel() != null) {
                    BComponent[] rows = this.getTable().getComponentModel().getRows();
                    for (i = 0; i < rows.length; ++i) {
                        entry = rows[i];
                        ++moduleCount;
                    }
                }
                if (this.learnMode.isSelected()) {
                    Object[] disSelRows = this.getLearnTable().getSelectedObjects();
                    for (i = 0; i < disSelRows.length; ++i) {
                        entry = (BNrioLearnDeviceEntry)disSelRows[i];
                        if (BNrioDeviceManager.this.isThisDeviceValid((BNrioLearnDeviceEntry)entry)) {
                            ++moduleCount;
                            continue;
                        }
                        enableAdd = false;
                    }
                    if (moduleCount > maxDevicesCount) {
                        enableAdd = false;
                    }
                }
                this.add.setEnabled(enableAdd);
                this.quickAdd.setEnabled(enableAdd);
                this.addOfflineHardware.setEnabled(moduleCount <= maxDevicesCount);
            }
        }

        public boolean canAdd(BObject[] values) {
            int moduleCount = 0;
            BComponent[] rows = this.getTable().getComponentModel().getRows();
            for (int i = 0; i < rows.length; ++i) {
                BComponent entry = rows[i];
                ++moduleCount;
            }
            boolean canAdd = true;
            for (int i = 0; i < values.length; ++i) {
                BComplex entry = (BComplex)values[i];
                ++moduleCount;
            }
            int maxDevicesCount = BNrioDeviceManager.this.getNrioNetwork().getMaxDevices();
            if (moduleCount > maxDevicesCount) {
                return false;
            }
            return canAdd;
        }

        public CommandArtifact drop(BMgrTable table, TransferContext cx) throws Exception {
            try {
                BAbstractManager mgr = this.getManager();
                String data = (String)cx.getEnvelope().getData(TransferFormat.string);
                String learnData = "dragFromLearn:" + mgr.hashCode();
                if (data.trim().equals(learnData.trim())) {
                    if (!this.add.isEnabled()) {
                        return null;
                    }
                    return this.add.doInvoke();
                }
                Mark mark = (Mark)cx.getEnvelope().getData(TransferFormat.mark);
                BObject[] values = mark.getValues();
                if (this.canAdd(values)) {
                    return this.add.doInvoke();
                }
                return null;
            }
            catch (Exception exception) {
                return super.drop(table, cx);
            }
        }

        public CommandArtifact doInstallFirmware() throws Exception {
            BNrioNetwork accessNet = BNrioDeviceManager.this.getNrioNetwork();
            BOrd ordToUpgradeJob = accessNet.upgradeFirmware();
            BNrioDeviceManager.this.getLearn().setJob(ordToUpgradeJob);
            return null;
        }

        public CommandArtifact doAddOfflineHardware() throws Exception {
            MgrTypeInfo[] types = MgrTypeInfo.makeArray((TypeInfo[])new TypeInfo[]{BNrio16Module.TYPE.getTypeInfo(), BNrio34Module.TYPE.getTypeInfo()});
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem(types[i].getIcon(), (Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField nameField = new BTextField("");
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(lex.getText("add.name")));
            grid.add(null, (BValue)nameField);
            grid.add(null, (BValue)new BLabel(lex.getText("add.type")));
            grid.add(null, (BValue)typeField);
            String title = this.addOfflineHardware.getLabel();
            int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
            if (r == 2) {
                return null;
            }
            MgrTypeInfo type = (MgrTypeInfo)typeField.getSelectedItem();
            String name = nameField.getText();
            BNrioDevice device = (BNrioDevice)this.getManager().getModel().newInstance(type);
            BNrioDeviceManager.this.getNrioNetwork().add(SlotPath.escape((String)name), (BValue)device);
            return null;
        }

        public CommandArtifact doWink() throws Exception {
            BNrioLearnDeviceEntry discoveryDevice = (BNrioLearnDeviceEntry)this.getLearnTable().getSelectedObject();
            BNrioNetwork accessNet = BNrioDeviceManager.this.getNrioNetwork();
            discoveryDevice.doWinkDevice(accessNet, BNrioDeviceManager.this.getCurrentContext());
            this.getManager().getLearn().updateTable();
            return null;
        }

        public MgrEdit promptForNew(Context cx) throws Exception {
            MgrTypeInfo[] types = this.getManager().getModel().getNewTypes();
            if (types == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown typeField = new BListDropDown();
            for (int i = 0; i < types.length; ++i) {
                typeField.getList().addItem((Object)types[i]);
            }
            typeField.setSelectedIndex(0);
            BTextField countField = new BTextField("1", 6);
            BTextField startAddressField = new BTextField("1", 6);
            BGridPane grid = new BGridPane(2);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            grid.add(null, (BValue)typeField);
            grid.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            grid.add(null, (BValue)countField);
            grid.add(null, (BValue)new BLabel(lexicon.getText("devManager.add.startAddress")));
            grid.add(null, (BValue)startAddressField);
            String title = this.newCommand.getLabel();
            MgrTypeInfo type = null;
            int count = 0;
            int startAddress = 1;
            boolean done = false;
            while (!done) {
                int r = BDialog.open((BWidget)this.getManager(), (String)title, (Object)grid, (int)3);
                if (r == 2) {
                    return null;
                }
                type = (MgrTypeInfo)typeField.getSelectedItem();
                count = Integer.parseInt(countField.getText());
                startAddress = Integer.parseInt(startAddressField.getText());
                if (count > 247) {
                    BDialog.error((BWidget)this.getManager(), (Object)lexicon.getText("devManager.error.invalidCount"));
                    continue;
                }
                done = true;
            }
            MgrEdit edit = this.makeEdit(title);
            for (int i = 0; i < count; ++i) {
                if (startAddress < 1 || startAddress > 247) {
                    startAddress = 1;
                }
                BComponent comp = ((NrioDeviceModel)this.getManager().getModel()).newInstance(type, startAddress);
                MgrEditRow row = new MgrEditRow(comp, null, types);
                edit.addRow(row);
                row.setDefaultName(SlotPath.escape((String)(type.getDisplayName() + startAddress)));
                ++startAddress;
            }
            return edit;
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            BNrioNetwork network = BNrioDeviceManager.this.getNrioNetwork();
            if (network.isDisabled() || network.isFault()) {
                throw new RuntimeException("Network is disabled or configured incorrectly");
            }
            try {
                Object[] learnEntries = BNrioDeviceManager.this.getLearn().getRoots();
                for (int i = 0; i < learnEntries.length; ++i) {
                    BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)learnEntries[i];
                    entry.stopWink(cx);
                }
            }
            catch (Exception learnEntries) {
                // empty catch block
            }
            super.doDiscover(cx);
            BOrd ordToDiscoveryJob = network.submitDeviceDiscoveryJob();
            BNrioDeviceManager.this.getLearn().setJob(ordToDiscoveryJob);
            return null;
        }

        protected CommandArtifact doAdd(Object[] discovery, Context cx) throws Exception {
            for (int i = 0; i < discovery.length; ++i) {
                ((BNrioLearnDeviceEntry)discovery[i]).stopWink(cx);
            }
            return super.doAdd(discovery, cx);
        }

        public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) {
            BNrioLearnDeviceEntry discoverComp = (BNrioLearnDeviceEntry)discovery;
            BNrioDevice stationComp = (BNrioDevice)database;
            int addr = discoverComp.getAddress();
            this.matchDevice(discoverComp, stationComp, addr, true);
            if (stationComp instanceof BNrio34Module) {
                BNrio34SecModule io34Sec = ((BNrio34Module)stationComp).getIo34Sec();
                this.matchDevice(discoverComp, (BNrioDevice)io34Sec, discoverComp.getSecAddrInt(), false);
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private void matchDevice(BNrioLearnDeviceEntry discoverComp, BNrioDevice stationComp, int addr, boolean setType) {
            stationComp.setUid(discoverComp.getUid());
            if (setType) {
                stationComp.setDeviceType(discoverComp.getDeviceType());
            }
            if (stationComp.getAddress() == 0) {
                stationComp.setAddress(addr);
            }
        }

        class Wink
        extends MgrController.MgrCommand {
            Wink(BWidget owner, boolean enable, String label) {
                super(owner, (Lexicon)lexicon, label);
                this.setEnabled(enable);
            }

            public CommandArtifact doInvoke() throws Exception {
                return NrioDeviceController.this.doWink();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class AddOfflineHardware
        extends MgrController.MgrCommand {
            AddOfflineHardware(BWidget owner) {
                super(owner, (Lexicon)lexicon, "addOfflineHardware");
            }

            public CommandArtifact doInvoke() throws Exception {
                return NrioDeviceController.this.doAddOfflineHardware();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }

        class InstallFirmware
        extends MgrController.MgrCommand {
            InstallFirmware(BWidget owner) {
                super(owner, (Lexicon)lexicon, "upgradeFirmware");
            }

            public CommandArtifact doInvoke() throws Exception {
                return NrioDeviceController.this.doInstallFirmware();
            }

            public Command doMerge(Command c) {
                return this;
            }
        }
    }

    class NrioDeviceLearn
    extends MgrLearn {
        NrioDeviceLearn() {
            super((BAbstractManager)BNrioDeviceManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BNrioLearnDeviceEntry.address), new MgrColumn.Prop(BNrioLearnDeviceEntry.secAddr), new MgrColumn.Prop(BNrioLearnDeviceEntry.deviceType), new BlobColumn(BNrioLearnDeviceEntry.uid, 0), new MgrColumn.Prop(BNrioLearnDeviceEntry.version), new MgrColumn.Prop(BNrioLearnDeviceEntry.usedBy)};
        }

        public BImage getIcon(Object dis) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)dis;
            if (BNrioDeviceManager.this.isThisDeviceValid(learnEntry)) {
                return stationIcon;
            }
            return stationIcon.getDisabledImage();
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)discovery;
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.remoteInputOutput)) {
                return MgrTypeInfo.makeArray((Type)BNrioInputOutputModule.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.io16)) {
                return MgrTypeInfo.makeArray((Type)BNrio16Module.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.io16V1)) {
                return MgrTypeInfo.makeArray((Type)BNrio16Module.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.io34)) {
                return MgrTypeInfo.makeArray((Type)BNrio34Module.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.io34sec)) {
                return MgrTypeInfo.makeArray((Type)BNrio34Module.TYPE);
            }
            if (learnEntry.getDeviceType().equals((Object)BNrioDeviceTypeEnum.remoteReader)) {
                return MgrTypeInfo.makeArray((Type)BNrioDevice.TYPE);
            }
            return new MgrTypeInfo[0];
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)discovery;
            row.setDefaultName(learnEntry.getDefaultAddAddress());
            if (learnEntry.getSecAddrInt() > 0) {
                row.setCell(BNrioDeviceManager.this.colSecAddr, (BValue)BInteger.make((int)learnEntry.getSecAddrInt()));
            }
            row.setCell(BNrioDeviceManager.this.colAddress, (BValue)BInteger.make((int)learnEntry.getAddress()));
            row.setCell(BNrioDeviceManager.this.colDevType, (BValue)learnEntry.getDeviceType());
            row.setCell(BNrioDeviceManager.this.colUid, (BValue)learnEntry.getUid());
        }

        public boolean isExisting(Object dis, BComponent comp) {
            try {
                BNrioLearnDeviceEntry learnEntry = (BNrioLearnDeviceEntry)dis;
                if (learnEntry.isWinkActive()) {
                    return true;
                }
                BNrioDevice d = (BNrioDevice)comp;
                return d.getUid().equals((Object)learnEntry.getUid());
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean isMatchable(Object dis, BComponent db) {
            try {
                BNrioNetwork network = ((BNrioDeviceManager)this.getManager()).getNrioNetwork();
                BNrioLearnDeviceEntry entry = (BNrioLearnDeviceEntry)dis;
                BNrioDevice d = network.getDevice(entry.getAddress());
                if (d != null) {
                    return false;
                }
                return entry.isMatchable(db);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BNrioLearnDevicesJob) {
                BNrioDeviceManager.this.updateLearnData();
            }
        }
    }

    class BlobColumn
    extends MgrColumn.Prop {
        BlobColumn(Property prop, int flags) {
            super(prop, flags);
        }

        public String toDisplayString(Object row, Object value, Context cx) {
            if (value instanceof BBlob) {
                byte[] temp = ((BBlob)value).copyBytes();
                byte[] bytes = new byte[temp.length];
                for (int i = 0; i < temp.length; ++i) {
                    bytes[temp.length - 1 - i] = temp[i];
                }
                return ByteArrayUtil.toHexString((byte[])bytes);
            }
            return super.toDisplayString(row, value, cx);
        }
    }

    public class NrioDeviceModel
    extends DeviceModel {
        NrioDeviceModel(BNrioDeviceManager mgr) {
            super((BDeviceManager)mgr);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{BNrioDeviceManager.this.colName, BNrioDeviceManager.this.colDevType, BNrioDeviceManager.this.colExts, BNrioDeviceManager.this.colStatus, BNrioDeviceManager.this.colEnable, BNrioDeviceManager.this.colHealth, BNrioDeviceManager.this.colAddress, BNrioDeviceManager.this.colSecAddr, BNrioDeviceManager.this.colUid, BNrioDeviceManager.this.colInsVer, BNrioDeviceManager.this.colSecVer, BNrioDeviceManager.this.colAvaVer};
        }

        public BComponent newInstance(MgrTypeInfo type, int address) throws Exception {
            BNrioDevice device = (BNrioDevice)this.newInstance(type);
            device.setAddress(address);
            return device;
        }

        public void load(BComponent target) {
            super.load(target);
            target.lease(2);
        }
    }
}

