/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ui;

import com.tridium.nrio.components.BInputOutputModulePoints;
import com.tridium.nrio.components.BNrioIOPointEntry;
import com.tridium.nrio.enums.BNrioIoTypeEnum;
import com.tridium.nrio.points.BNrioProxyExt;
import com.tridium.nrio.ui.BNrioPointManager;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"nrio:NrioIOPoints", "nrio:NrioIOPointFolder"}, requiredPermissions="r")})
public class BNrioIOPointManager
extends BNrioPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioIOPointManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type(1);
    MgrColumn colInstance = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNrioProxyExt.instance}, 1);
    MgrColumn colIsSdi = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNrioProxyExt.isSdi}, 7);
    MgrColumn colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BNrioProxyExt.conversion}, 3);
    MgrColumn colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
    MgrColumn colString = new MgrColumn.ToString("Value", 0);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colInstance, this.colIsSdi, this.colConversion, this.colString, this.colFacets};
    static final Log log = Log.getLog((String)"nrio");
    private static final NrioMgrTypeInfo[] diType = new NrioMgrTypeInfo[]{new NrioMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), false)};
    private static final NrioMgrTypeInfo[] sdiType = new NrioMgrTypeInfo[]{new NrioMgrTypeInfo(Sys.getRegistry().getType("control:BooleanPoint"), true)};
    private static final NrioMgrTypeInfo[] roType = new NrioMgrTypeInfo[]{new NrioMgrTypeInfo(Sys.getRegistry().getType("control:BooleanWritable"), false)};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Class<?> getPointEntryClass() {
        return BNrioIOPointEntry.class;
    }

    @Override
    protected MgrModel makeModel() {
        return new Model(this);
    }

    @Override
    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    @Override
    protected MgrState makeState() {
        return new BNrioPointManager.State();
    }

    @Override
    protected MgrController makeController() {
        return new Controller(this);
    }

    static class NrioMgrTypeInfo
    extends MgrTypeInfo {
        private TypeInfo pntType;
        private boolean isSdi;

        NrioMgrTypeInfo(TypeInfo pntType, boolean isSdi) {
            this.pntType = pntType;
            this.isSdi = isSdi;
        }

        public TypeInfo getPointTypeInfo() {
            return this.pntType;
        }

        public boolean isSdi() {
            return this.isSdi;
        }

        public BImage getIcon() {
            return null;
        }

        public String getDisplayName() {
            return this.pntType.getDisplayName(null);
        }

        public BComponent newInstance() {
            BControlPoint pnt = (BControlPoint)this.pntType.getInstance();
            BNrioProxyExt ext = new BNrioProxyExt();
            if (pnt instanceof BBooleanPoint) {
                ext.setIsSdi(this.isSdi);
                pnt.setProxyExt((BAbstractProxyExt)ext);
                pnt.setFacets(BFacets.makeBoolean((String)"Active", (String)"Inactive"));
            }
            return pnt;
        }

        public boolean isMatchable(BComponent db) {
            return false;
        }
    }

    class Learn
    extends BNrioPointManager.Learn {
        Learn(BNrioIOPointManager mgr) {
            super(BNrioIOPointManager.this, mgr);
        }

        @Override
        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Prop(BNrioIOPointEntry.ioType, 0), new MgrColumn.Prop(BNrioIOPointEntry.instance, 0), new MgrColumn.Prop(BNrioIOPointEntry.usedByPoint, 0)};
        }

        @Override
        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            BNrioIOPointEntry disc = (BNrioIOPointEntry)discovery;
            if (disc.getIoType().equals((Object)BNrioIoTypeEnum.digitalInput)) {
                return diType;
            }
            if (disc.getIoType().equals((Object)BNrioIoTypeEnum.supervisedDigitalInput)) {
                return sdiType;
            }
            return roType;
        }

        public BImage getIcon(Object dis) {
            return BNrioPointManager.booleanIcon;
        }

        @Override
        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            BNrioIOPointEntry entry = (BNrioIOPointEntry)discovery;
            row.setDefaultName(entry.getName());
            row.setCell(BNrioIOPointManager.this.colInstance, (BValue)BInteger.make((int)entry.getInstance()));
            row.setCell(BNrioIOPointManager.this.colIsSdi, (BValue)BBoolean.make((boolean)entry.getIoType().equals((Object)BNrioIoTypeEnum.supervisedDigitalInput)));
        }

        public boolean isExisting(Object discovery, BComponent component) {
            try {
                BNrioIOPointEntry entry = (BNrioIOPointEntry)discovery;
                if (entry.matches(component)) {
                    entry.setUsedByPoint(component.getParent().getDisplayName(null) + "." + component.getDisplayName(null));
                    return true;
                }
                entry.setUsedByPoint("");
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
    }

    public class Model
    extends BNrioPointManager.Model {
        Model(BNrioIOPointManager mgr) {
            super(BNrioIOPointManager.this, mgr);
        }

        protected MgrColumn[] makeColumns() {
            return BNrioIOPointManager.this.cols;
        }
    }

    public class Controller
    extends BNrioPointManager.Controller {
        Controller(BNrioIOPointManager manager) {
            super(BNrioIOPointManager.this, manager);
        }

        public CommandArtifact doDiscover(Context context) throws Exception {
            this.allDescendants.setSelected(true);
            super.doDiscover(context);
            BNrioIOPointManager.this.updateDiscoveryRows((BComponent)new BInputOutputModulePoints());
            return null;
        }
    }
}

