/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nrio.ui;

import com.tridium.nrio.components.BUIPointEntry;
import com.tridium.nrio.points.BNrio16PointFolder;
import com.tridium.nrio.points.BNrioPointDeviceExt;
import java.util.ArrayList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.control.BControlPoint;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType
public class BNrioPointManager
extends BPointManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BNrioPointManager.class);
    static final Lexicon lex = Lexicon.make(MgrController.class);
    protected static Lexicon abstractLex = Lexicon.make(BPointManager.class);
    protected static Lexicon gpioLex = Lexicon.make((String)"nrio");
    protected static BImage booleanIcon = BImage.make((String)"module://icons/x16/statusBoolean.png");
    protected static BImage floatIcon = BImage.make((String)"module://icons/x16/statusNumeric.png");
    protected static BImage mixIcon = BImage.make((String)"module://icons/x16/statusMixed.png");
    static final Log log = Log.getLog((String)"nrio");
    protected BNrioPointDeviceExt deviceExt = null;
    protected BComponent[] lastLearn = null;
    protected BComponent[] existingPoints;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void init() {
        super.init();
        try {
            this.deviceExt = (BNrioPointDeviceExt)((BIPointFolder)this.getCurrentValue()).getDeviceExt();
            if (this.getCurrentValue() != this.deviceExt) {
                this.registerForComponentEvents((BComponent)this.deviceExt);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Class<?> getPointEntryClass() {
        return null;
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected void updateDiscoveryRows(BComponent event) {
        this.existingPoints = null;
        Object[] rows = (BComponent[])event.getChildren(this.getPointEntryClass());
        this.lastLearn = rows;
        for (int i = 0; i < rows.length; ++i) {
            rows[i].loadSlots();
        }
        this.getLearn().updateRoots(rows);
    }

    static class State
    extends MgrState {
        BComponent[] lastLearn = null;

        State() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BNrioPointManager manager = (BNrioPointManager)m;
            this.lastLearn = manager.lastLearn;
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BNrioPointManager manager = (BNrioPointManager)m;
            if (this.lastLearn != null) {
                manager.lastLearn = this.lastLearn;
                manager.getLearn().updateRoots((Object[])this.lastLearn);
            }
        }
    }

    class Learn
    extends MgrLearn {
        Learn(BNrioPointManager mgr) {
            super((BAbstractManager)mgr);
        }

        public String makeTableTitle() {
            return "Hardware Points";
        }

        protected MgrColumn[] makeColumns() {
            System.out.println("!!!!!! makeColumns() subclass should override !!!!!!!!!!");
            return null;
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return false;
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            BNrioPointManager.this.updateDiscoveryRows((BComponent)job);
        }

        public void toRow(Object discovery, MgrEditRow row) throws Exception {
            System.out.println("!!!!!! toRow() subclass should override !!!!!!!!!!");
        }

        public MgrTypeInfo[] toTypes(Object discovery) throws Exception {
            System.out.println("!!!!!! toTypes() subclass should override !!!!!!!!!!");
            return null;
        }

        public BComponent getExisting(Object discovery) {
            try {
                if (this.getManager().getCurrentValue() instanceof BNrioPointDeviceExt) {
                    if (this.getManager().getModel().getTable().getComponentModel().getRowCount() == 0) {
                        ((BUIPointEntry)discovery).setUsedByPoint("");
                    }
                    return super.getExisting(discovery);
                }
                if (BNrioPointManager.this.existingPoints == null || BNrioPointManager.this.existingPoints.length == 0) {
                    BNrioPointManager.this.existingPoints = this.resolveDeep((BComponent)BNrioPointManager.this.deviceExt, BNrioPointManager.this.deviceExt.getProxyExtType());
                }
                if ((BNrioPointManager.this.existingPoints == null || BNrioPointManager.this.existingPoints.length == 0) && discovery instanceof BUIPointEntry) {
                    ((BUIPointEntry)discovery).setUsedByPoint("");
                }
                for (int i = 0; i < BNrioPointManager.this.existingPoints.length; ++i) {
                    BControlPoint comp = ((BProxyExt)BNrioPointManager.this.existingPoints[i]).getParentPoint();
                    if (!this.isExisting(discovery, (BComponent)comp)) continue;
                    return comp;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        private BComponent[] resolveDeep(BComponent target, Type include) {
            String bql = "bql:select slotPath from ";
            bql = bql + include;
            BITable result = (BITable)BOrd.make((String)bql).get((BObject)target);
            ArrayList<BOrd> alist = new ArrayList<BOrd>();
            try (TableCursor cursor = result.cursor();){
                Column col = result.getColumns().get(0);
                while (cursor.next()) {
                    alist.add(BOrd.make((String)cursor.cell(col).toString()));
                }
            }
            BOrd[] ords = alist.toArray(new BOrd[0]);
            return new BatchResolve(ords).resolve((BObject)target).getTargetComponents();
        }
    }

    public class Model
    extends PointModel {
        Model(BNrioPointManager mgr) {
            super((BPointManager)mgr);
        }

        public void load(BComponent target) {
            super.load(target);
            try {
                BNrioPointManager.this.getController().doDiscover(null);
            }
            catch (Exception e) {
                log.trace("init exception", (Throwable)e);
            }
        }

        public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
            String[] names = new String[rows.length];
            BComponent[] values = new BComponent[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = rows[i].getName();
                values[i] = rows[i].getTarget();
            }
            Mark mark = new Mark((BObject[])values, names);
            BComponent container = rows[0].getEdit().getAddContainer();
            BComponent selComponent = this.getTable().getSelectedComponent();
            if (selComponent != null && selComponent instanceof BNrio16PointFolder) {
                container = selComponent;
            }
            mark.moveTo((BObject)container, null);
            return null;
        }
    }

    public class Controller
    extends PointController {
        Controller(BNrioPointManager manager) {
            super((BPointManager)manager);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return new MgrController.IMgrCommand[]{this.newFolder, this.allDescendants, this.edit, this.learnMode, this.discover, this.add};
        }

        public MgrController.IMgrCommand[] getDropDownCommands(MgrController.IMgrCommand command) {
            return null;
        }

        public void cellDoubleClicked(BLearnTable table, BMouseEvent event, int row, int col) {
            if (this.add.isEnabled()) {
                this.add.invoke();
            }
        }

        public void updateCommands() {
            super.updateCommands();
            try {
                Object[] selectedRows = this.getLearnTable().getSelectedObjects();
                boolean enableAdd = selectedRows.length > 0;
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (BNrioPointManager.this.getLearn().getExisting(selectedRows[i]) == null) continue;
                    enableAdd = false;
                    break;
                }
                this.add.setEnabled(enableAdd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public CommandArtifact doAdd(Context cx) throws Exception {
            BNrioPointManager.this.existingPoints = null;
            return super.doAdd(cx);
        }
    }
}

