/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistoryFolder;
import javax.baja.agent.AgentList;
import javax.baja.category.BCategoryMask;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BHistoryMirror
extends BObject
implements BIHistory {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryMirror.class);
    private static final BIcon icon = BIcon.std((String)"historyShortcut.png");
    private BIHistory history;
    private BINavNode navParent;
    private boolean useHistoryNavDisplayName = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryMirror(BIHistory history, BINavNode navParent) {
        this.history = history;
        this.navParent = navParent;
    }

    public BHistoryMirror(BIHistory history, BINavNode navParent, boolean useHistoryNavDisplayName) {
        this(history, navParent);
        this.useHistoryNavDisplayName = useHistoryNavDisplayName;
    }

    @Override
    public BHistoryId getId() {
        return this.history.getId();
    }

    @Override
    public BTypeSpec getRecordType() {
        return this.history.getRecordType();
    }

    @Override
    public BHistoryConfig getConfig() {
        return this.history.getConfig();
    }

    @Override
    public void close() {
    }

    public BHost getHost() {
        return this.history.getHost();
    }

    public BISession getSession() {
        return this.history.getSession();
    }

    public BSpace getSpace() {
        return this.history.getSpace();
    }

    public boolean isMounted() {
        return this.history.isMounted();
    }

    public BOrd getAbsoluteOrd() {
        return this.history.getAbsoluteOrd();
    }

    public BOrd getOrdInHost() {
        return this.history.getOrdInHost();
    }

    public BOrd getOrdInSession() {
        return this.history.getOrdInSession();
    }

    public BOrd getOrdInSpace() {
        return this.history.getOrdInSpace();
    }

    public boolean isPendingMove() {
        return this.history.isPendingMove();
    }

    public void setPendingMove(boolean pendingMove) {
        this.history.setPendingMove(pendingMove);
    }

    public String getNavName() {
        if (this.navParent instanceof BHistoryFolder) {
            String nName = this.getId().encodeToString();
            StringBuilder sb = new StringBuilder();
            if (nName.startsWith("/")) {
                sb.append("/");
            } else {
                sb.append("//");
            }
            sb.append(nName);
            return sb.toString();
        }
        return this.getId().encodeToString();
    }

    public String getNavDisplayName(Context cx) {
        BObject obj;
        boolean fullName = false;
        if (cx != null && (obj = cx.getFacet("fullHistoryDisplayName")) instanceof BBoolean) {
            fullName = ((BBoolean)obj).getBoolean();
        }
        if (this.useHistoryNavDisplayName && !fullName) {
            return this.history.getNavDisplayName(cx);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getId().getDeviceName());
        sb.append('/');
        sb.append(this.history.getNavDisplayName((Context)new BasicContext(cx, BFacets.make((String)"fullHistoryDisplayName", (boolean)false))));
        return sb.toString();
    }

    public String getNavDescription(Context cx) {
        return this.history.getNavDescription(cx);
    }

    public BINavNode getNavParent() {
        return this.navParent;
    }

    public boolean hasNavChildren() {
        return this.history.hasNavChildren();
    }

    public BINavNode getNavChild(String navName) {
        return this.history.getNavChild(navName);
    }

    public BINavNode resolveNavChild(String navName) {
        return this.history.resolveNavChild(navName);
    }

    public BINavNode[] getNavChildren() {
        return this.history.getNavChildren();
    }

    public BOrd getNavOrd() {
        if (this.navParent instanceof BHistoryFolder) {
            String nName = this.getId().encodeToString();
            StringBuilder sb = new StringBuilder();
            sb.append(this.navParent.getNavOrd().toString());
            if (nName.startsWith("/")) {
                sb.append("/");
            } else {
                sb.append("//");
            }
            sb.append(nName);
            return BOrd.make((String)sb.toString());
        }
        return this.history.getNavOrd();
    }

    public BIcon getNavIcon() {
        if (this.navParent instanceof BHistoryFolder) {
            return this.history.getNavIcon();
        }
        return icon;
    }

    public BCategoryMask getAppliedCategoryMask() {
        return this.history.getAppliedCategoryMask();
    }

    public BCategoryMask getCategoryMask() {
        return this.history.getCategoryMask();
    }

    public BPermissions getPermissions(Context cx) {
        return this.history.getPermissions(cx);
    }

    public boolean canRead(OrdTarget cx) {
        return this.history.canRead(cx);
    }

    public boolean canWrite(OrdTarget cx) {
        return this.history.canWrite(cx);
    }

    public boolean canInvoke(OrdTarget cx) {
        return this.history.canInvoke(cx);
    }

    public String getDisplayName(Context cx) {
        return this.getNavDisplayName(cx);
    }

    public String getDisplayName(Slot slot, Context cx) {
        return this.history.getDisplayName(slot, cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        return this.history.getSlotFacets(slot);
    }

    public String propertyValueToString(Property prop, Context cx) {
        return this.history.propertyValueToString(prop, cx);
    }

    public Slot getSlot(String name) {
        return this.history.getSlot(name);
    }

    public Property getProperty(String name) {
        return this.history.getProperty(name);
    }

    public int getSlotCount() {
        return this.history.getSlotCount();
    }

    public int getSlotCount(Class<?> cls) {
        return this.history.getSlotCount(cls);
    }

    public Slot[] getSlotsArray() {
        return this.history.getSlotsArray();
    }

    public SlotCursor<Slot> getSlots() {
        return this.history.getSlots();
    }

    public Property[] getPropertiesArray() {
        return this.history.getPropertiesArray();
    }

    public Property[] getFrozenPropertiesArray() {
        return this.history.getFrozenPropertiesArray();
    }

    public Property[] getDynamicPropertiesArray() {
        return this.history.getDynamicPropertiesArray();
    }

    public SlotCursor<Property> getProperties() {
        return this.history.getProperties();
    }

    public BComplex loadSlots() {
        return this.history.loadSlots();
    }

    public void lease() {
        this.history.lease();
    }

    public void lease(int depth, long millis) {
        this.history.lease(depth, millis);
    }

    public BValue get(Property property) {
        return this.history.get(property);
    }

    public BValue get(String propertyName) {
        return this.history.get(propertyName);
    }

    public void set(Property property, BValue value, Context context) {
        this.history.set(property, value, context);
    }

    public void set(String propertyName, BValue value) {
        this.history.set(propertyName, value);
    }

    public int getFlags(Slot slot) {
        return this.history.getFlags(slot);
    }

    public void setFlags(Slot slot, int flags, Context context) {
        this.history.setFlags(slot, flags, context);
    }

    public Property add(String name, BValue value, int flags, BFacets facets, Context context) {
        return this.history.add(name, value, flags, facets, context);
    }

    public void remove(String name, Context context) {
        this.history.remove(name, context);
    }

    public void remove(Property slot, Context context) {
        this.history.remove(slot, context);
    }

    public void removeAll(Context context) {
        this.history.removeAll(context);
    }

    public void rename(Property slot, String newName, Context context) {
        this.history.rename(slot, newName, context);
    }

    public void setFacets(Slot slot, BFacets facets, Context context) {
        this.history.setFacets(slot, facets, context);
    }

    public void reorder(Property[] dynamicProperties, Context context) {
        this.history.reorder(dynamicProperties, context);
    }

    public void reorderToTop(Property dynamicProperty, Context context) {
        this.history.reorderToTop(dynamicProperty, context);
    }

    public void reorderToBottom(Property dynamicProperty, Context context) {
        this.history.reorderToBottom(dynamicProperty, context);
    }

    public AgentList getAgents(Context cx) {
        if (this.history instanceof BObject) {
            return ((BObject)this.history).getAgents(cx);
        }
        return super.getAgents(cx);
    }
}

