/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.BHistory;
import com.tridium.history.HistoryTableCursor;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.util.BICombinableHistory;
import java.io.IOException;
import java.util.Optional;
import javax.baja.bql.RemoteQueryable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryCursor;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
public class BHistoryTimeQuery
extends BObject
implements BICombinableHistory<BHistoryRecord, BHistoryTimeQuery>,
RemoteQueryable {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryTimeQuery.class);
    private static final BAbsTime BEGINNING_OF_TIME = BAbsTime.make((long)1L);
    private final BHistory history;
    private final BAbsTime startTime;
    private BAbsTime endTime;
    private ColumnList columns;
    private final IFilter filter;
    private BFacets tableFacets;
    private final boolean descending;
    private final Context cx;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryTimeQuery(BHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending) {
        this(history, startTime, endTime, null, descending, null);
    }

    public BHistoryTimeQuery(BHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending, Context cx) {
        this(history, startTime, endTime, null, descending, cx);
    }

    private BHistoryTimeQuery(BHistory history, BAbsTime startTime, BAbsTime endTime, IFilter filter, boolean descending, Context cx) {
        this.history = history;
        this.startTime = startTime;
        this.endTime = endTime;
        this.filter = filter;
        this.descending = descending;
        this.cx = cx;
        BHistoryId id = history.getId();
        this.tableFacets = BFacets.make((String)"historyId", (BIDataValue)BString.make((String)id.encodeToString()), (String)"tableName", (BIDataValue)BString.make((String)history.getNavDisplayName(BHistory.FULL_DISPLAY_NAME_CX)));
        if (startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)startTime));
        }
        if (endTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)endTime));
        }
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            BTimeZone tz;
            BHistorySummary summary = conn.getSummary(history);
            BAbsTime first = summary.getFirstTimestamp();
            BAbsTime last = summary.getLastTimestamp();
            if (first != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"firstTimestamp", (BIDataValue)first));
            }
            if (last != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"lastTimestamp", (BIDataValue)last));
            }
            if ((tz = history.getConfig().getTimeZone()) != null) {
                this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"TimeZone", (BIDataValue)tz));
            }
        }
    }

    public TableCursor<BHistoryRecord> cursor() {
        Cursor<BHistoryRecord> cursor = this.history.timeQueryCursor(this.startTime, this.endTime, this.descending, this.cx);
        if (cursor instanceof HistoryCursor) {
            ((HistoryCursor)cursor).setConnectionContext(this.cx);
        }
        return new HistoryTableCursor(this, cursor, this.filter);
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryColumns.getColumns(this.history.getConfig());
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public synchronized BHistoryTimeQuery combine(BHistoryTimeQuery query) {
        if (!this.history.equals(query.history)) {
            throw new IllegalStateException("not combining from same history?");
        }
        this.endTime = query.endTime;
        this.tableFacets = query.tableFacets;
        if (this.startTime != null) {
            this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)this.startTime));
        }
        return this;
    }

    @Override
    public boolean isEmpty() {
        return !BHistoryTimeQuery.getLastRecordInRange(this.history, this.startTime, this.endTime, this.descending, this.cx).isPresent();
    }

    @Override
    public BAbsTime lastTimestamp() {
        return BHistoryTimeQuery.getLastRecordInRange(this.history, this.startTime, this.endTime, this.descending, this.cx).map(BHistoryRecord::getTimestamp).orElse(BAbsTime.NULL);
    }

    public static Optional<BHistoryRecord> getLastRecordInRange(BIHistory history, BAbsTime startTime, BAbsTime endTime, boolean descending, Context cx) {
        block65: {
            Context connectionCx = HistoryQuery.makeArchiveQueryLimitContext(cx, 1);
            try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(connectionCx);){
                Optional<BHistoryRecord> optional;
                boolean endIsNull;
                boolean startIsNull = startTime == null || startTime.isNull();
                boolean bl = endIsNull = endTime == null || endTime.isNull();
                if (descending) {
                    Optional<BHistoryRecord> optional2;
                    BAbsTime start = startIsNull ? BEGINNING_OF_TIME : startTime;
                    try (TableCursor cursor = conn.timeQuery(history, start, start).cursor();){
                        if (cursor.next()) {
                            Optional<Object> optional3 = Optional.of(cursor.get());
                            return optional3;
                        }
                        BHistoryRecord postRec = BHistoryTimeQuery.getPostRecFromContext(cursor.getContext());
                        if (postRec == null || !endIsNull && postRec.getTimestamp().compareTo((Object)endTime) > 0) break block65;
                        optional2 = Optional.of(postRec);
                    }
                    return optional2;
                }
                BHistoryRecord lastRecord = conn.getLastRecord(history);
                if (!(lastRecord == null || !endIsNull && endTime.isBefore(lastRecord.getTimestamp()) || !startIsNull && startTime.isAfter(lastRecord.getTimestamp()))) {
                    Optional<BHistoryRecord> cursor = Optional.of(lastRecord);
                    return cursor;
                }
                BAbsTime end = endIsNull ? BAbsTime.END_OF_TIME : endTime;
                try (TableCursor cursor = conn.timeQuery(history, end, end).cursor();){
                    if (cursor.next()) {
                        Optional<Object> optional4 = Optional.of(cursor.get());
                        return optional4;
                    }
                    BHistoryRecord preRec = BHistoryTimeQuery.getPreRecFromContext(cursor.getContext());
                    if (preRec == null || !startIsNull && preRec.getTimestamp().compareTo((Object)startTime) < 0) break block65;
                    optional = Optional.of(preRec);
                }
                return optional;
            }
        }
        return Optional.empty();
    }

    public static BHistoryRecord getPreRecFromContext(Context cx) {
        if (cx != null) {
            try {
                return HistoryCursor.extractPreRecord(cx.getFacets());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static BHistoryRecord getPostRecFromContext(Context cx) {
        if (cx != null) {
            try {
                return HistoryCursor.extractPostRecord(cx.getFacets());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public BObject bqlQuery(BOrd ord) {
        return this.bqlQuery(ord, null);
    }

    public BObject bqlQuery(BOrd ord, Context cx) {
        if (this.history instanceof BFoxHistory) {
            BFoxHistorySpace historySpace = (BFoxHistorySpace)this.history.getSpace();
            return historySpace.bqlQuery(ord, cx);
        }
        throw new UnresolvedException("Query is not remote.");
    }

    public BHistory getHistory() {
        return this.history;
    }

    public BAbsTime getStartTime() {
        return this.startTime;
    }

    public BAbsTime getEndTime() {
        return this.endTime;
    }

    public IFilter getFilter() {
        return this.filter;
    }
}

