/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAbstractAuditHistorySource;
import com.tridium.history.audit.BAuditHistoryService;
import com.tridium.history.audit.BSecurityAuditRecord;
import com.tridium.sys.Nre;
import com.tridium.util.HistoryCategoryUtil;
import java.security.AccessController;
import java.util.Optional;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.security.SecurityAuditor;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.make(\"station\", \"Security History\"), BTypeSpec.make(\"history\", \"SecurityAuditRecord\"))", override=true)
public class BSecurityAuditHistorySource
extends BAbstractAuditHistorySource
implements SecurityAuditor,
BIRestrictedComponent {
    @Generated
    public static final Property historyConfig = BSecurityAuditHistorySource.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make("station", "Security History"), BTypeSpec.make((String)"history", (String)"SecurityAuditRecord")), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSecurityAuditHistorySource.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BTypeSpec getRecordType() {
        return BTypeSpec.make((String)"history", (String)"SecurityAuditRecord");
    }

    @Override
    protected BHistoryId getHistoryId() {
        return BHistoryId.make(Sys.getStation().getStationName(), "SecurityHistory");
    }

    @Override
    protected void auditStarted() {
        AccessController.doPrivileged(() -> {
            Nre.setSecurityAuditor((SecurityAuditor)this);
            return null;
        });
    }

    @Override
    protected void auditStopped() {
        AccessController.doPrivileged(() -> {
            Nre.setSecurityAuditor(null);
            return null;
        });
    }

    public void audit(SecurityAuditEvent event) {
        BSecurityAuditRecord rec = BSecurityAuditRecord.fromEvent(event);
        this.audit(rec);
    }

    public void stopped() {
        this.stopAudit();
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BAuditHistoryService.TYPE)) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    @Override
    protected Optional<BCategoryMask> getHistoryCategoryMask(HistoryDatabaseConnection conn, BIHistory history) {
        BAuditHistoryService auditHistoryService;
        BHistoryId auditHistoryId;
        BIHistory auditHistory;
        BComplex parent = this.getParent();
        Property propertyInParent = this.getPropertyInParent();
        int flags = this.getParent().getFlags((Slot)propertyInParent);
        if ((flags & 0x10000000) != 0) {
            return Optional.empty();
        }
        Optional<BCategoryMask> result = Optional.empty();
        if (parent instanceof BAuditHistoryService && (auditHistory = conn.getHistory(auditHistoryId = (auditHistoryService = (BAuditHistoryService)parent).getHistoryConfig().getId())) != null) {
            BCategoryService categoryService = (BCategoryService)Sys.getService((Type)BCategoryService.TYPE);
            BOrd historyOrd = HistoryCategoryUtil.convertToShorthand((BOrd)auditHistory.getOrdInSession(), (String)Sys.getStation().getStationName());
            BCategoryMask mask = categoryService.getOrdMap().getCategoryMask(historyOrd);
            result = Optional.ofNullable(mask);
        }
        parent.setFlags((Slot)propertyInParent, flags | 0x10000000);
        return result;
    }
}

