/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BFacets;

public class ColumnSpec {
    public final String name;
    public final String displayName;
    public final BFacets facets;

    public ColumnSpec(String name, String displayName, BFacets facets) {
        this.name = name;
        this.displayName = displayName;
        this.facets = facets == null ? BFacets.NULL : facets;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.displayName);
        if (this.facets.isNull()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.facets.encodeToString());
        }
    }

    public static ColumnSpec read(DataInput in) throws IOException {
        String name = in.readUTF();
        String displayName = in.readUTF();
        boolean hasFacets = in.readBoolean();
        BFacets facets = null;
        if (hasFacets) {
            facets = (BFacets)BFacets.DEFAULT.decodeFromString(in.readUTF());
        }
        return new ColumnSpec(name, displayName, facets);
    }
}

