/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.collection.ColumnUtil;
import com.tridium.fox.session.FoxSession;
import com.tridium.history.HistoryBqlRow;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.db.BSystemTable;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.session.SessionManager;
import javax.baja.collection.AbstractTableCursor;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.security.BPermissions;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType
public class BSysHistories
extends BSystemTable<BHistoryConfig> {
    @Generated
    public static final Type TYPE = Sys.loadType(BSysHistories.class);
    private final BHistoryDatabase db;
    private final Context cx;
    private final IFilter filter;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSysHistories(BHistoryDatabase db, Context cx) {
        this(db, cx, null);
    }

    public BSysHistories(BHistoryDatabase db, Context cx, IFilter filter) {
        this.db = db;
        this.cx = cx;
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BSysHistories)) {
            return false;
        }
        BSysHistories other = (BSysHistories)((Object)o);
        if (this.db != null && other.db != null) {
            return this.db == other.db;
        }
        return this == o;
    }

    public int hashCode() {
        return this.db != null ? ((Object)((Object)this.db)).hashCode() : super.hashCode();
    }

    public TableCursor<BHistoryConfig> cursor() {
        return new ConfigTableCursor(this, (Cursor<BHistoryConfig>)this.db.cursor(), this.filter);
    }

    public ColumnList getColumns() {
        return ColumnUtil.getPropertyColumns((Type)BHistoryConfig.TYPE);
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    private static class ConfigTableCursor
    extends AbstractTableCursor<BHistoryConfig> {
        private final Cursor<BHistoryConfig> inner;
        private final IFilter filter;
        private final Context cx;
        private boolean checkLegacyForHistoryMaxNameLimit;

        public ConfigTableCursor(BSysHistories table, Cursor<BHistoryConfig> inner, IFilter filter) {
            super((BITable)table);
            this.inner = inner;
            this.filter = filter;
            Context innerCx = inner.getContext();
            this.cx = table.cx == null ? innerCx : (innerCx != null && innerCx.getFacets() != null && !innerCx.getFacets().isNull() ? new BasicContext(table.cx, innerCx.getFacets()) : table.cx);
            if (this.cx != null) {
                try {
                    String foxVersion;
                    String foxSessionIdStr;
                    FoxSession session;
                    BObject foxSessionId = this.cx.getFacet("foxSessionId");
                    if (foxSessionId != null && (session = (FoxSession)SessionManager.getNiagaraSession((String)(foxSessionIdStr = foxSessionId.toString()), FoxSession.class)) != null && (foxVersion = session.getRemoteHello().getString("app.version", null)) != null) {
                        this.checkLegacyForHistoryMaxNameLimit = new Version(foxVersion).compareTo(BHistoryChannel.VER_4_12) < 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public Context getContext() {
            return this.cx;
        }

        protected boolean advanceCursor() {
            while (this.inner.next()) {
                BHistoryConfig config = (BHistoryConfig)((Object)this.inner.get());
                BPermissions p = BLocalHistoryDatabase.getPermissionsForId(((BSysHistories)this.getTable()).db, config.getId(), this.getContext());
                if (!p.hasOperatorRead() || this.filter != null && !this.filter.accept((Object)config) || !this.isHistoryNameValid(config)) continue;
                return true;
            }
            return false;
        }

        public Row<BHistoryConfig> row() {
            return new HistoryBqlRow<BValue>(this.getTable(), (BValue)this.inner.get());
        }

        protected void closeCursor() {
            this.inner.close();
        }

        private boolean isHistoryNameValid(BHistoryConfig config) {
            return !this.checkLegacyForHistoryMaxNameLimit || config.getId().getHistoryName().length() <= 44;
        }
    }
}

