/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.history.db.BHistoryDbTable;
import javax.baja.bql.BqlQuery;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Cursor;

public class TableHandle {
    private BHistoryDbTable table;
    private final Object tableLock;

    public TableHandle(BHistoryDbTable table, Object tableLock) {
        this.table = table;
        this.tableLock = tableLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBound() {
        Object object = this.tableLock;
        synchronized (object) {
            return this.table != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbind() {
        Object object = this.tableLock;
        synchronized (object) {
            this.table = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTable() throws HistoryDeletedException {
        Object object = this.tableLock;
        synchronized (object) {
            if (this.table == null) {
                throw new HistoryDeletedException();
            }
            this.table.updateLastAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryConfig getConfig() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.getConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(BHistoryConfig config) {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.setConfig(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordCount() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.getRecordCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getFirstTimestamp() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.getFirstTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getLastTimestamp() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.getLastTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BHistoryRecord getLastRecord() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.getLastRecord();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BHistoryRecord> scan(boolean descending) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.scan(descending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BHistoryRecord> timeQuery(BAbsTime startTime, BAbsTime endTime, boolean descending) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.timeQuery(startTime, endTime, descending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor<BHistoryRecord> bqlQuery(BqlQuery query) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.bqlQuery(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameHistory(String historyName) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.renameHistory(historyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(BCapacity capacity, BFullPolicy fullPolicy) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.resize(capacity, fullPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(BIHistoryRecordSet newRecords) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.append(newRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(BHistoryRecord oldRecord, BHistoryRecord newRecord) throws HistoryException {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            this.table.update(oldRecord, newRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int updateHistorySubscriptionCount(BComponent source, int change) {
        Object object = this.tableLock;
        synchronized (object) {
            this.checkTable();
            return this.table.updateHistorySubscriptionCount(source, change);
        }
    }
}

