/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.exporters;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.file.exporters.BITableToCsv;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.history.util.HistoryUtil;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.baja.collection.BITable;
import javax.baja.file.ExportOp;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BIHistory;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"history:History"})})
@NiagaraProperties(value={@NiagaraProperty(name="timeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT"), @NiagaraProperty(name="delta", type="boolean", defaultValue="false"), @NiagaraProperty(name="includeNonDefaultQueryParamsInHeader", type="boolean", defaultValue="true")})
public class BHistoryToCsv
extends BITableToCsv {
    @Generated
    public static final Property timeRange = BHistoryToCsv.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Property delta = BHistoryToCsv.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property includeNonDefaultQueryParamsInHeader = BHistoryToCsv.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryToCsv.class);
    static final LexiconText DELTA_MODE = LexiconText.make((String)"history", (String)"historyExport.deltaMode");

    @Generated
    public BDynamicTimeRange getTimeRange() {
        return (BDynamicTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BDynamicTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public boolean getDelta() {
        return this.getBoolean(delta);
    }

    @Generated
    public void setDelta(boolean v) {
        this.setBoolean(delta, v, null);
    }

    @Generated
    public boolean getIncludeNonDefaultQueryParamsInHeader() {
        return this.getBoolean(includeNonDefaultQueryParamsInHeader);
    }

    @Generated
    public void setIncludeNonDefaultQueryParamsInHeader(boolean v) {
        this.setBoolean(includeNonDefaultQueryParamsInHeader, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void export(ExportOp op) throws Exception {
        boolean defaultParams;
        op.mergeFacets(this.getFacets());
        BHistory history = (BHistory)op.get();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), StandardCharsets.UTF_8));
        if (this.getIncludeBOM()) {
            out.print("\ufeff");
            out.flush();
        }
        BDynamicTimeRange range = this.getTimeRange();
        boolean isDelta = this.getDelta();
        boolean bl = defaultParams = range.equals((Object)BDynamicTimeRange.DEFAULT) && !isDelta;
        if (this.getIncludeHeaders()) {
            out.print("history:" + history.getNavDisplayName((Context)new BasicContext((Context)op, BHistory.FULL_DISPLAY_NAME_CX.getFacets())));
            out.print(this.getLineEnding());
            if (!defaultParams && this.getIncludeNonDefaultQueryParamsInHeader()) {
                if (!range.equals((Object)BDynamicTimeRange.DEFAULT)) {
                    out.print(HistoryUtil.getRangeStr(range, (Context)op));
                    out.print(this.getLineEnding());
                }
                if (isDelta) {
                    out.print(DELTA_MODE.getText((Context)op));
                    out.print(this.getLineEnding());
                }
            }
            out.print(this.getLineEnding());
            out.flush();
        }
        if (defaultParams) {
            this.export(history, op);
        } else {
            this.export(BHistoryToCsv.getHistoryQuery(history, range, isDelta, (Context)op), op);
        }
    }

    static BITable<BHistoryRecord> getHistoryQuery(BHistory history, BDynamicTimeRange range, boolean isDelta, Context cx) {
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = range.getFixedStartTime() != null ? range.getFixedStartTime().getTimeZone() : (range.getFixedEndTime() != null ? range.getFixedEndTime().getTimeZone() : now.getTimeZone());
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        BObject historyQuery = isDelta ? new BHistoryDeltaQuery((BIHistory)history, start, end, cx) : new BHistoryTimeQuery(history, start, end, false, cx);
        return historyQuery;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 407 && HistoryToTablePdfHolder.HISTORY_TO_TABLE_PDF != null) {
            HistoryToTablePdfHolder.HISTORY_TO_TABLE_PDF.fw(407, a, b, c, d);
        }
        return super.fw(x, a, b, c, d);
    }

    static final class HistoryToTablePdfHolder {
        static final BObject HISTORY_TO_TABLE_PDF;

        private HistoryToTablePdfHolder() {
        }

        static {
            BObject historyToTablePdf;
            try {
                historyToTablePdf = Sys.getType((String)"history:HistoryToTablePdf").getInstance();
            }
            catch (Exception e) {
                historyToTablePdf = null;
            }
            HISTORY_TO_TABLE_PDF = historyToTablePdf;
        }
    }
}

