/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.exporters;

import com.tridium.history.BHistory;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.history.BHistoryConfig;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XWriter;

@NiagaraType(agent={@AgentOn(types={"history:History"})})
public class BHistoryToXml
extends BExporter {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryToXml.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BXmlFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "xml";
    }

    public void export(ExportOp op) throws Exception {
        BHistory history = (BHistory)op.get();
        PrintWriter out = new PrintWriter(new OutputStreamWriter(op.getOutputStream(), StandardCharsets.UTF_8));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        out.write("<history>\n");
        out.write("<config>\n");
        if (history != null) {
            BHistoryConfig config = history.getConfig();
            SlotCursor cursor = config.getSlots();
            while (cursor.next()) {
                Slot slot = cursor.slot();
                out.write('<' + BHistoryToXml.safe(slot.getName()) + " value=\"" + BHistoryToXml.safe(String.valueOf(config.get(slot.asProperty()))) + "\"/>\n");
            }
        }
        out.write("<columns>\n");
        ColumnList columns = history.getColumns();
        for (int c = 0; c < columns.size(); ++c) {
            if (history != null) {
                BHistoryConfig config = history.getConfig();
                out.write("<column name=\"" + BHistoryToXml.safe(columns.get(c).getName()) + "\" dispalyName=\"" + BHistoryToXml.safe(columns.get(c).getDisplayName((Context)op)) + "\" type=\"" + BHistoryToXml.safe(String.valueOf(config.getSchema().getColumnType(c))) + "\"/>\n");
                continue;
            }
            out.write("<column name=\"" + BHistoryToXml.safe(columns.get(c).getName()) + "\" dispalyName=\"" + BHistoryToXml.safe(columns.get(c).getDisplayName((Context)op)) + "\"/>\n");
        }
        out.write("</columns>\n");
        out.write("</config>\n");
        out.write("<data>\n");
        try (TableCursor cursor = history.cursor();){
            while (cursor.next()) {
                out.write("<record>\n");
                for (int c = 0; c < columns.size(); ++c) {
                    out.write('<' + BHistoryToXml.safe(columns.get(c).getName()) + " value=\"" + BHistoryToXml.safe(cursor.cell(columns.get(c)).toString()) + "\"/>\n");
                }
                out.write("</record>\n");
            }
        }
        out.write("</data>\n");
        out.write("</history>\n");
        out.flush();
        out.close();
    }

    public static String safe(String s) {
        return XWriter.safeToString((String)s, (boolean)false);
    }
}

