/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordStore;
import com.tridium.history.file.recstore.WriteBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import javax.baja.sys.BAbsTime;

public class Page {
    public static final int HEADER_SIZE = 12;
    public final RecordStore store;
    public final int index;
    private int recordCount = 0;
    private int first = -1;
    private int free = 0;
    byte[] buf;
    boolean dirty = false;
    private WriteBlock writeBlock;
    private ReadBlock readBlock;

    public Page(RecordStore store, int index, int blockSize, int pageBlocks) {
        this.store = store;
        this.index = index;
        this.buf = new byte[Page.computePageSize(blockSize, pageBlocks)];
        this.writeInt(0, this.recordCount);
        this.writeInt(4, this.first);
        this.writeInt(8, this.free);
        this.writeBlock = new WriteBlock(this, blockSize);
    }

    public Page nextPage() throws IOException {
        if (this.index == this.store.getHeader().getLastPage()) {
            return null;
        }
        int nextIndex = this.index + 1;
        if (nextIndex == this.store.getPageCount()) {
            nextIndex = 0;
        }
        return this.store.readPage(nextIndex);
    }

    public Page prevPage() throws IOException {
        if (this.index == this.store.getHeader().getFirstPage()) {
            return null;
        }
        int nextIndex = this.index - 1;
        if (nextIndex == -1) {
            nextIndex = this.store.getPageCount() - 1;
        }
        return this.store.readPage(nextIndex);
    }

    public static int computePageSize(int blockSize, int pageBlocks) {
        return pageBlocks * blockSize + 12;
    }

    public static int computeCapacity(int blockSize, int pageBlocks) {
        return pageBlocks * blockSize - pageBlocks * 8;
    }

    public int getSize() {
        return this.buf.length;
    }

    public int getHeaderSize() {
        return 12;
    }

    public int getFirst() {
        return this.first;
    }

    public int getFree() {
        return this.free;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public boolean isEmpty() {
        return this.recordCount == 0;
    }

    public void appendRecord(byte[] b) throws IOException {
        this.appendRecord(b, 0, b.length);
    }

    public synchronized void appendRecord(byte[] b, int offset, int len) throws IOException {
        int blocks = len / this.writeBlock.capacity;
        if (blocks * this.writeBlock.capacity < len) {
            ++blocks;
        }
        int blockIndex = 0;
        while (len != 0) {
            int blockBytes = len > this.writeBlock.capacity ? this.writeBlock.capacity : len;
            this.writeBlock.start(this.free, blocks, blockIndex);
            this.dirty = true;
            this.writeBlock.write(b, offset, blockBytes);
            offset += blockBytes;
            len -= blockBytes;
            ++blockIndex;
            ++this.free;
        }
        ++this.recordCount;
        if (this.first == -1) {
            this.first = 0;
        }
    }

    public synchronized void updateRecord(int startBlock, byte[] b) throws IOException {
        this.updateRecord(startBlock, b, 0, b.length);
    }

    public synchronized void updateRecord(int startBlock, byte[] b, int offset, int len) throws IOException {
        int newBlocks = len / this.writeBlock.capacity;
        if (newBlocks * this.writeBlock.capacity < len) {
            ++newBlocks;
        }
        if (this.readBlock == null) {
            this.readBlock = new ReadBlock(this.store.getBlockSize());
        }
        this.readBlock.init(this, startBlock);
        int oldBlocks = this.readBlock.getBlocksInRec();
        if (newBlocks > oldBlocks) {
            throw new IOException("Modified record requires more blocks than the original.");
        }
        int blockIndex = 0;
        while (len != 0) {
            int blockBytes = len > this.writeBlock.capacity ? this.writeBlock.capacity : len;
            this.writeBlock.start(startBlock, newBlocks, blockIndex);
            this.dirty = true;
            this.writeBlock.write(b, offset, blockBytes);
            offset += blockBytes;
            len -= blockBytes;
            ++blockIndex;
            ++startBlock;
        }
    }

    public synchronized boolean trimFromStart() throws IOException {
        if (this.recordCount == 0) {
            return false;
        }
        if (this.readBlock == null) {
            this.readBlock = new ReadBlock(this.store.getBlockSize());
        }
        this.readBlock.init(this, this.first);
        int blocksInRec = this.readBlock.getBlocksInRec();
        for (int i = this.first; i < this.first + blocksInRec; ++i) {
            this.clearBlock(i);
        }
        this.first += blocksInRec;
        --this.recordCount;
        if (this.recordCount == 0) {
            this.first = -1;
            this.free = 0;
        }
        return true;
    }

    public synchronized int clear() {
        int count = this.recordCount;
        int len = this.buf.length;
        for (int i = 0; i < len; ++i) {
            this.buf[i] = 0;
        }
        this.first = -1;
        this.free = 0;
        this.recordCount = 0;
        this.dirty = true;
        return count;
    }

    public synchronized boolean hasFree(int bytes) {
        int blockSize = this.store.getBlockSize();
        int pageBlocks = (this.buf.length - 12) / blockSize;
        int freeBlocks = pageBlocks - this.free;
        int freeBytes = freeBlocks * (blockSize - 8);
        return freeBytes >= bytes;
    }

    private void clearBlock(int blockInPage) {
        int blockSize = this.store.getBlockSize();
        for (int i = 0; i < blockSize; ++i) {
            this.buf[i] = 0;
        }
        this.dirty = true;
    }

    public synchronized boolean isDirty() {
        return this.dirty;
    }

    public synchronized void read(DataInput dataIn) throws IOException {
        dataIn.readFully(this.buf);
        this.recordCount = this.readInt(0);
        this.first = this.readInt(4);
        this.free = this.readInt(8);
        this.dirty = false;
    }

    public synchronized void write(DataOutput dataOut) throws IOException {
        this.writeInt(0, this.recordCount);
        this.writeInt(4, this.first);
        this.writeInt(8, this.free);
        dataOut.write(this.buf, 0, this.buf.length);
        this.dirty = false;
    }

    private int readInt(int offset) throws IOException {
        return ((this.buf[offset++] & 0xFF) << 24) + ((this.buf[offset++] & 0xFF) << 16) + ((this.buf[offset++] & 0xFF) << 8) + (this.buf[offset++] & 0xFF);
    }

    private void writeInt(int offset, int i) {
        this.buf[offset++] = (byte)(i >>> 24 & 0xFF);
        this.buf[offset++] = (byte)(i >>> 16 & 0xFF);
        this.buf[offset++] = (byte)(i >>> 8 & 0xFF);
        this.buf[offset++] = (byte)(i & 0xFF);
        this.dirty = true;
    }

    public String toString() {
        return "Page(" + this.index + "): records=" + this.recordCount + ", first=" + this.first + ", free=" + this.free + ", dirty=" + this.dirty;
    }

    public void dump(PrintWriter w) throws IOException {
        w.println("--- Page: " + this.index);
        w.println("recordCount: " + this.recordCount);
        w.println("first      : " + this.first);
        w.println("free       : " + this.free);
        w.println("dirty      : " + this.dirty);
        w.println("blocks:");
        ReadBlock r = new ReadBlock(this.store.getBlockSize());
        for (int i = this.first; i < this.free; ++i) {
            r.init(this, i);
            w.print(i + ") " + r.getBlocksInRec() + ":" + r.getRecBlock());
            if (r.getRecBlock() == 0) {
                w.println(" t=" + BAbsTime.DEFAULT.decode48((DataInput)r));
                continue;
            }
            w.println();
        }
    }
}

