/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Block;
import com.tridium.history.file.recstore.Page;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class ReadBlock
extends Block
implements DataInput {
    private Page page;
    private int pageBlock;
    private int blocksInRec;
    private int recBlock;
    private int start;
    private int pos;

    public ReadBlock(int size) {
        super(size);
    }

    public void init(Page page, int pageBlock) throws IOException {
        this.page = page;
        this.pageBlock = pageBlock;
        this.start = 12 + pageBlock * this.size;
        if (this.start >= page.buf.length) {
            throw new EOFException();
        }
        this.pos = this.start;
        this.blocksInRec = this.readInt();
        this.recBlock = this.readInt();
    }

    public Page getPage() {
        return this.page;
    }

    public boolean nextBlock() throws IOException {
        try {
            this.init(this.page, this.pageBlock + 1);
            return true;
        }
        catch (EOFException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getBlocksInRec() {
        return this.blocksInRec;
    }

    public int getRecBlock() {
        return this.recBlock;
    }

    public int getPageBlock() {
        return this.pageBlock;
    }

    public int read() throws IOException {
        if (this.pos == this.start + this.size) {
            if (this.recBlock + 1 == this.blocksInRec) {
                throw new EOFException();
            }
            this.init(this.page, this.pageBlock + 1);
        }
        try {
            return this.page.buf[this.pos++] & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("pos = " + this.pos + ", start+size = " + (this.start + this.size));
            throw e;
        }
    }

    public int read(byte[] rbuf) throws IOException {
        return this.read(rbuf, 0, rbuf.length);
    }

    public int read(byte[] rbuf, int roffset, int rlen) throws IOException {
        if (rlen == 0) {
            return 0;
        }
        int total = 0;
        int remainder = rlen;
        while (remainder != 0) {
            int thisRead = Math.min(remainder, this.start + this.size - this.pos);
            if (thisRead == 0) {
                if (this.recBlock + 1 == this.blocksInRec) {
                    return total == 0 ? -1 : total;
                }
                this.init(this.page, this.pageBlock + 1);
                thisRead = Math.min(remainder, this.start + this.size - this.pos);
            }
            System.arraycopy(this.page.buf, this.pos, rbuf, roffset, thisRead);
            remainder -= thisRead;
            this.pos += thisRead;
            roffset += thisRead;
            total += thisRead;
        }
        return total;
    }

    @Override
    public void readFully(byte[] rbuf) throws IOException {
        this.readFully(rbuf, 0, rbuf.length);
    }

    @Override
    public void readFully(byte[] rbuf, int roffset, int rlen) throws IOException {
        int bytes = this.read(rbuf, roffset, rlen);
        if (bytes != rlen) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.pos += n;
        if (this.pos >= this.start + this.size) {
            throw new EOFException();
        }
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.read() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return (byte)this.read();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.read();
    }

    @Override
    public short readShort() throws IOException {
        return (short)((this.read() << 8) + this.read());
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return (this.read() << 8) + this.read();
    }

    @Override
    public char readChar() throws IOException {
        return (char)((this.read() << 8) + this.read());
    }

    @Override
    public int readInt() throws IOException {
        return (this.read() << 24) + (this.read() << 16) + (this.read() << 8) + (this.read() << 0);
    }

    @Override
    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        StringBuilder str = new StringBuilder(utflen);
        int count = 0;
        block5: while (count < utflen) {
            int c = this.read();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = this.read();
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | c2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = this.read();
                    int c3 = this.read();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }
}

