/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Page;
import com.tridium.history.file.recstore.ReadBlock;
import com.tridium.history.file.recstore.RecordStore;
import java.io.DataInput;
import java.io.IOException;
import javax.baja.sys.BAbsTime;

public class RecordSpec {
    public final RecordStore store;
    public Page page;
    private int lastSetBlock = -1;
    public int block = -1;
    private ReadBlock reader;
    private int blocksInRec;
    private BAbsTime tstamp;

    public RecordSpec(RecordStore store, Page page, int block) throws IOException {
        this.store = store;
        this.set(page, block);
    }

    public RecordSpec(RecordStore store) {
        this.store = store;
    }

    public boolean set(Page page, int block) throws IOException {
        boolean changed = false;
        if (this.page != page) {
            changed = true;
        }
        this.page = page;
        if (block != this.lastSetBlock) {
            changed = true;
        }
        this.block = block;
        this.lastSetBlock = block;
        if (page != null) {
            if (this.reader == null) {
                this.reader = new ReadBlock(this.store.getBlockSize());
            }
            this.reader.init(page, block);
            if (this.reader.getRecBlock() != 0) {
                this.block -= this.reader.getRecBlock();
                this.reader.init(page, this.block);
            }
            this.blocksInRec = this.reader.getBlocksInRec();
            this.tstamp = (BAbsTime)BAbsTime.DEFAULT.decode48((DataInput)this.reader);
        } else {
            this.tstamp = null;
        }
        return changed;
    }

    public BAbsTime getTimestamp() throws IOException {
        return this.tstamp;
    }

    public int getBlocksInRec() {
        return this.blocksInRec;
    }

    public void copyFrom(RecordSpec other) {
        this.page = other.page;
        this.block = other.block;
        this.tstamp = other.tstamp;
        this.blocksInRec = other.blocksInRec;
    }

    public boolean equals(Object o) {
        RecordSpec r = (RecordSpec)o;
        return this.store == r.store && this.page == r.page && this.block == r.block;
    }

    public String toString() {
        try {
            return "page=" + this.page.index + ", block=" + this.block + ", ts=" + this.getTimestamp();
        }
        catch (Exception e) {
            return "page=" + this.page.index + ", block=" + this.block + ", ts=" + e.toString();
        }
    }
}

