/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.fox;

import com.tridium.history.BHistory;
import com.tridium.history.collection.HistoryColumns;
import com.tridium.history.fox.BFoxHistorySpace;
import javax.baja.bql.RemoteQueryable;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BFoxHistory
extends BHistory
implements RemoteQueryable {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxHistory.class);
    private BTypeSpec recType;
    private BPermissions permissions = BPermissions.all;
    private String displayName;
    private ColumnList columns;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFoxHistory(BFoxHistorySpace space, BHistoryId id, BTypeSpec recType, BPermissions permissions) {
        this(space, id, recType, permissions, null);
    }

    public BFoxHistory(BFoxHistorySpace space, BHistoryId id, BTypeSpec recType, BPermissions permissions, String displayName) {
        super(space, id);
        this.recType = recType;
        this.permissions = permissions;
        this.displayName = displayName;
    }

    private BFoxHistorySpace fox() {
        return (BFoxHistorySpace)this.getSpace();
    }

    @Override
    public BTypeSpec getRecordType() {
        if (this.recType == null) {
            this.recType = this.getConfig().getRecordType();
        }
        return this.recType;
    }

    @Override
    public void close() {
    }

    public BPermissions getPermissions(Context cx) {
        return this.permissions;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public BCategoryMask getCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public BHistoryConfig getConfig() throws HistoryException {
        return this.fox().getConfig(this.getId());
    }

    @Override
    public Cursor<BHistoryRecord> timeQueryCursor(BAbsTime startTime, BAbsTime endTime, boolean descending, Context cx) {
        try {
            return this.fox().channel().timeQuery(this.getId(), descending, startTime, endTime, cx);
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    @Override
    public int updateHistorySubscriptionCount(BComponent source, int change, Context cx) throws HistoryException {
        try {
            return this.fox().channel().updateHistorySubscriptionCount(this.getId(), source, change, cx);
        }
        catch (HistoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HistoryException(e);
        }
    }

    public BObject bqlQuery(BOrd ord) {
        return this.bqlQuery(ord, null);
    }

    public BObject bqlQuery(BOrd ord, Context cx) {
        return ((javax.baja.naming.RemoteQueryable)this.getSpace()).bqlQuery(ord, cx);
    }

    public TableCursor<BHistoryRecord> cursor() {
        try (HistorySpaceConnection conn = ((BFoxHistorySpace)this.getSpace()).getConnection(null);){
            TableCursor tableCursor = conn.timeQuery(this, null, null).cursor();
            return tableCursor;
        }
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            this.columns = HistoryColumns.getColumns(this.getConfig());
        }
        return this.columns;
    }

    public BFacets getTableFacets() {
        try (HistorySpaceConnection conn = ((BFoxHistorySpace)this.getSpace()).getConnection(null);){
            BFacets bFacets = conn.timeQuery(this, null, null).getTableFacets();
            return bFacets;
        }
    }

    public String getNavDisplayName(Context cx) {
        BObject obj;
        boolean fullName = false;
        if (cx != null && (obj = cx.getFacet("fullHistoryDisplayName")) instanceof BBoolean) {
            fullName = ((BBoolean)obj).getBoolean();
        }
        if (this.displayName == null) {
            this.displayName = SlotPath.unescape((String)this.getId().getHistoryName());
        }
        if (fullName) {
            StringBuilder sb = new StringBuilder();
            sb.append(SlotPath.unescape((String)this.getId().getDeviceName()));
            sb.append('/');
            if (!this.displayName.startsWith(sb.toString())) {
                sb.append(this.displayName);
                return sb.toString();
            }
        }
        return this.displayName;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            if (!(o instanceof BFoxHistory)) {
                return false;
            }
            BFoxHistory compare = (BFoxHistory)o;
            return this.displayName == compare.displayName || this.displayName != null && this.displayName.equals(compare.displayName);
        }
        return false;
    }
}

