/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.fox;

import com.tridium.bql.projection.BProjectionTable;
import com.tridium.bql.projection.ColumnProjectionColumn;
import com.tridium.data.BToDataTable;
import com.tridium.data.DataTableDecoder;
import com.tridium.data.DataTableEncoder;
import com.tridium.fox.message.FoxBlob;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.LocalizableExceptionTranslator;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryFolder;
import com.tridium.history.BHistoryMirror;
import com.tridium.history.RecordInputCursor;
import com.tridium.history.collection.BRecordTable;
import com.tridium.history.db.BLocalHistoryDatabase;
import com.tridium.history.fox.BFoxHistory;
import com.tridium.history.fox.BFoxHistoryDevice;
import com.tridium.history.fox.BFoxHistorySpace;
import com.tridium.history.fox.FoxHistoryException;
import com.tridium.history.fox.HistoryNameLengthException;
import com.tridium.history.io.HistoryInput;
import com.tridium.history.io.HistoryOutput;
import com.tridium.history.io.RecordInput;
import com.tridium.history.io.RecordOutput;
import com.tridium.history.util.HistoryUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.BIPollableHistorySource;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.PatternFilter;
import javax.baja.util.Queue;
import javax.baja.util.Version;

@NiagaraType
public class BHistoryChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryChannel.class);
    private static final int HISTORY_NAV_NODE = 0;
    private static final int DEVICE_NAV_NODE = 1;
    private static final int HISTORY_FOLDER_NAV_NODE = 2;
    public static final LocalizableExceptionTranslator EXCEPTION_TRANSLATOR = new LocalizableExceptionTranslator();
    private static final Version VER_4_11 = new Version("4.11");
    public static final Version VER_4_12 = new Version("4.12");
    private final HistoryChannelSubscriber historyChannelSubscriber = new HistoryChannelSubscriber(this);
    private HashMap<BInterface, HistoryUtil.HistorySourceSubscriptionCount> subscriptionCounter = new HashMap();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryChannel() {
        super("history");
    }

    public void sessionOpened() throws Exception {
        this.historyChannelSubscriber.init();
    }

    public void sessionClosed(Throwable cause) throws Exception {
        this.historyChannelSubscriber.kill();
        this.unsubscribeAllHistories();
    }

    public void checkProcess(FoxRequest req) throws Throwable {
        if (!req.command.equals("getSummary")) {
            super.checkProcess(req);
        }
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
        if (!circuit.command.equals("append")) {
            super.checkProcessCircuit(circuit);
        }
    }

    public void checkSendRequest(FoxRequest req) throws Exception {
        String command = req.command;
        if (this.getConnection().session().isLegacyConnection() && (command == "createHistory" || command == "setConfig" || command == "deleteHistories" || command == "renameHistory" || command == "clearAllRecords" || command == "clearOldRecords" || command == "postReport" || command == "setProperty" || command == "setPropertyFlags" || command == "addProperty" || command == "removeProperty" || command == "removeAllProperties" || command == "renameProperty" || command == "setPropertyFacets" || command == "reorderProperties" || command == "reorderPropertyToTop" || command == "reorderPropertyToBottom")) {
            throw new IncompatibleVersionException("Niagara4 station cannot modify history on a NiagaraAX station");
        }
        super.checkSendRequest(req);
    }

    public void checkOpenCircuit(String command, FoxMessage metadata) throws Exception {
        if (this.getConnection().session().isLegacyConnection() && (command == "append" || command == "update")) {
            throw new IncompatibleVersionException("Niagara4 station cannot modify history on a NiagaraAX station");
        }
        super.checkOpenCircuit(command, metadata);
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "deviceExists") {
            return this.deviceExists(request);
        }
        if (command == "getDevice") {
            return this.getDevice(request);
        }
        if (command == "exists") {
            return this.exists(request);
        }
        if (command == "getHistory") {
            return this.getHistory(request);
        }
        if (command == "getCategoryMasks") {
            return this.getCategoryMasks(request);
        }
        if (command == "createHistory") {
            return this.createHistory(request);
        }
        if (command == "getConfig") {
            return this.getConfig(request);
        }
        if (command == "getConfigs") {
            return this.getConfigs(request);
        }
        if (command == "setConfig") {
            return this.setConfig(request);
        }
        if (command == "getSummary") {
            return this.getSummary(request);
        }
        if (command == "deleteHistories") {
            return this.deleteHistories(request);
        }
        if (command == "renameHistory") {
            return this.renameHistory(request);
        }
        if (command == "listDevices") {
            return this.listDevices(request);
        }
        if (command == "listHistories") {
            return this.listHistories(request);
        }
        if (command == "clearAllRecords") {
            return this.clearAllRecords(request);
        }
        if (command == "clearOldRecords") {
            return this.clearOldRecords(request);
        }
        if (command == "postReport") {
            return this.postReport(request);
        }
        if (command == "getReport") {
            return this.getReport(request);
        }
        if (command == "updateSubscription") {
            return this.updateHistorySubscriptionCount(request);
        }
        if (command == "setProperty") {
            return this.setProperty(request);
        }
        if (command == "setPropertyFlags") {
            return this.setPropertyFlags(request);
        }
        if (command == "addProperty") {
            return this.addProperty(request);
        }
        if (command == "removeProperty") {
            return this.removeProperty(request);
        }
        if (command == "removeAllProperties") {
            return this.removeAllProperties(request);
        }
        if (command == "renameProperty") {
            return this.renameProperty(request);
        }
        if (command == "setPropertyFacets") {
            return this.setPropertyFacets(request);
        }
        if (command == "reorderProperties") {
            return this.reorderProperties(request);
        }
        if (command == "reorderPropertyToTop") {
            return this.reorderPropertyToTop(request);
        }
        if (command == "reorderPropertyToBottom") {
            return this.reorderPropertyToBottom(request);
        }
        if (command == "getPermissionsByOrd") {
            return this.getPermissionsByOrd(request);
        }
        if (command == "getGroupNames") {
            return this.getHistoryGroupNames(request);
        }
        if (command == "getGroupProperties") {
            return this.getSortPropertiesForGroup(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "append") {
            this.append(circuit);
            return;
        }
        if (command == "getLastRecord") {
            this.getLastRecord(circuit);
            return;
        }
        if (command == "timeQuery") {
            this.timeQuery(circuit);
            return;
        }
        if (command == "resolve") {
            this.resolve(circuit);
            return;
        }
        if (command == "update") {
            this.update(circuit);
            return;
        }
        if (command == "getFolderNavChildren") {
            this.getFolderNavChildren(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    public BHistoryDevice[] listDevices(BFoxHistorySpace space) throws Exception {
        FoxRequest req = this.makeRequest("listDevices");
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] result = resp.list("d");
        if (result == null) {
            return new BHistoryDevice[0];
        }
        BHistoryDevice[] list = new BFoxHistoryDevice[result.length];
        for (int i = 0; i < list.length; ++i) {
            FoxMessage msg = (FoxMessage)result[i];
            String devName = msg.getString("n");
            BPermissions perm = BPermissions.make((String)msg.getString("p"));
            list[i] = new BFoxHistoryDevice(space, devName, perm);
        }
        return list;
    }

    public FoxResponse listDevices(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryDevice[] devices = db.listDevices();
        FoxResponse resp = new FoxResponse(req);
        int deviceCount = devices == null ? 0 : devices.length;
        for (int i = 0; i < deviceCount; ++i) {
            BPermissions p = this.getPermissionsFor((Object)devices[i]);
            if (!p.hasOperatorRead()) continue;
            FoxMessage device = new FoxMessage("d");
            device.add("n", devices[i].getDeviceName());
            device.add("p", p.encodeToString());
            resp.add((FoxTuple)device);
        }
        return resp;
    }

    public BHistoryId[] listHistories(String devName) throws Exception {
        FoxRequest req = this.makeRequest("listHistories");
        req.add("d", devName);
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] result = resp.list("h");
        if (result == null) {
            return new BHistoryId[0];
        }
        BHistoryId[] list = new BHistoryId[result.length];
        for (int i = 0; i < list.length; ++i) {
            BHistoryId id;
            FoxMessage msg = (FoxMessage)result[i];
            list[i] = id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(msg.getString("id"));
        }
        return list;
    }

    public BIHistory[] listHistories(BFoxHistorySpace space, BHistoryDevice device) throws Exception {
        String devName = device.getDeviceName();
        FoxRequest req = this.makeRequest("listHistories");
        req.add("d", devName);
        FoxResponse resp = this.sendSync(req);
        FoxTuple[] result = resp.list("h");
        if (result == null) {
            return new BFoxHistory[0];
        }
        BIHistory[] list = new BFoxHistory[result.length];
        for (int i = 0; i < list.length; ++i) {
            FoxMessage msg = (FoxMessage)result[i];
            BHistoryId id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(msg.getString("id"));
            BTypeSpec recType = null;
            String typeSpec = msg.getString("t", null);
            if (typeSpec != null) {
                recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeSpec);
            }
            BPermissions p = BPermissions.make((String)msg.getString("p"));
            list[i] = new BFoxHistory(space, id, recType, p, msg.getString("d", null));
        }
        return list;
    }

    public FoxResponse listHistories(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        String devName = req.getString("d");
        BIHistory[] histories = db.listHistories(db.getDevice(devName));
        FoxResponse resp = new FoxResponse(req);
        int historyCount = histories == null ? 0 : histories.length;
        for (int i = 0; i < historyCount; ++i) {
            BPermissions p = this.getPermissionsFor(histories[i]);
            if (!p.hasOperatorRead() || !BHistoryChannel.isHistoryNameValid(this, histories[i].getId().getHistoryName())) continue;
            FoxMessage history = new FoxMessage("h");
            history.add("id", histories[i].getId().encodeToString());
            history.add("t", histories[i].getRecordType().encodeToString());
            history.add("p", p.encodeToString());
            try {
                BFormat displayName = BHistory.getHistoryDisplayNameFormat(histories[i]);
                if (displayName != null) {
                    history.add("d", displayName.format((Object)histories[i], this.getSessionContext()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            resp.add((FoxTuple)history);
        }
        return resp;
    }

    public boolean deviceExists(String deviceName) throws Exception {
        FoxRequest req = this.makeRequest("deviceExists");
        req.add("name", deviceName);
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("exists");
    }

    public FoxResponse deviceExists(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxResponse resp = new FoxResponse(req);
        String deviceName = req.getString("name");
        boolean result = db.deviceExists(deviceName);
        if (result) {
            BPermissions p = BLocalHistoryDatabase.getPermissionsForDevice(db, deviceName, this.getSessionContext());
            result = p.hasOperatorRead();
        }
        resp.add("exists", result);
        return resp;
    }

    public BHistoryDevice getDevice(BFoxHistorySpace space, String deviceName) throws Exception {
        FoxRequest req = this.makeRequest("getDevice");
        req.add("n", deviceName);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("e")) {
            return null;
        }
        BPermissions perm = BPermissions.make((String)resp.getString("p"));
        return new BFoxHistoryDevice(space, deviceName, perm);
    }

    public FoxResponse getDevice(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryDevice dev = db.getDevice(req.getString("n"));
        FoxResponse resp = new FoxResponse(req);
        BPermissions p = null;
        if (dev != null && !(p = this.getPermissionsFor((Object)dev)).hasOperatorRead()) {
            dev = null;
        }
        resp.add("e", dev != null);
        if (dev != null) {
            resp.add("p", p.encodeToString());
        }
        return resp;
    }

    public boolean exists(BHistoryId id) throws Exception {
        FoxRequest req = this.makeRequest("exists");
        req.add("id", id.encodeToString());
        FoxResponse resp = this.sendSync(req);
        return resp.getBoolean("exists");
    }

    public FoxResponse exists(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            FoxResponse resp = new FoxResponse(req);
            BHistoryId id = BHistoryId.make(req.getString("id"));
            boolean result = conn.exists(id);
            if (result) {
                BPermissions p = BLocalHistoryDatabase.getPermissionsForId(db, id, this.getSessionContext());
                result = p.hasOperatorRead();
            }
            resp.add("exists", result);
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public BCategoryMask[] getCategoryMasks(BFoxHistorySpace space, BOrd ord) throws Exception {
        FoxRequest req = this.makeRequest("getCategoryMasks");
        req.add("ord", ord.encodeToString());
        FoxResponse resp = this.sendSync(req);
        BCategoryMask actualMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(resp.getString("m"));
        BCategoryMask appliedMask = (BCategoryMask)BCategoryMask.DEFAULT.decodeFromString(resp.getString("a"));
        return new BCategoryMask[]{actualMask, appliedMask};
    }

    public FoxResponse getCategoryMasks(FoxRequest req) throws Exception {
        String ordString = req.getString("ord");
        BOrd ord = BOrd.make((String)("local:|" + ordString));
        FoxResponse resp = new FoxResponse(req);
        BObject target = ord.resolve().get();
        if (!(target instanceof BICategorizable)) {
            throw new BajaRuntimeException("Not categorizable: " + ordString);
        }
        BPermissions p = this.getPermissionsFor(target);
        if (!p.hasOperatorRead()) {
            throw new PermissionException();
        }
        BICategorizable c = (BICategorizable)target;
        resp.add("m", c.getCategoryMask().encodeToString());
        resp.add("a", c.getAppliedCategoryMask().encodeToString());
        return resp;
    }

    public BIHistory getHistory(BFoxHistorySpace space, BHistoryId id) throws Exception {
        FoxRequest req = this.makeRequest("getHistory");
        req.add("id", id.encodeToString());
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("e")) {
            if (resp.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(resp.getMessage("exception"));
            }
            return null;
        }
        BTypeSpec recType = null;
        String typeSpec = resp.getString("t", null);
        if (typeSpec != null) {
            recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeSpec);
        }
        BPermissions perm = BPermissions.make((String)resp.getString("p"));
        return new BFoxHistory(space, id, recType, perm, resp.getString("d", null));
    }

    public FoxResponse getHistory(FoxRequest req) throws Exception {
        FoxResponse resp;
        block17: {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            resp = new FoxResponse(req);
            BHistoryId historyId = BHistoryId.make(req.getString("id"));
            if (BHistoryChannel.requestModifiedForExceedingMaxHistoryNameLimit((FoxMessage)req, (FoxMessage)resp, historyId.getHistoryName())) {
                resp.add("e", false);
                return resp;
            }
            try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
                BIHistory h = conn.getHistory(historyId);
                BPermissions p = null;
                if (h != null && !(p = this.getPermissionsFor(h)).hasOperatorRead()) {
                    h = null;
                }
                resp.add("e", h != null);
                if (h == null) break block17;
                resp.add("t", h.getRecordType().encodeToString());
                resp.add("p", p.encodeToString());
                try {
                    BFormat displayName = BHistory.getHistoryDisplayNameFormat(h);
                    if (displayName != null) {
                        resp.add("d", displayName.format((Object)h, this.getSessionContext()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return resp;
    }

    public void createHistory(BHistoryConfig config) throws Exception {
        BHistoryChannel.checkHistoryNameForLegacyHistoryNameMaxLimit(this, config.getId().getHistoryName());
        FoxRequest req = this.makeRequest("createHistory");
        req.add("xml", ValueDocEncoder.marshal((BValue)config));
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            if (resp.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(resp.getMessage("exception"));
            }
            throw new HistoryException("Cannot create history: " + (Object)((Object)config.getId()));
        }
    }

    public FoxResponse createHistory(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxResponse resp = new FoxResponse(req);
        BHistoryConfig config = (BHistoryConfig)ValueDocDecoder.unmarshal((String)req.getString("xml"));
        if (BHistoryChannel.requestModifiedForExceedingMaxHistoryNameLimit((FoxMessage)req, (FoxMessage)resp, config.getId().getHistoryName())) {
            resp.add("success", false);
            return resp;
        }
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BPermissions p = this.getPermissionsFor((Object)db);
            if (!p.hasAdminWrite()) {
                throw new PermissionException("User does not have permission to create history " + (Object)((Object)config.getId()));
            }
            conn.createHistory(config);
            resp.add("success", conn.exists(config.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public BHistoryConfig getConfig(BHistoryId id) throws Exception {
        BHistoryChannel.checkHistoryNameForLegacyHistoryNameMaxLimit(this, id.getHistoryName());
        FoxRequest req = this.makeRequest("getConfig");
        req.add("id", id.encodeToString());
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        String xml = resp.getString("xml", null);
        if (xml == null) {
            if (resp.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(resp.getMessage("exception"));
            }
            throw new HistoryNotFoundException(id);
        }
        BHistoryConfig config = (BHistoryConfig)ValueDocDecoder.unmarshal((String)xml);
        return config;
    }

    public FoxResponse getConfig(FoxRequest req) throws Exception {
        BHistoryConfig config;
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxResponse resp = new FoxResponse(req);
        BHistoryId id = BHistoryId.make(req.getString("id"));
        if (BHistoryChannel.requestModifiedForExceedingMaxHistoryNameLimit((FoxMessage)req, (FoxMessage)resp, id.getHistoryName())) {
            return resp;
        }
        BPermissions p = BLocalHistoryDatabase.getPermissionsForId(db, id, this.getSessionContext());
        if (p.hasOperatorRead() && (config = db.getConfig(id)) != null) {
            resp.add("xml", ValueDocEncoder.marshal((BValue)config));
        }
        return resp;
    }

    public BHistoryConfig[] getConfigs(String systemTagPatterns) throws Exception {
        FoxRequest req = this.makeRequest("getConfigs");
        req.add("patternFilter", systemTagPatterns);
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        int len = resp.getInt("numConfigs", 0);
        if (len < 1) {
            return null;
        }
        BHistoryConfig[] configs = new BHistoryConfig[len];
        for (int i = 0; i < len; ++i) {
            String xml = resp.getString(("xml" + i).intern());
            configs[i] = (BHistoryConfig)ValueDocDecoder.unmarshal((String)xml);
        }
        return configs;
    }

    public FoxResponse getConfigs(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        if (!(db instanceof BLocalHistoryDatabase)) {
            throw new HistoryException("Cannot find local history database.");
        }
        FoxResponse resp = new FoxResponse(req);
        String systemTagPatterns = req.getString("patternFilter");
        BHistoryConfig[] configs = this.getConfigs(db, systemTagPatterns);
        int len = configs != null ? configs.length : 0;
        resp.add("numConfigs", len);
        for (int i = 0; i < len; ++i) {
            resp.add("xml" + i, ValueDocEncoder.marshal((BValue)configs[i]));
        }
        return resp;
    }

    private BHistoryConfig[] getConfigs(BHistoryDatabase db, String systemTagPatterns) {
        BHistoryDevice[] devices = db.listDevices();
        if (devices == null) {
            return null;
        }
        ArrayList<BHistoryConfig> configs = new ArrayList<BHistoryConfig>();
        PatternFilter[] patterns = PatternFilter.parseList((String)systemTagPatterns);
        if (patterns.length < 1) {
            return null;
        }
        for (int k = 0; k < devices.length; ++k) {
            BIHistory[] histories;
            BPermissions p = this.getPermissionsFor((Object)devices[k]);
            if (!p.hasOperatorRead() || (histories = db.listHistories(devices[k])) == null) continue;
            for (int m = 0; m < histories.length; ++m) {
                BHistoryConfig config;
                p = this.getPermissionsFor(histories[m]);
                if (!p.hasOperatorRead() || !BLocalHistoryDatabase.acceptSystemTags(config = histories[m].getConfig(), patterns) || !BHistoryChannel.isHistoryNameValid(this, config.getId().getHistoryName())) continue;
                configs.add(config);
            }
        }
        if (configs.size() < 1) {
            return null;
        }
        return configs.toArray(new BHistoryConfig[0]);
    }

    public void setConfig(BHistoryConfig config) throws Exception {
        BHistoryChannel.checkHistoryNameForLegacyHistoryNameMaxLimit(this, config.getId().getHistoryName());
        FoxRequest req = this.makeRequest("setConfig");
        req.add("xml", ValueDocEncoder.marshal((BValue)config));
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        if (resp.getOptional("exception") != null) {
            throw EXCEPTION_TRANSLATOR.messageToException(resp.getMessage("exception"));
        }
    }

    public FoxResponse setConfig(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        String xml = req.getString("xml");
        BHistoryConfig config = (BHistoryConfig)ValueDocDecoder.unmarshal((String)xml);
        BHistoryId id = config.getId();
        if (BHistoryChannel.requestModifiedForExceedingMaxHistoryNameLimit((FoxMessage)req, (FoxMessage)resp, id.getHistoryName())) {
            resp.add("e", false);
            return resp;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            if (history == null) {
                resp.add("e", false);
            } else {
                BPermissions p = this.getPermissionsFor(history);
                if (!p.hasAdminWrite()) {
                    db.setConfig(config);
                } else {
                    resp.add("e", false);
                }
            }
        }
        return resp;
    }

    public BHistorySummary getSummary(BHistoryId id) throws Exception {
        FoxRequest req = this.makeRequest("getSummary");
        req.add("id", id.encodeToString());
        FoxResponse resp = this.sendSync(req);
        boolean exists = resp.getBoolean("exists", false);
        if (!exists) {
            return null;
        }
        int recordCount = resp.getInt("recCount", 0);
        long firstTimestamp = resp.getTime("firstTs", 0L);
        long lastTimestamp = resp.getTime("lastTs", 0L);
        BHistorySummary summary = new BHistorySummary();
        summary.setId(id);
        summary.setRecordCount(recordCount);
        summary.setFirstTimestamp(BAbsTime.make((long)firstTimestamp));
        summary.setLastTimestamp(BAbsTime.make((long)lastTimestamp));
        return summary;
    }

    public FoxResponse getSummary(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxResponse resp = new FoxResponse(req);
        BHistoryId id = BHistoryId.make(req.getString("id"));
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory h = conn.getHistory(id);
            BPermissions p = this.getPermissionsFor(h);
            if (!p.hasOperatorRead()) {
                h = null;
            }
            resp.add("exists", h != null);
            if (h != null) {
                BHistorySummary summary = conn.getSummary(h);
                resp.add("recCount", summary.getRecordCount());
                resp.add("firstTs", summary.getFirstTimestamp().getMillis());
                resp.add("lastTs", summary.getLastTimestamp().getMillis());
            }
        }
        return resp;
    }

    public void deleteHistories(BOrd[] ords) throws Exception {
        FoxRequest req = this.makeRequest("deleteHistories");
        BHistoryChannel.ordsToMsg(ords, (FoxMessage)req);
        FoxResponse resp = this.sendSync(req);
        boolean success = resp.getBoolean("success");
        if (!success) {
            throw new HistoryException("Cannot Delete Histories");
        }
    }

    public FoxResponse deleteHistories(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BOrd[] ords = BHistoryChannel.msgToOrds((FoxMessage)req);
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            conn.deleteHistories(ords);
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void renameHistory(BHistoryId id, String historyName) throws Exception {
        BHistoryChannel.checkHistoryNameForLegacyHistoryNameMaxLimit(this, historyName);
        FoxRequest req = this.makeRequest("renameHistory");
        req.add("id", id.encodeToString());
        req.add("historyName", historyName);
        req.add("l", 200);
        FoxResponse resp = this.sendSync(req);
        if (resp != null && resp.getOptional("exception") != null) {
            throw EXCEPTION_TRANSLATOR.messageToException(resp.getMessage("exception"));
        }
    }

    public FoxResponse renameHistory(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        FoxResponse resp = new FoxResponse(req);
        String historyName = req.getString("historyName");
        if (BHistoryChannel.requestModifiedForExceedingMaxHistoryNameLimit((FoxMessage)req, (FoxMessage)resp, historyName)) {
            return resp;
        }
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BPermissions p;
            BIHistory history = conn.getHistory(id);
            if (history != null && !(p = this.getPermissionsFor(history)).hasAdminWrite()) {
                throw new PermissionException("User does not have permission to rename history " + (Object)((Object)id));
            }
            conn.renameHistory(id, historyName);
        }
        return null;
    }

    public BHistoryRecord getLastRecord(BHistoryId id) throws Exception {
        FoxCircuit circuit = this.openCircuit("getLastRecord");
        FoxMessage req = new FoxMessage();
        req.add("id", id.encodeToString());
        circuit.writeMessage(req);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (resp.getBoolean("empty", true)) {
            return null;
        }
        BTypeSpec recordType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(resp.getString("recType"));
        BHistoryRecord rec = (BHistoryRecord)recordType.getInstance();
        DataInputStream in = new DataInputStream(circuit.getInputStream());
        rec.read(in);
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLastRecord(FoxCircuit circuit) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        FoxMessage resp = new FoxMessage();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory h = conn.getHistory(id);
            if (h == null) {
                resp.add("empty", true);
                circuit.writeMessage(resp);
                return;
            }
            BPermissions p = this.getPermissionsFor(h);
            if (!p.hasOperatorRead()) {
                resp.add("empty", true);
                circuit.writeMessage(resp);
                return;
            }
            BHistoryRecord lastRec = conn.getLastRecord(h);
            if (lastRec == null) {
                resp.add("empty", true);
                circuit.writeMessage(resp);
                return;
            }
            resp.add("empty", false);
            resp.add("recType", lastRec.getType().getTypeSpec().encodeToString());
            circuit.writeMessage(resp);
            circuit.flush();
            try (DataOutputStream out = null;){
                out = new DataOutputStream(circuit.getOutputStream());
                lastRec.write(out);
                out.flush();
            }
        }
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, BAbsTime startTime, BAbsTime endTime) throws Exception {
        return this.timeQuery(id, false, startTime, endTime, false);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, BAbsTime startTime, BAbsTime endTime, Context cx) throws Exception {
        return this.timeQuery(id, false, startTime, endTime, false, cx);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, BAbsTime startTime, BAbsTime endTime, boolean leaseHistory) throws Exception {
        return this.timeQuery(id, false, startTime, endTime, leaseHistory);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, BAbsTime startTime, BAbsTime endTime, boolean leaseHistory, Context cx) throws Exception {
        return this.timeQuery(id, false, startTime, endTime, leaseHistory, cx);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, boolean descending, BAbsTime startTime, BAbsTime endTime) throws Exception {
        return this.timeQuery(id, descending, startTime, endTime, false);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, boolean descending, BAbsTime startTime, BAbsTime endTime, Context cx) throws Exception {
        return this.timeQuery(id, descending, startTime, endTime, false, cx);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, boolean descending, BAbsTime startTime, BAbsTime endTime, boolean leaseHistory) throws Exception {
        return this.timeQuery(id, descending, startTime, endTime, leaseHistory, null);
    }

    public Cursor<BHistoryRecord> timeQuery(BHistoryId id, boolean descending, BAbsTime startTime, BAbsTime endTime, boolean leaseHistory, Context context) throws Exception {
        FoxCircuit circuit = this.openCircuit("timeQuery");
        FoxMessage query = new FoxMessage();
        query.add("id", id.encodeToString());
        if (startTime != null && !startTime.isNull()) {
            query.add("startTime", startTime.getMillis());
        }
        if (endTime != null && !endTime.isNull()) {
            query.add("endTime", endTime.getMillis());
        }
        query.add("leaseHistory", leaseHistory);
        if (descending) {
            query.add("descending", descending);
        }
        query.add("excludeArchive", HistoryQuery.excludeArchiveData(context));
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("success", true)) {
            throw new FoxHistoryException(resp.getString("error"));
        }
        String encodedCursorCxFacets = resp.getString("cursorCxFacets", null);
        BasicContext cx = null;
        if (encodedCursorCxFacets != null) {
            cx = new BasicContext((Context)null, (BFacets)BFacets.DEFAULT.decodeFromString(encodedCursorCxFacets));
        }
        RecordInput recIn = new RecordInput(new DataInputStream(circuit.getInputStream()));
        return new RecordInputCursor(recIn, (Context)cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeQuery(FoxCircuit circuit) throws Exception {
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            FoxMessage query = circuit.readMessage();
            BHistoryId id = BHistoryId.make(query.getString("id"));
            BAbsTime startTime = null;
            BAbsTime endTime = null;
            try (HistoryDatabaseConnection conn = db.getDbConnection(this.excludeArchiveData(query), this.getSessionContext());){
                BFacets facets;
                TableCursor result;
                BIHistory h = conn.getHistory(id);
                BPermissions p = this.getPermissionsFor(h);
                if (!p.hasOperatorRead()) {
                    h = null;
                }
                FoxMessage resp = new FoxMessage();
                if (h == null) {
                    resp.add("success", false);
                    resp.add("error", "History not found: " + id.toString());
                    circuit.writeMessage(resp);
                    return;
                }
                if (query.getBoolean("leaseHistory", false) && h instanceof BHistory) {
                    BHistory hist = (BHistory)h;
                    try {
                        Context cx = this.getSessionContext();
                        hist.subscribe(this.historyChannelSubscriber, cx);
                        hist.unsubscribe(this.historyChannelSubscriber, cx);
                    }
                    catch (Exception e) {
                        BHistoryService.logger.log(Level.WARNING, "Cannot lease (subscribe/unsubscribe) history " + (Object)((Object)hist.getId()), e);
                    }
                }
                try {
                    long millis = query.getTime("startTime", -1L);
                    if (millis != -1L) {
                        startTime = BAbsTime.make((long)millis);
                    }
                    if ((millis = query.getTime("endTime", -1L)) != -1L) {
                        endTime = BAbsTime.make((long)millis);
                    }
                    result = conn.timeQuery(h, startTime, endTime, query.getBoolean("descending", false)).cursor();
                }
                catch (Exception e) {
                    resp.add("success", false);
                    resp.add("error", e.getClass().getName() + ": " + e.getMessage());
                    circuit.writeMessage(resp);
                    if (conn != null) {
                        if (var9_9 != null) {
                            try {
                                conn.close();
                            }
                            catch (Throwable throwable) {
                                var9_9.addSuppressed(throwable);
                            }
                        } else {
                            conn.close();
                        }
                    }
                    circuit.close();
                    return;
                }
                resp.add("success", true);
                Context cursorCx = result.getContext();
                if (cursorCx != null && (facets = cursorCx.getFacets()) != null) {
                    resp.add("cursorCxFacets", facets.encodeToString());
                }
                circuit.writeMessage(resp);
                circuit.flush();
                RecordOutput out = null;
                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                out = h instanceof BITable ? new RecordOutput((BITable)h, (DataOutput)dOut, this.getSessionContext()) : new RecordOutput(h.getConfig(), (DataOutput)dOut, this.getSessionContext());
                try (TableCursor cursor = result;){
                    while (cursor.next()) {
                        out.write((BObject)cursor.get());
                    }
                }
                out.flush();
                out.close();
            }
        }
        finally {
            circuit.close();
        }
    }

    public void append(BHistoryId id, BIHistoryRecordSet records) throws Exception {
        if (records == null || records.getRecordCount() < 1) {
            return;
        }
        FoxCircuit circuit = this.openCircuit("append");
        FoxMessage query = new FoxMessage();
        query.add("id", id.encodeToString());
        query.add("recType", records.getRecordTypeSpec().encodeToString());
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("continue", true)) {
            throw new FoxHistoryException(resp.getString("error"));
        }
        BHistoryRecord rec = records.getRecord(0);
        ByteBuffer buf = null;
        buf = rec.isFixedSize() ? new ByteBuffer(rec.getRecordSize() * 100) : new ByteBuffer(12800);
        DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
        boolean more = true;
        do {
            buf.reset();
            int recCount = 0;
            do {
                records.getRecord(recCount).write((DataOutput)buf);
            } while ((more = ++recCount < records.getRecordCount()) && recCount < 100);
            if (buf.getLength() == 0) continue;
            out.writeInt(recCount);
            buf.writeTo((OutputStream)out);
        } while (more);
        out.flush();
        out.writeInt(0);
        out.flush();
    }

    public void append(BHistoryId id, Cursor<? extends BIObject> records) throws Exception {
        if (!records.next()) {
            return;
        }
        FoxCircuit circuit = this.openCircuit("append");
        FoxMessage query = new FoxMessage();
        query.add("id", id.encodeToString());
        query.add("recType", ((BIObject)records.get()).getType().getTypeSpec().encodeToString());
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("continue", true)) {
            throw new FoxHistoryException(resp.getString("error"));
        }
        RecordOutput out = new RecordOutput(new DataOutputStream(circuit.getOutputStream()));
        do {
            out.write((BObject)((BIObject)records.get()).as(BObject.class));
        } while (records.next());
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(FoxCircuit circuit) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        BTypeSpec recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(req.getString("recType"));
        FoxMessage resp = new FoxMessage();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory h = conn.getHistory(id);
            if (h == null) {
                resp.add("continue", false);
                resp.add("error", "History not found: " + id.toString());
                circuit.writeMessage(resp);
                return;
            }
            BPermissions p = this.getPermissionsFor(h);
            if (!p.hasAdminWrite()) {
                resp.add("continue", false);
                resp.add("error", "User does not have permission to append to history " + id.toString());
                circuit.writeMessage(resp);
                return;
            }
            BHistoryConfig config = h.getConfig();
            if (!config.getRecordType().equals((Object)recType)) {
                resp.add("continue", false);
                resp.add("error", "Type mismatch: " + config.getRecordType() + " != " + recType);
                circuit.writeMessage(resp);
                return;
            }
            resp.add("continue", true);
            circuit.writeMessage(resp);
            circuit.flush();
            try (HistoryInput in = null;){
                in = new RecordInput(new DataInputStream(circuit.getInputStream()));
                if (this.getConnection() != null && this.getConnection().session() != null && this.getConnection().session().isLegacyConnection()) {
                    ((RecordInput)in).setHistoryVersion(1);
                }
                RecordInputCursor c = new RecordInputCursor((RecordInput)in, null);
                while (c.next()) {
                    BHistoryRecord r = (BHistoryRecord)c.get();
                    r.setHistoryVersion(2);
                    conn.append(h, r);
                }
            }
        }
    }

    public void update(BHistoryId id, BHistoryRecord record) throws Exception {
        if (record == null) {
            return;
        }
        FoxCircuit circuit = this.openCircuit("update");
        FoxMessage query = new FoxMessage();
        query.add("id", id.encodeToString());
        query.add("recType", record.getType().getTypeSpec().encodeToString());
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("continue", true)) {
            throw new FoxHistoryException(resp.getString("error"));
        }
        ByteBuffer buf = null;
        buf = record.isFixedSize() ? new ByteBuffer(record.getRecordSize() * 100) : new ByteBuffer(12800);
        DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
        buf.reset();
        boolean recCount = false;
        record.write((DataOutput)buf);
        if (buf.getLength() != 0) {
            buf.writeTo((OutputStream)out);
        }
        out.flush();
        out.writeInt(0);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(FoxCircuit circuit) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        BTypeSpec recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(req.getString("recType"));
        FoxMessage resp = new FoxMessage();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory h = conn.getHistory(id);
            if (h == null) {
                resp.add("continue", false);
                resp.add("error", "History not found: " + id.toString());
                circuit.writeMessage(resp);
                return;
            }
            BPermissions p = this.getPermissionsFor(h);
            if (!p.hasAdminWrite()) {
                resp.add("continue", false);
                resp.add("error", "User does not have permission to update history " + id.toString());
                circuit.writeMessage(resp);
                return;
            }
            BHistoryConfig config = h.getConfig();
            if (!config.getRecordType().equals((Object)recType)) {
                resp.add("continue", false);
                resp.add("error", "Type mismatch: " + config.getRecordType() + " != " + recType);
                circuit.writeMessage(resp);
                return;
            }
            resp.add("continue", true);
            circuit.writeMessage(resp);
            circuit.flush();
            try (DataInputStream in = new DataInputStream(circuit.getInputStream());){
                BHistoryRecord rec = config.makeRecord();
                rec.read(in);
                conn.update(h, rec);
            }
        }
    }

    public void clearAllRecords(BOrd[] ords) throws Exception {
        FoxRequest req = this.makeRequest("clearAllRecords");
        BHistoryChannel.ordsToMsg(ords, (FoxMessage)req);
        FoxResponse resp = this.sendSync(req);
    }

    public FoxResponse clearAllRecords(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BOrd[] ords = BHistoryChannel.msgToOrds((FoxMessage)req);
            conn.clearAllRecords(ords);
        }
        return null;
    }

    public void clearOldRecords(BOrd[] ords, BAbsTime before) throws Exception {
        FoxRequest req = this.makeRequest("clearOldRecords");
        BHistoryChannel.ordsToMsg(ords, (FoxMessage)req);
        req.add("before", before.encodeToString());
        FoxResponse resp = this.sendSync(req);
    }

    public FoxResponse clearOldRecords(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BOrd[] ords = BHistoryChannel.msgToOrds((FoxMessage)req);
        BAbsTime before = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(req.getString("before"));
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            conn.clearOldRecords(ords, before);
        }
        return null;
    }

    public int postReport(byte[] reportFile) throws Exception {
        FoxRequest req = this.makeRequest("postReport");
        req.add("file", reportFile);
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("id");
    }

    public FoxResponse postReport(FoxRequest req) throws Exception {
        byte[] file = req.getBlob("file");
        try {
            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BPermissions p = this.getPermissionsFor((Object)historyService.getDatabase());
            if (!p.hasOperatorRead()) {
                throw new PermissionException("User does not have read permission on the history space.");
            }
            Integer id = (Integer)historyService.fw(0, file, null, null);
            FoxResponse resp = new FoxResponse(req);
            resp.add("id", id.intValue());
            return resp;
        }
        catch (Exception e) {
            BHistoryService.logger.log(Level.SEVERE, "Cannot save report.", e);
            FoxResponse resp = new FoxResponse(req);
            resp.add("id", -1);
            return resp;
        }
    }

    public byte[] getReport(int id) throws Exception {
        FoxRequest req = this.makeRequest("getReport");
        req.add("id", id);
        FoxResponse resp = this.sendSync(req);
        FoxTuple blob = resp.getOptional("file");
        if (blob == null) {
            return null;
        }
        return ((FoxBlob)blob).data;
    }

    public FoxResponse getReport(FoxRequest req) throws Exception {
        int id = req.getInt("id");
        byte[] file = null;
        try {
            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BPermissions p = this.getPermissionsFor((Object)historyService.getDatabase());
            if (!p.hasOperatorRead()) {
                throw new PermissionException("User does not have read permission on the history space.");
            }
            file = (byte[])historyService.fw(1, id, null, null);
        }
        catch (Exception e) {
            BHistoryService.logger.log(Level.SEVERE, "Cannot load report.", e);
        }
        FoxResponse resp = new FoxResponse(req);
        if (file != null) {
            resp.add("file", file);
        }
        return resp;
    }

    public BObject resolve(BOrd ord) throws Exception {
        return this.resolve(ord, null);
    }

    public BObject resolve(BOrd ord, Context cx) throws Exception {
        FoxCircuit circuit = this.openCircuit("resolve");
        FoxMessage query = new FoxMessage();
        query.add("ord", ord.encodeToString());
        query.add("excludeArchive", HistoryQuery.excludeArchiveData(cx));
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("resolved", true)) {
            throw new UnresolvedException(ord.toString());
        }
        String resultType = resp.getString("resultType", null);
        if (resultType == null) {
            throw new UnresolvedException("resultType required");
        }
        if (resultType.equals("records")) {
            RecordInput in = new RecordInput(new DataInputStream(circuit.getInputStream()));
            return new BRecordTable(in);
        }
        if (resultType.equals("table")) {
            BIDataTable result = DataTableDecoder.decode((DataInput)new DataInputStream(circuit.getInputStream()));
            circuit.close();
            return (BObject)result;
        }
        if (resultType.equals("value")) {
            String dataValue = resp.getString("dataValue", null);
            BValue value = ValueDocDecoder.unmarshal((String)dataValue);
            return value;
        }
        throw new UnresolvedException("Unsupported result type: " + resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void resolve(FoxCircuit circuit) throws Exception {
        block37: {
            try {
                FoxMessage req = circuit.readMessage();
                String ordText = req.getString("ord", null);
                if (ordText == null) {
                    circuit.writeMessage(BHistoryChannel.unresolved());
                    circuit.flush();
                    return;
                }
                boolean excludeArchive = this.excludeArchiveData(req);
                BObject o = null;
                try {
                    BOrd ord = BOrd.make((String)("local:|" + ordText));
                    Context cx = excludeArchive ? HistoryQuery.makeExcludeArchiveDataContext(this.getSessionContext()) : this.getSessionContext();
                    o = ord.resolve(null, cx).get();
                }
                catch (SecurityException | UnresolvedException | PermissionException e) {
                    circuit.writeMessage(BHistoryChannel.unresolved());
                    circuit.flush();
                    circuit.close();
                    return;
                }
                catch (InvalidOrdBaseException e) {
                    circuit.writeMessage(BHistoryChannel.unresolved("history.invalidOrdBase", "Invalid ord base: " + e.getMessage()));
                    circuit.flush();
                    circuit.close();
                    return;
                }
                FoxMessage resp = new FoxMessage();
                resp.add("resolved", true);
                if (o instanceof BITable) {
                    BITable table = (BITable)o;
                    try (TableCursor c = table.cursor();){
                        if (c.next()) {
                            Object out;
                            if (c.get() instanceof BHistoryRecord && this.isPathsOnly(table)) {
                                resp.add("resultType", "records");
                                circuit.writeMessage(resp);
                                circuit.flush();
                                out = new RecordOutput(table, (DataOutput)new DataOutputStream(circuit.getOutputStream()), this.getSessionContext());
                                do {
                                    ((HistoryOutput)out).write((BObject)c.get());
                                } while (c.next());
                                ((HistoryOutput)out).flush();
                                ((HistoryOutput)out).close();
                            } else {
                                resp.add("resultType", "table");
                                circuit.writeMessage(resp);
                                circuit.flush();
                                out = new DataOutputStream(circuit.getOutputStream());
                                DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)table), (DataOutput)out, (Context)this.getSessionContext());
                                ((DataOutputStream)out).flush();
                                ((FilterOutputStream)out).close();
                            }
                        } else {
                            String idString;
                            BFacets tableFacets = table.getTableFacets();
                            if (tableFacets != null && (idString = tableFacets.gets("historyId", null)) != null) {
                                resp.add("resultType", "records");
                                circuit.writeMessage(resp);
                                circuit.flush();
                                BHistoryId id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(idString);
                                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                                BHistoryDatabase db = service.getDatabase();
                                BHistoryConfig config = db.getConfig(id);
                                if (config == null) {
                                    throw new BajaRuntimeException("History not found: " + (Object)((Object)id));
                                }
                                DataOutputStream dOut = new DataOutputStream(circuit.getOutputStream());
                                RecordOutput out = new RecordOutput(table, config.getRecordType().getResolvedType(), dOut, this.getSessionContext());
                                out.flush();
                                out.close();
                                return;
                            }
                            resp.add("resultType", "table");
                            circuit.writeMessage(resp);
                            circuit.flush();
                            DataOutputStream out = new DataOutputStream(circuit.getOutputStream());
                            DataTableEncoder.encode((BIDataTable)BToDataTable.toDataTable((BITable)table), (DataOutput)out, (Context)this.getSessionContext());
                            out.flush();
                            out.close();
                        }
                        break block37;
                    }
                }
                if (!(o instanceof BValue)) break block37;
                resp.add("resultType", "value");
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ValueDocEncoder encoder = new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)new ValueDocEncoder.BogEncoderPlugin((OutputStream)out), this.getSessionContext());
                try {
                    encoder.encode((BValue)o);
                    encoder.close();
                }
                catch (SecurityException | PermissionException e) {
                    circuit.writeMessage(BHistoryChannel.unresolved());
                    circuit.flush();
                    circuit.close();
                    return;
                }
                resp.add("dataValue", new String(out.toByteArray()));
                circuit.writeMessage(resp);
                circuit.flush();
                break block37;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                circuit.close();
            }
        }
    }

    private boolean isPathsOnly(BITable<?> table) {
        if (!(table instanceof BProjectionTable)) {
            return true;
        }
        Column[] cols = table.getColumns().list();
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i] instanceof ColumnProjectionColumn) continue;
            return false;
        }
        return true;
    }

    public void setProperty(BHistoryId id, String name, BValue value, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("setProperty");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        req.add("xml", ValueDocEncoder.marshal((BValue)value));
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot set property '").append(name);
            sb.append("' on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse setProperty(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        String name = req.getString("propName");
        String xml = req.getString("xml");
        BValue value = ValueDocDecoder.unmarshal((String)xml);
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.set(history.getProperty(name), value, this.getSessionContext());
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void setPropertyFlags(BHistoryId id, String name, int flags, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("setPropertyFlags");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        req.add("flags", flags);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot set flags for property '").append(name);
            sb.append("' on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse setPropertyFlags(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        String name = req.getString("propName");
        int flags = req.getInt("flags");
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.setFlags(history.getSlot(name), flags, this.getSessionContext());
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void addProperty(BHistoryId id, String name, BValue value, int flags, BFacets facets, Context cx) throws Exception {
        FoxResponse resp;
        FoxRequest req = this.makeRequest("addProperty");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        req.add("xml", ValueDocEncoder.marshal((BValue)value));
        req.add("flags", flags);
        if (facets != null) {
            req.add("facets", facets.encodeToString());
        }
        if (!(resp = this.sendSync(req)).getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot add property '").append(name);
            sb.append("' on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse addProperty(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        String name = req.getString("propName");
        String xml = req.getString("xml");
        BValue value = ValueDocDecoder.unmarshal((String)xml);
        int flags = req.getInt("flags");
        String encodedFacets = req.getString("facets", null);
        BFacets facets = encodedFacets != null ? BFacets.make((String)encodedFacets) : null;
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.add(name, value, flags, facets, this.getSessionContext());
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void removeProperty(BHistoryId id, String name, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("removeProperty");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot remove property '").append(name);
            sb.append("' from history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse removeProperty(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        String name = req.getString("propName");
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.remove(name, this.getSessionContext());
            resp.add("success", true);
        }
        catch (NoSuchSlotException nsse) {
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void removeAllProperties(BHistoryId id, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("removeAllProperties");
        req.add("id", id.encodeToString());
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot remove all properties from history: ");
            sb.append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse removeAllProperties(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.removeAll(this.getSessionContext());
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void renameProperty(BHistoryId id, String oldName, String newName, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("renameProperty");
        req.add("id", id.encodeToString());
        req.add("oldName", oldName);
        req.add("newName", newName);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot rename property '").append(oldName);
            sb.append("' on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse renameProperty(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        BHistoryId id = BHistoryId.make(req.getString("id"));
        String name = req.getString("oldName");
        String newName = req.getString("newName");
        FoxResponse resp = new FoxResponse(req);
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BIHistory history = conn.getHistory(id);
            history.rename(history.getProperty(name), newName, this.getSessionContext());
            resp.add("success", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            resp.add("success", false);
        }
        return resp;
    }

    public void setPropertyFacets(BHistoryId id, String name, BFacets facets, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("setPropertyFacets");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        req.add("facets", facets.encodeToString());
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot set facets for slot '").append(name);
            sb.append("' on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse setPropertyFacets(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BHistoryId id = BHistoryId.make(req.getString("id"));
            String name = req.getString("propName");
            BFacets facets = BFacets.make((String)req.getString("facets"));
            FoxResponse resp = new FoxResponse(req);
            try {
                BIHistory history = conn.getHistory(id);
                history.setFacets(history.getSlot(name), facets, this.getSessionContext());
                resp.add("success", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public void reorderProperties(BHistoryId id, String[] names, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("reorderProperties");
        req.add("id", id.encodeToString());
        req.add("propLen", names.length);
        for (int i = 0; i < names.length; ++i) {
            req.add("propName" + i, names[i]);
        }
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot reorder properties on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse reorderProperties(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BHistoryId id = BHistoryId.make(req.getString("id"));
            int len = req.getInt("propLen");
            FoxResponse resp = new FoxResponse(req);
            try {
                BIHistory history = conn.getHistory(id);
                Property[] props = new Property[len];
                for (int i = 0; i < len; ++i) {
                    props[i] = history.getProperty(req.getString(("propName" + i).intern()));
                }
                history.reorder(props, this.getSessionContext());
                resp.add("success", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public void reorderPropertyToTop(BHistoryId id, String name, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("reorderPropertyToTop");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot reorder property '").append(name);
            sb.append("' to top on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse reorderPropertyToTop(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BHistoryId id = BHistoryId.make(req.getString("id"));
            String name = req.getString("propName");
            FoxResponse resp = new FoxResponse(req);
            try {
                BIHistory history = conn.getHistory(id);
                history.reorderToTop(history.getProperty(name), this.getSessionContext());
                resp.add("success", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public void reorderPropertyToBottom(BHistoryId id, String name, Context cx) throws Exception {
        FoxRequest req = this.makeRequest("reorderPropertyToBottom");
        req.add("id", id.encodeToString());
        req.add("propName", name);
        FoxResponse resp = this.sendSync(req);
        if (!resp.getBoolean("success", false)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Cannot reorder property '").append(name);
            sb.append("' to bottom on history: ").append(id.toString());
            throw new HistoryException(sb.toString());
        }
    }

    private FoxResponse reorderPropertyToBottom(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BHistoryId id = BHistoryId.make(req.getString("id"));
            String name = req.getString("propName");
            FoxResponse resp = new FoxResponse(req);
            try {
                BIHistory history = conn.getHistory(id);
                history.reorderToBottom(history.getProperty(name), this.getSessionContext());
                resp.add("success", true);
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.add("success", false);
            }
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    public BPermissions getPermissionsByOrd(BOrd ord) throws Exception {
        FoxRequest req = this.makeRequest("getPermissionsByOrd");
        req.add("ord", ord.encodeToString());
        FoxResponse resp = this.sendSync(req);
        return BPermissions.make((int)resp.getInt("p"));
    }

    public FoxResponse getPermissionsByOrd(FoxRequest req) throws Exception {
        String ordString = req.getString("ord");
        BOrd ord = BOrd.make((String)("local:|" + ordString));
        FoxResponse resp = new FoxResponse(req);
        BObject target = ord.resolve().get();
        if (!(target instanceof BIProtected)) {
            throw new BajaRuntimeException("Not protected: " + ordString);
        }
        BPermissions p = ((BIProtected)target).getPermissions(this.getSessionContext());
        if (p == null) {
            p = BPermissions.none;
        }
        resp.add("p", p.getMask());
        return resp;
    }

    public BINavNode[] getFolderNavChildren(BFoxHistorySpace space, String[] folderPath, BINavNode navParent, Map<String, BINavNode> childFolders) throws Exception {
        FoxCircuit circuit = this.openCircuit("getFolderNavChildren");
        FoxMessage query = new FoxMessage();
        query.add("o", navParent.getNavOrd().relativizeToSession().encodeToString());
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("success", true)) {
            throw new FoxHistoryException(resp.getString("error"));
        }
        int len = folderPath.length;
        FoxTuple[] result = resp.list("h");
        if (result == null) {
            return new BINavNode[0];
        }
        BINavNode[] list = new BINavNode[result.length];
        for (int i = 0; i < list.length; ++i) {
            FoxMessage msg = (FoxMessage)result[i];
            switch (msg.getInt("c")) {
                case 0: {
                    BHistoryId id = (BHistoryId)BHistoryId.DEFAULT.decodeFromString(msg.getString("id"));
                    BTypeSpec recType = null;
                    String typeSpec = msg.getString("t", null);
                    if (typeSpec != null) {
                        recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeSpec);
                    }
                    BPermissions p = BPermissions.make((String)msg.getString("p"));
                    list[i] = new BHistoryMirror(new BFoxHistory(space, id, recType, p, msg.getString("d", null)), navParent);
                    break;
                }
                case 1: {
                    String devName = msg.getString("n");
                    BPermissions perm = BPermissions.make((String)msg.getString("p"));
                    list[i] = new BFoxHistoryDevice(space, devName, perm);
                    break;
                }
                case 2: {
                    String[] path = new String[len + 1];
                    for (int x = 0; x < len; ++x) {
                        path[x] = folderPath[x];
                    }
                    path[len] = msg.getString("n");
                    list[i] = new BHistoryFolder(space, path, navParent);
                }
            }
            if (list[i] == null) continue;
            childFolders.put(list[i].getNavName(), list[i]);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFolderNavChildren(FoxCircuit circuit) throws Exception {
        try {
            FoxMessage req = circuit.readMessage();
            String ordString = req.getString("o");
            BOrd ord = BOrd.make((String)("local:|" + ordString));
            BObject target = ord.resolve().get();
            FoxMessage resp = new FoxMessage();
            if (target instanceof BINavNode) {
                BINavNode[] navChildren = ((BINavNode)target).getNavChildren();
                int len = navChildren.length;
                for (int i = 0; i < len; ++i) {
                    BHistoryFolder f;
                    FoxMessage history;
                    BPermissions p;
                    if (navChildren[i] instanceof BIHistory) {
                        BIHistory h = (BIHistory)navChildren[i];
                        p = this.getPermissionsFor(h);
                        if (!p.hasOperatorRead()) continue;
                        history = new FoxMessage("h");
                        history.add("c", 0);
                        history.add("id", h.getId().encodeToString());
                        history.add("t", h.getRecordType().encodeToString());
                        history.add("p", p.encodeToString());
                        try {
                            BFormat displayName = BHistory.getHistoryDisplayNameFormat(h);
                            if (displayName != null) {
                                history.add("d", displayName.format((Object)h, this.getSessionContext()));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        resp.add((FoxTuple)history);
                        continue;
                    }
                    if (navChildren[i] instanceof BHistoryDevice) {
                        BHistoryDevice d = (BHistoryDevice)navChildren[i];
                        p = this.getPermissionsFor((Object)d);
                        if (!p.hasOperatorRead()) continue;
                        FoxMessage device = new FoxMessage("h");
                        device.add("c", 1);
                        device.add("n", d.getDeviceName());
                        device.add("p", p.encodeToString());
                        resp.add((FoxTuple)device);
                        continue;
                    }
                    if (!(navChildren[i] instanceof BHistoryFolder) || !(p = this.getPermissionsFor((Object)(f = (BHistoryFolder)navChildren[i]))).hasOperatorRead()) continue;
                    history = new FoxMessage("h");
                    history.add("c", 2);
                    history.add("n", f.getHistoryFolderName());
                    resp.add((FoxTuple)history);
                }
                resp.add("success", true);
            } else {
                resp.add("success", false);
                resp.add("error", "Not a NavNode: " + ordString);
            }
            circuit.writeMessage(resp);
        }
        finally {
            circuit.close();
        }
    }

    public String[] getHistoryGroupNames() throws Exception {
        FoxRequest req = this.makeRequest("getGroupNames");
        FoxResponse resp = this.sendSync(req);
        String[] result = resp.listStrings("n");
        if (result == null || result.length < 1) {
            return null;
        }
        return result;
    }

    public FoxResponse getHistoryGroupNames(FoxRequest req) throws Exception {
        String[] names = BHistoryService.getHistoryGroupNames(null);
        FoxResponse resp = new FoxResponse(req);
        int len = names != null ? names.length : 0;
        for (int i = 0; i < len; ++i) {
            resp.add("n", names[i]);
        }
        return resp;
    }

    public String[] getSortPropertiesForGroup(String groupName) throws Exception {
        FoxRequest req = this.makeRequest("getGroupProperties");
        req.add("g", groupName);
        FoxResponse resp = this.sendSync(req);
        String[] result = resp.listStrings("n");
        if (result == null || result.length < 1) {
            return null;
        }
        return result;
    }

    public FoxResponse getSortPropertiesForGroup(FoxRequest req) throws Exception {
        String groupName = req.getString("g");
        String[] names = BHistoryService.getSortPropertiesForGroup(null, groupName);
        FoxResponse resp = new FoxResponse(req);
        int len = names != null ? names.length : 0;
        for (int i = 0; i < len; ++i) {
            resp.add("n", names[i]);
        }
        return resp;
    }

    public int updateHistorySubscriptionCount(BHistoryId id, BComponent source, int change, Context cx) throws Exception {
        BObject obj;
        if (source == null) {
            return 0;
        }
        String ord = BHistoryChannel.toOrd(source);
        FoxRequest req = this.makeRequest("updateSubscription");
        req.add("id", id.encodeToString());
        req.add("ord", ord);
        req.add("change", change);
        boolean async = false;
        if (cx != null && (obj = cx.getFacet("asyncHistorySubscribe")) instanceof BBoolean) {
            async = ((BBoolean)obj).getBoolean();
        }
        req.add("asyncSub", async);
        if (async) {
            this.sendAsync(req);
            return -1;
        }
        FoxResponse resp = this.sendSync(req);
        return resp.getInt("count");
    }

    public FoxResponse updateHistorySubscriptionCount(FoxRequest req) throws Exception {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(this.getSessionContext());){
            BHistoryId id = BHistoryId.make(req.getString("id"));
            BHistory history = (BHistory)conn.getHistory(id);
            BComponent comp = this.fromOrd(req.getString("ord"));
            int change = req.getInt("change");
            BPermissions p = this.getPermissionsFor(history);
            boolean canRead = p.hasOperatorRead();
            if (req.getBoolean("asyncSub")) {
                if (canRead) {
                    this.historyChannelSubscriber.asyncUpdate(history, comp, change);
                }
                FoxResponse foxResponse = null;
                return foxResponse;
            }
            int count = -1;
            if (canRead) {
                count = history.updateHistorySubscriptionCount(comp, change, null);
                this.updateSubscriptionCounter((BInterface)history, comp, change);
            }
            FoxResponse resp = new FoxResponse(req);
            resp.add("count", count);
            FoxResponse foxResponse = resp;
            return foxResponse;
        }
    }

    private void updateSubscriptionCounter(BInterface src, BComponent historySource, int change) {
        HistoryUtil.updateSubscriptionCounter(src, historySource, change, this.subscriptionCounter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsubscribeAllHistories() {
        HashMap<BInterface, HistoryUtil.HistorySourceSubscriptionCount> hashMap = this.subscriptionCounter;
        synchronized (hashMap) {
            for (BInterface src : this.subscriptionCounter.keySet()) {
                try {
                    HistoryUtil.HistorySourceSubscriptionCount info = this.subscriptionCounter.get(src);
                    if (src instanceof BHistory) {
                        ((BHistory)src).updateHistorySubscriptionCount(info.getHistorySource(), -1 * info.getCount(), null);
                        continue;
                    }
                    if (!(src instanceof BIPollableHistorySource)) continue;
                    ((BIPollableHistorySource)src).updateHistorySubscriptionCount(-1 * info.getCount());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.subscriptionCounter.clear();
        }
    }

    private static void ordsToMsg(BOrd[] ords, FoxMessage msg) throws Exception {
        for (int i = 0; i < ords.length; ++i) {
            FoxMessage ordMsg = new FoxMessage("ord");
            ordMsg.add("ord", ords[i].encodeToString());
            msg.add((FoxTuple)ordMsg);
        }
    }

    private static BOrd[] msgToOrds(FoxMessage msg) throws Exception {
        FoxTuple[] msgs = msg.list("ord");
        BOrd[] ords = new BOrd[msgs.length];
        int count = 0;
        for (int i = 0; i < msgs.length; ++i) {
            FoxMessage ordMsg = (FoxMessage)msgs[i];
            try {
                BOrd ord = (BOrd)BOrd.DEFAULT.decodeFromString(ordMsg.getString("ord"));
                ords[count++] = ord;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (count != ords.length) {
            BOrd[] temp = new BOrd[count];
            System.arraycopy(ords, 0, temp, 0, count);
            ords = temp;
        }
        return ords;
    }

    private static FoxMessage unresolved() {
        return BHistoryChannel.unresolved(null, null);
    }

    private static FoxMessage unresolved(String key, String msg) {
        FoxMessage m = new FoxMessage();
        m.add("resolved", false);
        if (msg != null) {
            m.add("msg", msg);
        }
        return m;
    }

    private static final String toOrd(BComponent c) {
        String handle = (String)c.getHandle();
        if (handle == null) {
            throw new IllegalStateException(c.toDebugString());
        }
        return "h:" + handle;
    }

    private final BComponent fromOrd(String ord) {
        return (BComponent)BOrd.make((String)ord).get((BObject)this);
    }

    private boolean excludeArchiveData(FoxMessage msg) {
        Version versionOfRequestor = new Version(this.getConnection().session().getRemoteHello().getString("app.version", ""));
        return msg.getBoolean("excludeArchive", versionOfRequestor.compareTo(VER_4_11) < 0);
    }

    public static void checkHistoryNameForLegacyHistoryNameMaxLimit(BFoxChannel channel, String historyName) {
        if (!BHistoryChannel.isHistoryNameValid(channel, historyName)) {
            throw new HistoryNameLengthException(historyName.length(), 44);
        }
    }

    private static boolean isHistoryNameValid(BFoxChannel channel, String historyName) {
        if (channel.getConnection().getRemoteVersion().compareTo(VER_4_12) < 0) {
            return historyName.length() <= 44;
        }
        return historyName.length() <= 200;
    }

    public static boolean requestModifiedForExceedingMaxHistoryNameLimit(FoxMessage req, FoxMessage resp, String historyName) {
        int maxNameLimit = req.getInt("l", 44);
        int historyNameLength = historyName.length();
        if (historyNameLength > maxNameLimit) {
            resp.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new HistoryNameLengthException(historyNameLength, maxNameLimit))));
            return true;
        }
        return false;
    }

    static class HistorySubscriptionUpdate {
        BHistory history;
        BComponent historySource;
        int change;

        HistorySubscriptionUpdate(BHistory history, BComponent historySource, int change) {
            this.history = history;
            this.historySource = historySource;
            this.change = change;
        }
    }

    private static class HistoryChannelSubscriber
    extends Subscriber
    implements Runnable {
        private boolean running = false;
        private boolean isAlive = false;
        private final Queue queue = new Queue();
        private BHistoryChannel channel;

        HistoryChannelSubscriber(BHistoryChannel channel) {
            this.channel = channel;
        }

        public void event(BComponentEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init() {
            Queue queue = this.queue;
            synchronized (queue) {
                this.running = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void kill() {
            Queue queue = this.queue;
            synchronized (queue) {
                this.running = false;
                while (this.isAlive) {
                    this.queue.clear();
                    try {
                        this.queue.wait(1000L);
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void asyncUpdate(BHistory history, BComponent historySource, int change) {
            Queue queue = this.queue;
            synchronized (queue) {
                if (!this.running) {
                    return;
                }
                this.queue.enqueue((Object)new HistorySubscriptionUpdate(history, historySource, change));
                if (!this.isAlive) {
                    this.isAlive = true;
                    Thread thread = new Thread((Runnable)this, "HistoryChannelSubscriber");
                    thread.start();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                while (this.isAlive) {
                    if (!this.running) return;
                    HistorySubscriptionUpdate request = null;
                    Queue queue = this.queue;
                    synchronized (queue) {
                        request = (HistorySubscriptionUpdate)this.queue.dequeue();
                        this.isAlive = request != null;
                        if (!this.isAlive) return;
                        if (!this.running) {
                            return;
                        }
                    }
                    try {
                        request.history.updateHistorySubscriptionCount(request.historySource, request.change, null);
                        this.channel.updateSubscriptionCounter((BInterface)request.history, request.historySource, request.change);
                    }
                    catch (Throwable e) {
                        String id = null;
                        if (request.history != null) {
                            id = request.history.getId().toString();
                        } else {
                            id = "null";
                            if (request.historySource instanceof BIPollableHistorySource) {
                                BIPollableHistorySource src = (BIPollableHistorySource)request.historySource;
                                src.updateHistorySubscriptionCount(request.change);
                                this.channel.updateSubscriptionCounter(src, request.historySource, request.change);
                            }
                        }
                        BHistoryService.logger.log(Level.WARNING, "Cannot update subscription count for history " + id, e);
                    }
                }
                return;
            }
            finally {
                Queue queue = this.queue;
                synchronized (queue) {
                    this.isAlive = false;
                    this.queue.notify();
                }
            }
        }
    }
}

