/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import com.tridium.history.io.RandomAccess;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileRandomAccess
implements RandomAccess {
    private RandomAccessFile io;
    private long offset;
    private boolean closeable;

    public FileRandomAccess(File file, String mode) throws IOException {
        this(file, mode, 0L);
    }

    public FileRandomAccess(File file, String mode, long offset) throws IOException {
        this(new RandomAccessFile(file, mode), offset);
        this.closeable = true;
    }

    public FileRandomAccess(String file, String mode) throws IOException {
        this(file, mode, 0L);
    }

    public FileRandomAccess(String file, String mode, long offset) throws IOException {
        this(new RandomAccessFile(file, mode), offset);
        this.closeable = true;
    }

    public FileRandomAccess(RandomAccessFile file, long offset) {
        this.io = file;
        this.offset = offset;
        this.closeable = false;
    }

    public void close() throws IOException {
        if (this.closeable) {
            this.io.close();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        this.io.seek(pos + this.offset);
    }

    @Override
    public long pos() throws IOException {
        return this.io.getFilePointer() - this.offset;
    }

    @Override
    public long length() throws IOException {
        return this.io.length() - this.offset;
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.io.setLength(newLength + this.offset);
    }

    @Override
    public void flush() throws IOException {
        this.io.getFD().sync();
    }

    public FileDescriptor getFD() throws IOException {
        return this.io.getFD();
    }

    public int read() throws IOException {
        return this.io.read();
    }

    public int read(byte[] b) throws IOException {
        return this.io.read(b);
    }

    public int read(byte[] b, int offset, int len) throws IOException {
        return this.io.read(b, offset, len);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.io.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.io.readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.io.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.io.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.io.readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.io.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int offset, int len) throws IOException {
        this.io.readFully(b, offset, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.io.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.io.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.io.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.io.readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.io.readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.io.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.io.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.io.skipBytes(n);
    }

    @Override
    public void write(int b) throws IOException {
        this.io.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.io.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        this.io.write(b, offset, len);
    }

    @Override
    public void writeBoolean(boolean b) throws IOException {
        this.io.writeBoolean(b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.io.writeByte(b);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.io.writeBytes(s);
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.io.writeChar(c);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.io.writeChars(s);
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.io.writeDouble(d);
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.io.writeFloat(f);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.io.writeInt(i);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.io.writeLong(l);
    }

    @Override
    public void writeShort(int i) throws IOException {
        this.io.writeShort(i);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        this.io.writeUTF(s);
    }
}

