/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Type;

public abstract class HistoryOutput {
    public static final int MARKER1 = 96;
    public static final int MARKER2 = 13;
    private DataOutput out;
    private boolean headerWritten = false;
    private Type objType;

    public HistoryOutput(DataOutput out) {
        this(null, out);
    }

    public HistoryOutput(Type objType, DataOutput out) {
        this.objType = objType;
        this.out = out;
    }

    public void close() {
        try {
            if (!this.headerWritten) {
                this.writeHeader(this.objType);
            }
            this.out.writeBoolean(false);
            this.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void write(BObject o) throws IOException {
        if (!this.headerWritten) {
            this.writeHeader(o.getType());
        }
        this.out.writeBoolean(true);
        this.doWrite(this.out, o);
        this.out.writeByte(96);
        this.out.writeByte(13);
    }

    private void writeHeader(Type objType) throws IOException {
        if (this.headerWritten) {
            return;
        }
        this.objType = objType;
        if (objType == null) {
            throw new BajaRuntimeException("Object type required.");
        }
        this.out.writeUTF(objType.getTypeSpec().encodeToString());
        this.doWriteHeader(this.out);
        this.headerWritten = true;
    }

    protected void doWriteHeader(DataOutput out) throws IOException {
    }

    protected abstract void doWrite(DataOutput var1, BObject var2) throws IOException;

    public void flush() throws IOException {
        if (this.out instanceof OutputStream) {
            ((OutputStream)((Object)this.out)).flush();
        }
    }
}

