/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="endTimestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=8, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")}), @NiagaraProperty(name="count", type="int", defaultValue="0", flags=8), @NiagaraProperty(name="min", type="double", defaultValue="0d", flags=8), @NiagaraProperty(name="max", type="double", defaultValue="0d", flags=8), @NiagaraProperty(name="avg", type="double", defaultValue="0d", flags=8), @NiagaraProperty(name="sum", type="double", defaultValue="0d", flags=8)})
public class BHistoryRollupRecord
extends BHistoryRecord {
    @Generated
    public static final Property endTimestamp = BHistoryRollupRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property count = BHistoryRollupRecord.newProperty((int)8, (int)0, null);
    @Generated
    public static final Property min = BHistoryRollupRecord.newProperty((int)8, (double)0.0, null);
    @Generated
    public static final Property max = BHistoryRollupRecord.newProperty((int)8, (double)0.0, null);
    @Generated
    public static final Property avg = BHistoryRollupRecord.newProperty((int)8, (double)0.0, null);
    @Generated
    public static final Property sum = BHistoryRollupRecord.newProperty((int)8, (double)0.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryRollupRecord.class);

    @Generated
    public BAbsTime getEndTimestamp() {
        return (BAbsTime)this.get(endTimestamp);
    }

    @Generated
    public void setEndTimestamp(BAbsTime v) {
        this.set(endTimestamp, (BValue)v, null);
    }

    @Generated
    public int getCount() {
        return this.getInt(count);
    }

    @Generated
    public void setCount(int v) {
        this.setInt(count, v, null);
    }

    @Generated
    public double getMin() {
        return this.getDouble(min);
    }

    @Generated
    public void setMin(double v) {
        this.setDouble(min, v, null);
    }

    @Generated
    public double getMax() {
        return this.getDouble(max);
    }

    @Generated
    public void setMax(double v) {
        this.setDouble(max, v, null);
    }

    @Generated
    public double getAvg() {
        return this.getDouble(avg);
    }

    @Generated
    public void setAvg(double v) {
        this.setDouble(avg, v, null);
    }

    @Generated
    public double getSum() {
        return this.getDouble(sum);
    }

    @Generated
    public void setSum(double v) {
        this.setDouble(sum, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryRollupRecord() {
    }

    public BHistoryRollupRecord(BAbsTime start, BAbsTime end, int cnt, double minimum, double maximum, double average, double summation) {
        super(start);
        this.setEndTimestamp(end);
        this.setCount(cnt);
        this.setMin(minimum);
        this.setMax(maximum);
        this.setAvg(average);
        this.setSum(summation);
    }

    public BHistoryRollupRecord set(BAbsTime start, BAbsTime end, int cnt, double minimum, double maximum, double average, double summation) {
        this.setTimestamp(start);
        this.setEndTimestamp(end);
        this.setCount(cnt);
        this.setMin(minimum);
        this.setMax(maximum);
        this.setAvg(average);
        this.setSum(summation);
        return this;
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    @Override
    protected final void doRead(DataInput in) throws IOException {
        this.setEndTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(in));
        this.setCount(in.readInt());
        this.setMin(in.readFloat());
        this.setMax(in.readFloat());
        this.setAvg(in.readFloat());
        this.setSum(in.readFloat());
        BTimeZone timezone = (BTimeZone)BTimeZone.DEFAULT.decode(in);
        this.setTimestamp(BAbsTime.make((long)this.getTimestamp().getMillis(), (BTimeZone)timezone));
        this.setEndTimestamp(BAbsTime.make((long)this.getEndTimestamp().getMillis(), (BTimeZone)timezone));
    }

    @Override
    protected final void doWrite(DataOutput out) throws IOException {
        this.getEndTimestamp().encode(out);
        out.writeInt(this.getCount());
        out.writeFloat((float)this.getMin());
        out.writeFloat((float)this.getMax());
        out.writeFloat((float)this.getAvg());
        out.writeFloat((float)this.getSum());
        this.getTimestamp().getTimeZone().encode(out);
    }
}

