/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.util;

import com.tridium.history.db.BLocalHistoryDatabase;
import java.io.IOException;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.sys.Cursor;

public class HistoryReader {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: HistoryReader <station> <history id>");
            return;
        }
        HistoryReader reader = new HistoryReader();
        try {
            reader.read(BHistoryId.make(args[1]));
        }
        catch (IOException ioe) {
            System.out.println("Unable to read history:");
            ioe.getCause().printStackTrace();
        }
    }

    private HistoryReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(BHistoryId id) throws IOException {
        try (BLocalHistoryDatabase db = new BLocalHistoryDatabase((BHistoryService)null);
             HistoryDatabaseConnection conn = db.getDbConnection(null);){
            BIHistory history = conn.getHistory(id);
            try (Cursor<BHistoryRecord> c = conn.scan(history);){
                while (c.next()) {
                    BHistoryRecord rec = (BHistoryRecord)c.get();
                    System.out.println(rec);
                }
            }
        }
    }
}

