/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.bql.collection.TypeColumnList;
import com.tridium.history.BHistoryFolder;
import com.tridium.history.IdCursor;
import com.tridium.util.HistoryCategoryUtil;
import java.util.Comparator;
import javax.baja.agent.AgentList;
import javax.baja.bql.BIRelational;
import javax.baja.category.BCategoryMask;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BHistoryDevice
extends BObject
implements BISpaceNode,
BITable<BHistoryId>,
BIRelational<BIObject>,
BIProtected {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryDevice.class);
    private static final BIcon icon = BIcon.std((String)"device.png");
    private static Comparator<BIHistory> histNameComparator = new HistoryNameComparator();
    private BHistorySpace space;
    private BOrd ordInSpace;
    private String deviceName;
    private ColumnList columnList;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistoryDevice(BHistorySpace space, String deviceName) {
        this.space = space;
        this.deviceName = deviceName;
        this.ordInSpace = BOrd.make((String)("history:/" + deviceName));
    }

    public BSpace getSpace() {
        return this.space;
    }

    public BOrd getOrdInSession() {
        return this.getOrdInSpace();
    }

    public BOrd getOrdInSpace() {
        if (this.space == null) {
            return null;
        }
        return this.ordInSpace;
    }

    public boolean isPendingMove() {
        return false;
    }

    public void setPendingMove(boolean pendingMove) {
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)(this.space.getNavOrd() + "/" + this.deviceName));
    }

    public String getNavName() {
        return this.deviceName;
    }

    public String getNavDisplayName(Context cx) {
        return this.deviceName;
    }

    public BIcon getNavIcon() {
        return this.getIcon();
    }

    public String getNavDescription(Context cx) {
        return null;
    }

    public BINavNode getNavParent() {
        BHistorySpace navParent = this.space;
        String[] groupNames = BHistoryService.getHistoryGroupNames(this);
        if (groupNames != null && groupNames.length > 0) {
            navParent = this.space.getNavChild("history:///");
        }
        return navParent;
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String name) {
        BHistoryId id = BHistoryId.make(this.deviceName, name);
        try (HistorySpaceConnection conn = this.space.getConnection(null);){
            boolean exists = conn.exists(id);
            if (exists) {
                BIHistory bIHistory = conn.getHistory(id);
                return bIHistory;
            }
            BINavNode bINavNode = null;
            return bINavNode;
        }
    }

    public BINavNode resolveNavChild(String name) {
        BINavNode child = this.getNavChild(name);
        if (child == null) {
            throw new UnresolvedException("/" + this.deviceName + "/" + name);
        }
        return child;
    }

    public BINavNode[] getNavChildren() {
        Object[] histories = this.space.listHistories(this);
        SortUtil.sort((Object[])histories, (Object[])histories, histNameComparator);
        return histories;
    }

    public int getNavHashCode() {
        return this.deviceName.hashCode();
    }

    public void addNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public void removeNavChild(BINavNode child) {
        throw new UnsupportedOperationException();
    }

    public BCategoryMask getCategoryMask() {
        return HistoryCategoryUtil.getCategoryMask((BOrd)this.getOrdInSession(), (String)Sys.getStation().getStationName());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return HistoryCategoryUtil.getAppliedCategoryMask((BOrd)this.getOrdInSession(), (String)Sys.getStation().getStationName());
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor((BIProtected)this);
        }
        return BPermissions.all;
    }

    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasAdminWrite();
    }

    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    public BITable<BIObject> getRelation(String id, Context cx) {
        BOrd histOrd = BOrd.make((BOrd)this.getOrdInSpace(), (OrdQuery)new HistoryQuery(id));
        try {
            return (BITable)histOrd.get((BObject)BLocalHost.INSTANCE, cx);
        }
        catch (UnresolvedException e) {
            return null;
        }
    }

    public TableCursor<BHistoryId> cursor() {
        BIHistory[] histories = this.space.listHistories(this);
        return new BHistoryFolder.HistoryIdTableCursor(this, new IdCursor(histories, Context.NULL));
    }

    public ColumnList getColumns() {
        if (this.columnList == null) {
            this.columnList = new TypeColumnList(BHistoryId.TYPE, Context.NULL);
        }
        return this.columnList;
    }

    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.add("workbench:NavContainerView");
        agents.remove("workbench:CollectionTable");
        return agents;
    }

    public BIcon getIcon() {
        return icon;
    }

    private static class HistoryNameComparator
    implements Comparator<BIHistory> {
        private HistoryNameComparator() {
        }

        @Override
        public int compare(BIHistory h1, BIHistory h2) {
            return h1.getNavDisplayName(null).compareTo(h2.getNavDisplayName(null));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof HistoryNameComparator;
        }
    }
}

