/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.HistoryNameException;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.naming.SlotPath;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BHistoryId
extends BSimple {
    public static final BHistoryId DEFAULT;
    public static final BHistoryId NULL;
    public static final Type TYPE;
    public static final int MAX_NAME_LENGTH = 200;
    public static final int LEGACY_HISTORY_NAME_MAX_LIMIT = 44;
    private static final String DEVICE_SHORTHAND = "^";
    private static final String NIAGARA_STATION_SHORTHAND = "@";
    private String deviceName;
    private String historyName;
    private int hashCode;

    public static BHistoryId make(String deviceName, String historyName) {
        if (!(deviceName != null && deviceName.length() != 0 || historyName != null && historyName.length() != 0)) {
            return NULL;
        }
        return (BHistoryId)new BHistoryId(deviceName, historyName).intern();
    }

    public static BHistoryId make(String idText) {
        if (idText.length() == 0) {
            return NULL;
        }
        try {
            int deviceSlash = idText.indexOf(47);
            if (deviceSlash != 0) {
                if (idText.startsWith(DEVICE_SHORTHAND) || idText.startsWith(NIAGARA_STATION_SHORTHAND)) {
                    if (deviceSlash < 0) {
                        String deviceName = idText.substring(0, 1);
                        String historyName = idText.substring(1);
                        return (BHistoryId)new BHistoryId(deviceName, historyName).intern();
                    }
                    throw new SyntaxException("Invalid history id: " + idText);
                }
                throw new SyntaxException("History id must start with a /. (" + idText + ")");
            }
            int nameSlash = idText.indexOf(47, deviceSlash + 1);
            if (nameSlash == -1) {
                throw new SyntaxException("History name is required. (" + idText + ")");
            }
            if (idText.indexOf(47, nameSlash + 1) != -1) {
                throw new SyntaxException("Invalid history id: " + idText);
            }
            String deviceName = idText.substring(deviceSlash + 1, nameSlash);
            String historyName = idText.substring(nameSlash + 1);
            return (BHistoryId)new BHistoryId(deviceName, historyName).intern();
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SyntaxException((Throwable)e);
        }
    }

    private BHistoryId(String deviceName, String historyName) {
        this.deviceName = deviceName;
        this.historyName = historyName;
        this.hashCode = this.toString().hashCode();
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getHistoryName() {
        return this.historyName;
    }

    public String getHistoryDisplayName() {
        return SlotPath.unescape((String)this.historyName);
    }

    public boolean isShorthand() {
        return this.getDeviceName().equals(DEVICE_SHORTHAND);
    }

    public BHistoryId toShorthand(String deviceName) {
        if (this.isValid() && deviceName != null && deviceName.equals(this.deviceName)) {
            return BHistoryId.make(DEVICE_SHORTHAND, this.historyName);
        }
        return this;
    }

    public BHistoryId fromShorthand(String deviceName) {
        if (this.isValid() && (this.deviceName.equals(DEVICE_SHORTHAND) || this.deviceName.equals(NIAGARA_STATION_SHORTHAND))) {
            return BHistoryId.make(deviceName, this.historyName);
        }
        return this;
    }

    public void validateName() {
        BHistoryId.validateName(this.historyName);
    }

    public static void validateName(String test) {
        if (test == null) {
            throw new HistoryNameException("History name cannot be null.");
        }
        if (!SlotPath.isValidName((String)test)) {
            throw new HistoryNameException("History name contains an invalid character.");
        }
        if (test.length() > 200) {
            throw new HistoryNameException("History name exceeds maximum length. (" + test.length() + " > " + 200 + ")");
        }
    }

    public static boolean isValidName(String test) {
        try {
            BHistoryId.validateName(test);
            return true;
        }
        catch (HistoryNameException ex) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BHistoryId)) {
            return false;
        }
        BHistoryId other = (BHistoryId)((Object)o);
        return this.deviceName.equals(other.deviceName) && this.historyName.equals(other.historyName);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.deviceName);
        out.writeUTF(this.historyName);
    }

    public BObject decode(DataInput in) throws IOException {
        return new BHistoryId(in.readUTF(), in.readUTF()).intern();
    }

    public String encodeToString() {
        if (this.isNull()) {
            return "";
        }
        if (this.deviceName.equals(DEVICE_SHORTHAND) || this.deviceName.equals(NIAGARA_STATION_SHORTHAND)) {
            return this.deviceName + this.historyName;
        }
        return "/" + this.deviceName + "/" + this.historyName;
    }

    public BObject decodeFromString(String s) {
        return BHistoryId.make(s);
    }

    public boolean isNull() {
        return this.deviceName.equals("") && this.historyName.equals("");
    }

    public boolean isValid() {
        return !this.deviceName.equals("") && !this.historyName.equals("");
    }

    public static Optional<BHistoryId> getHistoryIdFromPoint(BControlPoint point) {
        SlotCursor c = point.getProperties();
        BHistoryId id = null;
        while (c.next(BHistoryExt.class)) {
            BHistoryExt ext = (BHistoryExt)c.get();
            if (!ext.getEnabled() && id != null) continue;
            BHistoryConfig config = ext.getHistoryConfig();
            BHistoryId historyId = config.getId();
            if (historyId.isShorthand()) {
                historyId = Sys.getStation() != null ? historyId.fromShorthand(Sys.getStation().getStationName()) : NULL;
            }
            id = historyId;
            if (!ext.getEnabled()) continue;
            break;
        }
        if (id != null && !id.isNull()) {
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BHistoryId("", "");
        TYPE = Sys.loadType(BHistoryId.class);
    }
}

