/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistorySchema;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="timestamp", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=8, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.TRUE)")})
public abstract class BHistoryRecord
extends BStruct
implements Externalizable,
BIHistoryRecordSet {
    @Generated
    public static final Property timestamp = BHistoryRecord.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryRecord.class);
    private static final long serialVersionUID = 647382510540763639L;
    public static final BFacets TIMESTAMP_FACETS = BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.TRUE, (String)"showMilliseconds", (BIDataValue)BBoolean.TRUE);
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    protected int version = 2;

    @Generated
    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    @Generated
    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHistoryRecord() {
    }

    protected BHistoryRecord(BAbsTime timestamp) {
        this.setTimestamp(timestamp);
    }

    public BHistorySchema getSchema() {
        BHistorySchema schema = new BHistorySchema();
        SlotCursor props = this.getProperties();
        while (props.next()) {
            Property prop = props.property();
            schema.addColumn(prop.getName(), prop.getType().getTypeSpec());
        }
        schema.getColumnCount();
        return schema;
    }

    public abstract boolean isFixedSize();

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.read(in);
    }

    public int getRecordSize() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(96);
        DataOutputStream dataOut = new DataOutputStream(bOut);
        try {
            this.write(dataOut);
            dataOut.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return bOut.size();
    }

    public final BHistoryRecord read(DataInput in) throws IOException {
        this.setTimestamp(this.version == 1 ? (BAbsTime)BAbsTime.DEFAULT.decode(in) : (BAbsTime)BAbsTime.DEFAULT.decode48(in));
        this.doRead(in);
        return this;
    }

    protected abstract void doRead(DataInput var1) throws IOException;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }

    public final BHistoryRecord write(DataOutput out) throws IOException {
        if (this.version == 1) {
            this.getTimestamp().encode(out);
        } else {
            this.getTimestamp().encode48(out);
        }
        this.doWrite(out);
        return this;
    }

    protected abstract void doWrite(DataOutput var1) throws IOException;

    public String toString(Context cx) {
        return this.getTimestamp().toString(cx);
    }

    public final String toSummary(Context cx) {
        StringBuffer s = new StringBuffer(96);
        s.append(this.getTimestamp().toString(cx));
        s.append(' ');
        this.toDataSummary(s, cx);
        return s.toString();
    }

    public final String toDataSummary(Context cx) {
        StringBuffer s = new StringBuffer(64);
        this.toDataSummary(s, cx);
        return s.toString();
    }

    public void toDataSummary(StringBuffer s, Context cx) {
        SlotCursor c = this.getProperties();
        boolean first = true;
        while (c.next()) {
            if (!first) {
                s.append(' ');
            }
            first = false;
            s.append(c.get().toString(cx));
        }
    }

    @Override
    public int getRecordCount() {
        return 1;
    }

    @Override
    public BHistoryRecord getRecord(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index + "!=0");
        }
        return this;
    }

    @Override
    public BHistoryRecord[] getRecords() {
        return new BHistoryRecord[]{this};
    }

    @Override
    public BHistoryRecord getLastRecord() {
        return this;
    }

    @Override
    public BTypeSpec getRecordTypeSpec() {
        return this.getType().getTypeSpec();
    }

    public int getHistoryVersion() {
        return this.version;
    }

    public void setHistoryVersion(int version) {
        this.version = version;
    }
}

