/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.history.BRootHistoryFolder;
import com.tridium.history.IdCursor;
import com.tridium.nav.BINavSupport;
import com.tridium.util.HistoryCategoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BICategorizable;
import javax.baja.collection.AbstractCursor;
import javax.baja.dataRecovery.BIDataRecoverySource;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIObject;
import javax.baja.sys.BIPropertySpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

@NiagaraType
public abstract class BHistorySpace
extends BSpace
implements BICategorizable,
BIProtected,
BIPropertySpace,
BIDataRecoverySource {
    @Generated
    public static final Type TYPE = Sys.loadType(BHistorySpace.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/historyService.png");
    private static BOrd ordInSession = BOrd.make((String)"history:");
    static Comparator<BHistoryDevice> devNameComparator = new DeviceNameComparator();
    Map<BInterface, Map<String, BINavNode>> folderCache;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHistorySpace() {
        super("history", LexiconText.make((String)"history", (String)"space.history"));
    }

    public boolean hasNavChildren() {
        return true;
    }

    public BINavNode getNavChild(String name) {
        BHistoryDevice node = null;
        String[] groupNames = BHistoryService.getHistoryGroupNames((BObject)this);
        if (groupNames != null && groupNames.length > 0) {
            boolean init;
            boolean bl = init = this.folderCache == null || this.folderCache.isEmpty();
            if (init) {
                this.getNavChildren();
            }
            try {
                Map<String, BINavNode> childFolders = this.folderCache.get((Object)this);
                node = childFolders.get(name);
                if (node == null && !init && this instanceof BHistoryDatabase) {
                    this.getNavChildren();
                    childFolders = this.folderCache.get((Object)this);
                    node = childFolders.get(name);
                }
            }
            catch (Exception exception) {}
        } else {
            node = this.getDevice(name);
        }
        if (node != null) {
            return node;
        }
        return super.getNavChild(name);
    }

    public BINavNode resolveNavChild(String name) {
        BINavNode child = this.getNavChild(name);
        if (child == null) {
            throw new UnresolvedException(name);
        }
        return child;
    }

    public BINavNode[] getNavChildren() {
        String[] groupNames = BHistoryService.getHistoryGroupNames((BObject)this);
        if (groupNames != null && groupNames.length > 0) {
            boolean init;
            boolean bl = init = this.folderCache == null;
            if (init) {
                this.folderCache = Collections.synchronizedMap(new HashMap());
            } else if (BINavSupport.getNavSupport() != null && BINavSupport.getNavSupport().performingRefresh((BINavNode)this)) {
                this.folderCache.clear();
            }
            Map<String, BRootHistoryFolder> childFolders = Collections.synchronizedMap(new HashMap());
            int len = groupNames.length;
            ArrayList<BRootHistoryFolder> folders = new ArrayList<BRootHistoryFolder>(len);
            for (int i = 0; i < len; ++i) {
                BRootHistoryFolder rootFolder = new BRootHistoryFolder(this, new String[]{groupNames[i]}, (BINavNode)this);
                BPermissions p = rootFolder.getPermissions(null);
                if (!p.hasOperatorRead()) continue;
                folders.add(rootFolder);
                childFolders.put(rootFolder.getNavName(), rootFolder);
            }
            BRootHistoryFolder defaultRoot = new BRootHistoryFolder(this, null, (BINavNode)this);
            boolean addDefault = defaultRoot.getPermissions(null).hasOperatorRead();
            len = folders.size();
            int resultSize = addDefault ? len + 1 : len;
            BINavNode[] result = new BINavNode[resultSize];
            for (int i = 0; i < len; ++i) {
                result[i] = (BINavNode)folders.get(i);
            }
            if (addDefault) {
                result[len] = defaultRoot;
                childFolders.put(result[len].getNavName(), (BRootHistoryFolder)result[len]);
            }
            this.folderCache.put((BInterface)this, childFolders);
            return result;
        }
        if (this.folderCache != null) {
            this.folderCache.clear();
            this.folderCache = null;
        }
        BHistoryDevice[] devs = this.listDevices();
        SortUtil.sort((Object[])devs, (Object[])devs, devNameComparator);
        return devs;
    }

    public BOrd getOrdInSession() {
        return ordInSession;
    }

    public BCategoryMask getCategoryMask() {
        return HistoryCategoryUtil.getCategoryMask((BOrd)this.getOrdInSession(), (String)Sys.getStation().getStationName());
    }

    public BCategoryMask getAppliedCategoryMask() {
        return HistoryCategoryUtil.getAppliedCategoryMask((BOrd)this.getOrdInSession(), (String)Sys.getStation().getStationName());
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor((BIProtected)this);
        }
        return BPermissions.all;
    }

    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasOperatorRead();
    }

    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().hasAdminWrite();
    }

    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    public abstract HistorySpaceConnection getConnection(Context var1);

    public final HistorySpaceConnection getConnection(boolean excludeArchiveData, Context cx) {
        Context context = excludeArchiveData ? HistoryQuery.makeExcludeArchiveDataContext(cx) : cx;
        return this.getConnection(context);
    }

    public abstract String getDeviceName();

    public Cursor<BHistoryId> getHistoryIds(BOrd ord) {
        String[] rootPath;
        String[] annotationNames;
        String[] groupNames;
        OrdQuery[] q = ord.parse();
        if (q.length != 1 || !(q[0] instanceof HistoryQuery)) {
            throw new HistoryException("Ord must contain only a history query.");
        }
        HistoryQuery hq = (HistoryQuery)q[0];
        if (hq.isHistoryQuery()) {
            return new IdCursor(hq.getHistoryId(), null);
        }
        if (hq.isDeviceQuery()) {
            BHistoryDevice dev = new BHistoryDevice(this, hq.getDeviceName());
            return new IdCursor(this.listHistories(dev), null);
        }
        if (hq.isHistoryFolderQuery() && (groupNames = BHistoryService.getHistoryGroupNames((BObject)this)) != null && groupNames.length > 0 && (annotationNames = BHistoryService.getSortPropertiesForGroup((BObject)this, (rootPath = hq.getHistoryFolderPath())[0])) != null && rootPath.length > 1) {
            ArrayList<BIHistory> histories = new ArrayList<BIHistory>();
            BHistoryDevice[] devs = this.listDevices();
            for (int i = 0; i < devs.length; ++i) {
                BIHistory[] h = this.listHistories(devs[i]);
                for (int j = 0; j < h.length; ++j) {
                    boolean match = true;
                    for (int k = 1; k < rootPath.length; ++k) {
                        BValue val = h[j].get(annotationNames[k - 1]);
                        if (val != null && val.toString().equals(rootPath[k])) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    histories.add(h[j]);
                }
            }
            return new IdCursor(histories.toArray(new BIHistory[0]), null);
        }
        throw new UnsupportedOperationException("Unrecognized history set: " + ord.toString());
    }

    public abstract BHistoryDevice[] listDevices() throws HistoryException;

    public abstract BIHistory[] listHistories(BHistoryDevice var1) throws HistoryException;

    public abstract boolean deviceExists(String var1) throws HistoryException;

    public abstract BHistoryDevice getDevice(String var1) throws HistoryException;

    public abstract BHistoryConfig getConfig(BHistoryId var1) throws HistoryException;

    public BIcon getIcon() {
        return icon;
    }

    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, Context cx) {
        return this.findObjects(objectType, baseOrd, propertyName, (Type)null, cx);
    }

    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, Type propertyType, Context cx) {
        return new ContainerCursor(this.findHistories(objectType, baseOrd, cx), propertyName, propertyType, cx);
    }

    public Cursor<? extends BIObject> findObjects(Type objectType, BOrd baseOrd, String propertyName, BValue propertyValue, Context cx) {
        return new ContainerCursor(this.findHistories(objectType, baseOrd, cx), propertyName, propertyValue, cx);
    }

    public Cursor<? extends BIObject> findDistinctValues(Type objectType, BOrd baseOrd, String propertyName, Context cx) {
        return this.findDistinctValues(objectType, baseOrd, propertyName, null, cx);
    }

    public Cursor<? extends BIObject> findDistinctValues(Type objectType, BOrd baseOrd, String propertyName, Type propertyType, Context cx) {
        return new DistinctPropertyCursor(this.findHistories(objectType, baseOrd, cx), propertyName, propertyType, cx);
    }

    public boolean addIndex(String propertyName, Context cx) {
        throw new UnsupportedOperationException();
    }

    public void removeIndex(String propertyName, Context cx) {
        throw new UnsupportedOperationException();
    }

    private BIHistory[] findHistories(Type objectType, BOrd baseOrd, Context cx) {
        ArrayList<BIHistory> matches;
        block29: {
            matches = new ArrayList<BIHistory>();
            if (baseOrd != null && !baseOrd.isNull()) {
                try (Cursor<BHistoryId> ids = this.getHistoryIds(baseOrd);
                     HistorySpaceConnection conn = this.getConnection(null);){
                    while (ids.next()) {
                        BIHistory history = conn.getHistory((BHistoryId)((Object)ids.get()));
                        if (history == null || objectType != null && !history.getRecordType().getResolvedType().is(objectType)) continue;
                        matches.add(history);
                    }
                    break block29;
                }
            }
            BHistoryDevice[] devices = this.listDevices();
            if (devices != null) {
                for (int i = 0; i < devices.length; ++i) {
                    BIHistory[] histories = this.listHistories(devices[i]);
                    for (int j = 0; j < histories.length; ++j) {
                        if (histories[j] == null || objectType != null && !histories[j].getRecordType().getResolvedType().is(objectType)) continue;
                        matches.add(histories[j]);
                    }
                }
            }
        }
        return matches.toArray(new BIHistory[0]);
    }

    public void dataRecoveryReserve() throws Exception {
    }

    public boolean dataRecoveryRestore(IDataRecoveryRecord rec) throws Exception {
        return false;
    }

    public void dataRecoveryRestoreComplete() {
    }

    public void dataRecoverySpy(SpyWriter out, Iterator<IDataRecoveryRecord> recoveryData) throws Exception {
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 9904) {
            return this.folderCache;
        }
        return super.fw(x, a, b, c, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startProps();
        out.trTitle((Object)"FolderCache", 2);
        if (this.folderCache != null) {
            Map<String, BINavNode> map = this.folderCache.get((Object)this);
            if (map != null) {
                Map<String, BINavNode> map2 = map;
                synchronized (map2) {
                    for (String nKey : map.keySet()) {
                        out.prop((Object)nKey.toString(), (Object)map.get(nKey).getNavOrd().toString());
                    }
                }
            } else {
                out.prop((Object)"History nav children not lazy loaded yet.", (Object)"");
            }
        } else {
            out.prop((Object)"FolderCache is null", (Object)"");
        }
        out.endProps();
    }

    static class DistinctPropertyCursor
    extends AbstractCursor<BValue> {
        BIHistory[] histories;
        String propertyName;
        Type propertyType;
        List<BValue> propertyValues = new ArrayList<BValue>();
        Context cx;
        BValue current;
        int idx;

        DistinctPropertyCursor(BIHistory[] histories, String propertyName, Type propertyType, Context cx) {
            this.histories = histories;
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.cx = cx;
            this.idx = -1;
        }

        public Context getContext() {
            return this.cx;
        }

        protected boolean advanceCursor() {
            return this.next(null);
        }

        public boolean next(Class<?> cls) {
            while (this.idx < this.histories.length - 1) {
                BValue val;
                ++this.idx;
                BIHistory history = this.histories[this.idx];
                if (history == null || (val = history.get(this.propertyName)) == null || cls != null && !cls.isInstance(val) || this.propertyType != null && !val.getType().is(this.propertyType) || this.propertyValues.contains(val)) continue;
                this.propertyValues.add(val);
                this.current = val;
                return true;
            }
            return false;
        }

        public BValue doGet() {
            return this.current;
        }
    }

    static class ContainerCursor
    extends AbstractCursor<BIHistory> {
        BIHistory[] histories;
        String propertyName;
        Type propertyType;
        BValue propertyValue;
        Context cx;
        int idx;

        ContainerCursor(BIHistory[] histories, String propertyName, Type propertyType, Context cx) {
            this.histories = histories;
            this.propertyName = propertyName;
            this.propertyType = propertyType;
            this.cx = cx;
            this.idx = -1;
        }

        ContainerCursor(BIHistory[] histories, String propertyName, BValue propertyValue, Context cx) {
            this(histories, propertyName, propertyValue.getType(), cx);
            this.propertyValue = propertyValue;
        }

        public Context getContext() {
            return this.cx;
        }

        protected boolean advanceCursor() {
            return this.next(null);
        }

        public boolean next(Class<?> cls) {
            while (this.idx < this.histories.length - 1) {
                BValue val;
                ++this.idx;
                BIHistory history = this.histories[this.idx];
                if (history == null || cls != null && !cls.isInstance(history) || (val = history.get(this.propertyName)) == null || this.propertyType != null && !val.getType().is(this.propertyType) || this.propertyValue != null && !val.equals((Object)this.propertyValue)) continue;
                return true;
            }
            return false;
        }

        public BIHistory doGet() {
            return this.histories[this.idx];
        }
    }

    private static class DeviceNameComparator
    implements Comparator<BHistoryDevice> {
        private DeviceNameComparator() {
        }

        @Override
        public int compare(BHistoryDevice dev1, BHistoryDevice dev2) {
            return dev1.getDeviceName().compareTo(dev2.getDeviceName());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof DeviceNameComparator;
        }
    }
}

