/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.db;

import java.util.Optional;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BArchiveHistoryProviders;
import javax.baja.history.db.BArchiveLimitNotificationBehavior;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.DEFAULT", flags=75), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="faultCause", type="String", defaultValue="BString.DEFAULT", flags=67, facets={@Facet(name="BFacets.MULTI_LINE", value="BBoolean.TRUE")}), @NiagaraProperty(name="maxArchiveResultsPerQuery", type="int", defaultValue="50000", facets={@Facet(name="BFacets.MIN", value="1")}), @NiagaraProperty(name="archiveLimitNotifications", type="BArchiveLimitNotificationBehavior", defaultValue="BArchiveLimitNotificationBehavior.notifyOncePerQueryRangePerSession")})
public abstract class BArchiveHistoryProvider
extends BComponent
implements BIRestrictedComponent {
    @Generated
    public static final Property status = BArchiveHistoryProvider.newProperty((int)75, (BValue)BStatus.DEFAULT, null);
    @Generated
    public static final Property enabled = BArchiveHistoryProvider.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property faultCause = BArchiveHistoryProvider.newProperty((int)67, (BValue)BString.DEFAULT, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property maxArchiveResultsPerQuery = BArchiveHistoryProvider.newProperty((int)0, (int)50000, (BFacets)BFacets.make((String)"min", (int)1));
    @Generated
    public static final Property archiveLimitNotifications = BArchiveHistoryProvider.newProperty((int)0, (BValue)BArchiveLimitNotificationBehavior.notifyOncePerQueryRangePerSession, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BArchiveHistoryProvider.class);
    private static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"database.png"), (BIcon)BIcon.std((String)"badges/history.png"));
    private static final Lexicon LEXICON = Lexicon.make((String)"history");
    private static final String UNLICENSED = LEXICON.getText("archiveHistoryProvider.unlicensed");
    private boolean fatalFault;
    private boolean configFault;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public int getMaxArchiveResultsPerQuery() {
        return this.getInt(maxArchiveResultsPerQuery);
    }

    @Generated
    public void setMaxArchiveResultsPerQuery(int v) {
        this.setInt(maxArchiveResultsPerQuery, v, null);
    }

    @Generated
    public BArchiveLimitNotificationBehavior getArchiveLimitNotifications() {
        return (BArchiveLimitNotificationBehavior)this.get(archiveLimitNotifications);
    }

    @Generated
    public void setArchiveLimitNotifications(BArchiveLimitNotificationBehavior v) {
        this.set(archiveLimitNotifications, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public abstract boolean isLikelyToContainArchivedHistory(BHistoryConfig var1, Context var2);

    public final Optional<Cursor<BHistoryRecord>> timeQuery(BHistoryConfig historyConfig, BAbsTime startTime, BAbsTime endTime, boolean descending, Context context) {
        if (!this.isOperational()) {
            throw new NotRunningException("A time query cannot be executed when the archive history provider is not operational.");
        }
        return this.doTimeQuery(historyConfig, startTime, endTime, descending, this.computeArchiveQueryLimit(context), context);
    }

    protected abstract Optional<Cursor<BHistoryRecord>> doTimeQuery(BHistoryConfig var1, BAbsTime var2, BAbsTime var3, boolean var4, int var5, Context var6);

    private void checkLicense() throws FeatureNotLicensedException {
        try {
            Feature historyArchiveFeature = Sys.getLicenseManager().getFeature("tridium", "historyArchive");
            if (historyArchiveFeature == null) {
                throw new FeatureNotLicensedException(UNLICENSED);
            }
            historyArchiveFeature.check();
        }
        catch (Exception e) {
            throw new FeatureNotLicensedException(UNLICENSED);
        }
        this.checkProviderLicense();
    }

    protected void checkProviderLicense() throws FeatureNotLicensedException {
    }

    public final boolean isOperational() {
        return this.isRunning() && this.getEnabled() && !this.configFault && !this.fatalFault;
    }

    protected final void updateStatus() {
        int newStatus = 0;
        if (!this.getEnabled()) {
            newStatus |= 1;
        }
        if (this.fatalFault || this.configFault) {
            newStatus |= 2;
        }
        if (this.getStatus().getBits() == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
    }

    protected final void configOk() {
        this.configFault = false;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause("");
        this.updateStatus();
    }

    protected final void configFail(String cause) {
        this.configFault = true;
        if (this.fatalFault) {
            return;
        }
        this.setFaultCause(cause);
        this.updateStatus();
    }

    protected final void configFatal(String cause) {
        this.fatalFault = true;
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public final int computeArchiveQueryLimit(Context context) {
        int maxLimit = this.getMaxArchiveResultsPerQuery();
        int limit = HistoryQuery.getArchiveQueryLimit(context, maxLimit);
        if (limit < 1) {
            limit = ((BInteger)maxArchiveResultsPerQuery.getDefaultValue().as(BInteger.class)).getInt();
        } else if (limit > maxLimit) {
            limit = maxLimit;
        }
        return limit;
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context context) {
        if (!(parent instanceof BArchiveHistoryProviders)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        } else if (this.isRunning() && x == 2) {
            BComplex parent;
            if (enabled.equals(a)) {
                this.updateStatus();
            } else if (status.equals(a) && (parent = this.getParent()) != null) {
                parent.fw(x, (Object)this.getPropertyInParent(), b, c, d);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        try {
            this.checkLicense();
            this.updateStatus();
        }
        catch (Exception e) {
            this.configFatal(e.getMessage());
        }
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return ICON;
    }
}

