/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.db;

import com.tridium.history.HistoryConfigChange;
import com.tridium.history.HistoryConfigChanges;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BCapacity;
import javax.baja.history.BFullPolicy;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySummary;
import javax.baja.history.BIHistory;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Cursor;

public abstract class HistoryDatabaseConnection
implements HistorySpaceConnection {
    public static Logger log = Logger.getLogger("history.db");
    static final Logger eventLogger = Logger.getLogger("history.event");

    @Override
    public BHistorySummary getSummary(BIHistory history) {
        BHistorySummary summary = new BHistorySummary();
        summary.setId(history.getId());
        summary.setRecordCount(this.getRecordCount(history));
        summary.setFirstTimestamp(this.getFirstTimestamp(history));
        summary.setLastTimestamp(this.getLastTimestamp(history));
        return summary;
    }

    public abstract BHistoryDatabase getHistoryDatabase();

    @Override
    public final void deleteHistory(BHistoryId id) {
        this.doDeleteHistory(id);
    }

    public abstract void doDeleteHistory(BHistoryId var1);

    @Override
    public void deleteHistories(BOrd[] ords) {
        for (BOrd ord : ords) {
            try (Cursor<BHistoryId> idCursor = this.getHistoryDatabase().getHistoryIds(ord);){
                while (idCursor.next()) {
                    this.deleteHistory((BHistoryId)((Object)idCursor.get()));
                }
            }
        }
    }

    @Override
    public final void renameHistory(BHistoryId id, String historyName) {
        this.doRenameHistory(id, historyName);
        if (this.getHistoryDatabase().hasHistoryEventListeners()) {
            this.getHistoryDatabase().fireHistoryEvent(BHistoryEvent.makeRenamed(id, historyName));
        }
        BOrd parentOrd = BOrd.make((String)("local:|history:/" + id.getDeviceName()));
        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed((BOrd)parentOrd, (String)id.getHistoryName(), (String)historyName, null));
    }

    public abstract void doRenameHistory(BHistoryId var1, String var2);

    @Override
    public abstract void clearAllRecords(BHistoryId var1);

    @Override
    public void clearAllRecords(BOrd[] ords) {
        for (int i = 0; i < ords.length; ++i) {
            try (Cursor<BHistoryId> idCursor = this.getHistoryDatabase().getHistoryIds(ords[i]);){
                while (idCursor.next()) {
                    BHistoryId id = (BHistoryId)((Object)idCursor.get());
                    this.clearAllRecords(id);
                }
                continue;
            }
        }
    }

    @Override
    public abstract void clearOldRecords(BHistoryId var1, BAbsTime var2);

    @Override
    public void clearOldRecords(BOrd[] ords, BAbsTime before) throws HistoryException {
        for (int i = 0; i < ords.length; ++i) {
            try (Cursor<BHistoryId> idCursor = this.getHistoryDatabase().getHistoryIds(ords[i]);){
                while (idCursor.next()) {
                    BHistoryId id = (BHistoryId)((Object)idCursor.get());
                    this.clearOldRecords(id, before);
                }
                continue;
            }
        }
    }

    @Override
    public final void createHistory(BHistoryConfig config) throws HistoryException {
        BOrd parentOrd;
        this.getHistoryDatabase().checkOpen();
        if (this.exists(config.getId())) {
            throw new DuplicateHistoryException(config.getId());
        }
        boolean deviceExists = this.getHistoryDatabase().deviceExists(config.getId().getDeviceName());
        this.doCreateHistory(config);
        if (this.getHistoryDatabase().hasHistoryEventListeners()) {
            this.getHistoryDatabase().fireHistoryEvent(BHistoryEvent.makeCreated(config.getId(), config));
        }
        if (!deviceExists) {
            parentOrd = BOrd.make((String)"local:|history:");
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)parentOrd, (String)config.getId().getDeviceName(), null));
        }
        parentOrd = BOrd.make((String)("local:|history:/" + config.getId().getDeviceName()));
        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)parentOrd, (String)config.getId().getHistoryName(), null));
    }

    protected abstract void doCreateHistory(BHistoryConfig var1);

    public abstract void recreateHistory(BHistoryConfig var1, boolean var2);

    public abstract void resizeHistory(BHistoryId var1, BCapacity var2, BFullPolicy var3);

    public void reconfigureHistory(BHistoryConfig newConfig) {
        if (!this.getHistoryDatabase().isOpen()) {
            return;
        }
        BHistoryId id = newConfig.getId();
        BHistoryConfig oldConfig = this.getHistoryDatabase().getConfig(id);
        if (oldConfig == null) {
            return;
        }
        HistoryConfigChanges changes = HistoryConfigChanges.compare(oldConfig, newConfig);
        if (changes.getChangeCount() == 0) {
            return;
        }
        BHistoryConfig newConfigCopy = (BHistoryConfig)newConfig.newCopy(true);
        if (!newConfig.isMounted()) {
            HistoryConfigChanges.addMissingMetadata(oldConfig, newConfigCopy, changes);
        }
        HistoryConfigChange change = changes.get("recordType");
        BIHistory hist = null;
        if (change != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)id) + ": recordType changed, recreating history");
            }
            if ((hist = this.getHistory(id)) != null && this.getRecordCount(hist) != 0) {
                this.recreateHistory(newConfigCopy, true);
                return;
            }
        }
        if ((change = changes.get("interval")) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)id) + ": interval changed, recreating history");
            }
            if (hist == null) {
                hist = this.getHistory(id);
            }
            if (hist != null && this.getRecordCount(hist) != 0) {
                this.recreateHistory(newConfigCopy, true);
                return;
            }
        }
        if ((change = changes.get("capacity")) != null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)id) + ": capacity changed, resizing history");
            }
            this.resizeHistory(id, newConfigCopy.getCapacity(), newConfigCopy.getFullPolicy());
        }
        this.getHistoryDatabase().setConfig(newConfigCopy);
    }

    @Override
    public final void close() {
        if (!this.getHistoryDatabase().isOpen()) {
            return;
        }
        this.doClose();
    }

    protected abstract void doClose();
}

