/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import java.io.IOException;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BCovHistoryExt
extends BHistoryExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BCovHistoryExt.class);
    private BStatusValue lastValue;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void activated(BAbsTime startTime, BAbsTime currentTime, BStatusValue value) throws IOException {
        if (this.lastValue == null) {
            this.lastValue = (BStatusValue)value.newCopy(true);
        } else {
            this.lastValue.copyFrom((BComplex)value);
        }
        this.writeRecord(currentTime, value);
    }

    @Override
    public void deactivated(BAbsTime currentTime, BStatusValue value) throws IOException {
        if (this.lastValue == null) {
            this.lastValue = (BStatusValue)value.newCopy(true);
        } else {
            this.lastValue.copyFrom((BComplex)value);
        }
        this.writeRecord(currentTime, value);
    }

    @Override
    public final void pointChanged(BAbsTime timestamp, BStatusValue out) throws IOException {
        if (this.lastValue == null) {
            this.lastValue = (BStatusValue)out.newCopy(true);
            this.writeRecord(timestamp, out);
        } else if (this.isChange(this.lastValue, out)) {
            this.lastValue.copyFrom((BComplex)out);
            this.writeRecord(timestamp, out);
        }
    }

    protected abstract void writeRecord(BAbsTime var1, BStatusValue var2) throws IOException;

    protected boolean isChange(BStatusValue oldValue, BStatusValue newValue) {
        return !oldValue.equivalent((Object)newValue);
    }
}

