/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm;

import com.tridium.alarm.AlarmUtil;
import com.tridium.alarm.AlarmsToSourcesCursor;
import com.tridium.bql.util.BDynamicTimeRange;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmRecipient;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSource;
import javax.baja.alarm.BAlarmTransitionBits;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="faultCause", type="BString", defaultValue="BString.DEFAULT", flags=67), @NiagaraProperty(name="transitions", type="BAlarmTransitionBits", defaultValue="BAlarmTransitionBits.ALL", facets={@Facet(value="BFacets.make(\"showNormal\", BBoolean.FALSE)")}, override=true), @NiagaraProperty(name="routeAcks", type="boolean", defaultValue="true", flags=1, override=true), @NiagaraProperty(name="defaultTimeRange", type="BDynamicTimeRange", defaultValue="BDynamicTimeRange.DEFAULT")})
public class BConsoleRecipient
extends BAlarmRecipient {
    @Generated
    public static final Property status = BConsoleRecipient.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BConsoleRecipient.newProperty((int)67, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property transitions = BConsoleRecipient.newProperty((int)0, (BValue)BAlarmTransitionBits.ALL, (BFacets)BFacets.make((String)"showNormal", (BIDataValue)BBoolean.FALSE));
    @Generated
    public static final Property routeAcks = BConsoleRecipient.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property defaultTimeRange = BConsoleRecipient.newProperty((int)0, (BValue)BDynamicTimeRange.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConsoleRecipient.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"computer.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    public static final Logger logger = Logger.getLogger("alarm");
    private int oldStatus = 0;
    private boolean fatalFault;
    private Set<BiConsumer<BConsoleRecipient, BAlarmRecord>> alarmHandlers;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BDynamicTimeRange getDefaultTimeRange() {
        return (BDynamicTimeRange)this.get(defaultTimeRange);
    }

    @Generated
    public void setDefaultTimeRange(BDynamicTimeRange v) {
        this.set(defaultTimeRange, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.alarmHandlers = new CopyOnWriteArraySet<BiConsumer<BConsoleRecipient, BAlarmRecord>>();
        try {
            BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            String consoleLimitFault = (String)service.fw(501, "console.limit", null, null, null);
            if (consoleLimitFault != null) {
                this.fatalFault = true;
                this.setFaultCause(consoleLimitFault);
                this.updateStatus(service);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public final void updateStatus(BAlarmService service) {
        int newStatus = this.getStatus().getBits();
        newStatus = this.fatalFault || service.isFault() ? (newStatus |= 2) : (newStatus &= 0xFFFFFFFD);
        if (this.oldStatus == newStatus) {
            return;
        }
        this.setStatus(BStatus.make((int)newStatus));
        this.oldStatus = newStatus;
    }

    public final boolean isOperational() {
        BStatus status = this.getStatus();
        return !status.isDisabled() && !status.isFault();
    }

    @Override
    public void handleAlarm(BAlarmRecord alarmRecord) {
        if (!this.isOperational() || this.alarmHandlers == null) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("BConsoleRecipient.handleAlarm: " + (Object)((Object)alarmRecord.getSourceState()));
        }
        for (BiConsumer<BConsoleRecipient, BAlarmRecord> handler : this.alarmHandlers) {
            try {
                handler.accept(this, alarmRecord);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, "Handling alarm from console recipient", e);
            }
        }
    }

    public void registerAlarmHandler(BiConsumer<BConsoleRecipient, BAlarmRecord> listener) {
        if (!this.isOperational() || this.alarmHandlers == null) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        this.alarmHandlers.add(listener);
    }

    public void unregisterAlarmHandler(BiConsumer<BConsoleRecipient, BAlarmRecord> listener) {
        if (this.alarmHandlers != null) {
            this.alarmHandlers.remove(listener);
        }
    }

    public void unregisterAllAlarmHandlers() {
        if (this.alarmHandlers != null) {
            this.alarmHandlers.clear();
        }
    }

    public Cursor<BAlarmSource> getOpenAlarmSources(Context context) {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        return new AlarmsToSourcesCursor(this.getOpenAlarms(context));
    }

    public Cursor<BAlarmRecord> getOpenAlarms(Context context) {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        String query = this.getInitialAlarmQuery(context);
        return ((BITable)BOrd.make((String)query).resolve((BObject)this).get()).cursor();
    }

    public String getInitialAlarmQuery(Context context) {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        BUser user = null;
        if (context != null) {
            user = context.getUser();
        }
        if (user == null) {
            BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
            user = userService.getAdmin();
        }
        return this.getInitialAlarmQuery(user);
    }

    public String getInitialAlarmQuery(BUser user) {
        if (!this.isOperational()) {
            throw new NotRunningException(String.format("The ConsoleRecipient: %s is not operational", this.getName()));
        }
        return AlarmUtil.make((BAlarmService)Sys.getService((Type)BAlarmService.TYPE)).getInitialAlarmQuery(this, user, true);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        out.startTable(true);
        out.write("<tr>");
        out.thTitle((Object)"Registered Alarm Handlers");
        out.write("</tr>");
        for (BiConsumer<BConsoleRecipient, BAlarmRecord> handlers : this.alarmHandlers) {
            out.tr((Object)handlers.toString());
        }
        out.endTable();
        super.spy(out);
    }
}

