/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.alarm.db.file;

import com.tridium.alarm.db.file.Block;
import java.io.IOException;

public class Page {
    public static final int HEADER_SIZE = 12;
    private Block block;
    private int pageInBlock;
    private int size;
    private int recPage;
    private int recPages;
    private int nextPage;

    public Page(Block block, int pageInBlock, int size) {
        this.block = block;
        this.pageInBlock = pageInBlock;
        this.size = size;
    }

    public int getPageOfRecord() {
        return this.recPage;
    }

    public int getPagesOfRecord() {
        return this.recPages;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public synchronized void read() throws IOException {
        Block.Input in = this.block.getInput();
        in.seek(this.size * this.pageInBlock);
        this.recPage = in.readInt();
        this.recPages = in.readInt();
        this.nextPage = in.readInt();
    }

    public synchronized void write(int recPage, int recPages, int nextPage, byte[] b, int offset, int len) throws IOException {
        this.recPage = recPage;
        this.recPages = recPages;
        this.nextPage = nextPage;
        Block.Output out = this.block.getOutput();
        out.seek(this.size * this.pageInBlock);
        out.writeInt(recPage);
        out.writeInt(recPages);
        out.writeInt(nextPage);
        if (len != 0) {
            out.write(b, offset, len);
        }
    }

    public void clear() throws IOException {
        this.write(-1, 0, -1, null, 0, 0);
    }

    public synchronized int readData(int pos) throws IOException {
        Block.Input in = this.block.getInput();
        in.seek(this.size * this.pageInBlock + 12 + pos);
        return in.read();
    }

    public synchronized int readData(int pos, byte[] buf, int offset, int len) throws IOException {
        Block.Input in = this.block.getInput();
        in.seek(this.size * this.pageInBlock + 12 + pos);
        int remainder = this.size - 12 - pos;
        if (remainder < len) {
            return in.read(buf, offset, remainder);
        }
        return in.read(buf, offset, len);
    }

    public String toString() {
        return this.recPage + " of " + this.recPages + ", next=" + this.nextPage;
    }
}

