/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import com.tridium.alarm.AlarmsToSourcesCursor;
import com.tridium.bql.BBqlExtent;
import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.alarm.AlarmException;
import javax.baja.alarm.AlarmSpaceConnection;
import javax.baja.alarm.BAlarmDatabase;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSource;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.AbstractCursor;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.util.BUuid;

public abstract class AlarmDbConnection
implements AlarmSpaceConnection {
    public abstract BAlarmDatabase getAlarmDatabase();

    public synchronized Cursor<BAlarmRecord> doBqlQuery(BqlQuery query) throws IOException, AlarmException {
        SelectQuery select = (SelectQuery)query;
        RangeSet range = null;
        if (((BBqlExtent)select.getSelect().getExtent()).getUnparsed().equals("openAlarms")) {
            return this.getOpenAlarms();
        }
        if (((BBqlExtent)select.getSelect().getExtent()).getUnparsed().equals("ackPendingAlarms")) {
            return this.getAckPendingAlarms();
        }
        if (!select.hasPredicate()) {
            return this.scan();
        }
        try {
            range = select.getRange("uuid", BUuid.TYPE, true);
            if (!range.isAll()) {
                ArrayList<BAlarmRecord> list = new ArrayList<BAlarmRecord>(1);
                int count = range.getCount();
                for (int i = 0; i < count; ++i) {
                    Range r = range.getRange(i);
                    BAlarmRecord rec = this.getRecord((BUuid)r.getSingleton());
                    if (rec == null) continue;
                    list.add((BAlarmRecord)rec.newCopy(true));
                }
                BAlarmRecord[] recs = list.toArray(new BAlarmRecord[0]);
                return new ArrayCursor(recs);
            }
            range = select.getRange("source", BOrdList.TYPE, true);
            if (!range.isAll() && range.getCount() == 1) {
                return this.getAlarmsForSource((BOrdList)range.getRange(0).getSingleton());
            }
            range = select.getRange("timestamp", BAbsTime.TYPE, false);
            if (range.isAll()) {
                return this.scan();
            }
            range.sort();
            Range min = range.getRange(0);
            Range max = range.getRange(range.getCount() - 1);
            return this.timeQuery((BAbsTime)min.min, (BAbsTime)max.max);
        }
        catch (IllegalStateException x) {
            x.printStackTrace();
            return this.scan();
        }
    }

    @Override
    public abstract void flush();

    @Override
    public abstract void close();

    @Override
    public abstract void append(BAlarmRecord var1) throws IOException, AlarmException;

    @Override
    public abstract void update(BAlarmRecord var1) throws IOException, AlarmException;

    @Override
    public abstract int getRecordCount();

    @Override
    public abstract BAlarmRecord getRecord(BUuid var1) throws IOException;

    @Override
    public Cursor<BAlarmSource> getOpenAlarmSources() throws IOException {
        Cursor<BAlarmRecord> alarms = this.getOpenAlarms();
        return new AlarmsToSourcesCursor(alarms);
    }

    @Override
    public abstract Cursor<BAlarmRecord> getOpenAlarms() throws IOException;

    @Override
    public abstract Cursor<BAlarmRecord> getAckPendingAlarms() throws IOException;

    @Override
    public abstract Cursor<BAlarmRecord> getAlarmsForSource(BOrdList var1) throws IOException;

    @Override
    public abstract Cursor<BAlarmRecord> scan() throws IOException, AlarmException;

    @Override
    public abstract Cursor<BAlarmRecord> timeQuery(BAbsTime var1, BAbsTime var2) throws IOException, AlarmException;

    public abstract void clearAllRecords(Context var1) throws IOException;

    public abstract void clearOldRecords(BAbsTime var1, Context var2) throws IOException;

    public abstract void clearRecord(BUuid var1, Context var2) throws IOException;

    private static class ArrayCursor
    extends AbstractCursor<BAlarmRecord> {
        final BAlarmRecord[] recs;
        int index;

        public ArrayCursor(BAlarmRecord[] recs) {
            this.recs = recs;
            this.index = -1;
        }

        protected BAlarmRecord doGet() {
            if (this.index == -1) {
                throw new IllegalStateException("get() before next()");
            }
            return this.recs[this.index];
        }

        protected boolean advanceCursor() {
            if (this.index == this.recs.length) {
                return false;
            }
            ++this.index;
            return this.index != this.recs.length;
        }
    }
}

