/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Queue;

public class AlarmSupport {
    private static final Logger logger = Logger.getLogger("alarm");
    private final BComponent comp;
    private String alarmClassName;
    private BAlarmClass alarmClass;
    private BAlarmSourceInfo info;
    private BSourceState lastTransition;
    private BAlarmRecord lastOffnormal;
    private BAlarmRecord lastFault;
    private BAlarmRecord lastAlert;
    private BAlarmRecord lastNormal;
    private int alarmCount;
    private boolean firstNormal = true;
    BAlarmService as;
    public static final String USER_OVERRIDE_FACET = "fw_BAlarmRecord_user";

    public AlarmSupport(BIAlarmSource comp, String alarmClassName) {
        this.comp = (BComponent)comp;
        this.alarmClassName = alarmClassName;
    }

    public AlarmSupport(BIAlarmSource comp, BAlarmSourceInfo info) {
        this.comp = (BComponent)comp;
        this.alarmClassName = info.getAlarmClass();
        this.info = info;
    }

    public void setAlarmClass(String alarmClassName) {
        this.alarmClassName = alarmClassName;
        this.getAlarmService();
    }

    public BOrdList getSourceOrd() {
        return BOrdList.make((BOrd)this.comp.getNavOrd());
    }

    public String getAlarmClassName() {
        return this.info != null ? this.info.getAlarmClass() : this.alarmClassName;
    }

    public boolean isAckRequired(BSourceState trans) {
        this.getAlarmService();
        return this.alarmClass != null && this.alarmClass.getAckRequired().includes(trans);
    }

    public BAlarmRecord newAlert() throws Exception {
        return this.newAlert(BFacets.DEFAULT);
    }

    public BAlarmRecord newAlert(BFacets alarmData) throws Exception {
        return this.newAlarm(BSourceState.alert, alarmData);
    }

    public BAlarmRecord newOffnormalAlarm() throws Exception {
        return this.newOffnormalAlarm(BFacets.DEFAULT);
    }

    public BAlarmRecord newOffnormalAlarm(BFacets alarmData) throws Exception {
        return this.newAlarm(BSourceState.offnormal, alarmData);
    }

    public BAlarmRecord newFaultAlarm() throws Exception {
        return this.newFaultAlarm(BFacets.DEFAULT);
    }

    public BAlarmRecord newFaultAlarm(BFacets alarmData) throws Exception {
        return this.newAlarm(BSourceState.fault, alarmData);
    }

    protected BAlarmRecord newAlarm(BSourceState state, BFacets alarmData) {
        this.lastTransition = state;
        boolean ackRequired = this.isAckRequired(state);
        BAlarmRecord alarm = new BAlarmRecord(BUuid.make());
        String userOverride = alarmData.gets(USER_OVERRIDE_FACET, null);
        if (userOverride != null) {
            alarm.setUser(userOverride);
            alarmData = BFacets.makeRemove((BFacets)alarmData, (String)USER_OVERRIDE_FACET);
        }
        if (this.info != null) {
            alarmData = BFacets.make((BFacets)this.info.makeAlarmData(state), (BFacets)alarmData);
        }
        alarm.setSource(this.getSourceOrd());
        alarm.setAlarmClass(this.getAlarmClassName());
        alarm.setAlarmTransition(state);
        alarm.setSourceState(state);
        alarm.setAckRequired(ackRequired);
        alarm.setAlarmData(alarmData);
        if (state.equals((Object)BSourceState.offnormal)) {
            this.lastOffnormal = alarm;
        } else if (state.equals((Object)BSourceState.fault)) {
            this.lastFault = alarm;
        } else if (state.equals((Object)BSourceState.alert)) {
            this.lastAlert = alarm;
        }
        ++this.alarmCount;
        if (this.getAlarmService() != null) {
            this.getAlarmService().routeAlarm(alarm);
            return alarm;
        }
        logger.severe("Unable to route new alert for " + this.getSourceOrd());
        return null;
    }

    public synchronized void toNormal(Context cx) throws Exception {
        this.toNormal(BFacets.DEFAULT, cx);
    }

    public synchronized void toNormal(BFacets newFacets, Context ignored) throws Exception {
        this.lastTransition = BSourceState.normal;
        if (this.info != null) {
            newFacets = BFacets.make((BFacets)newFacets, (BFacets)this.info.makeAlarmData(BSourceState.normal));
        }
        if (this.getAlarmService() == null) {
            logger.severe("Unable to transition alarm to Normal for " + this.getSourceOrd());
            return;
        }
        this.lastNormal = null;
        BAbsTime toNormalTimestamp = BAbsTime.now();
        if (this.lastAlert != null && !this.lastAlert.isNormal()) {
            this.lastAlert.setSourceState(BSourceState.normal);
            this.lastAlert.setNormalTime(toNormalTimestamp);
            this.lastNormal = this.lastAlert;
        }
        if (this.lastFault != null && !this.lastFault.isNormal()) {
            this.lastFault.setSourceState(BSourceState.normal);
            this.lastFault.setNormalTime(toNormalTimestamp);
            if (this.lastNormal == null || this.lastFault.getTimestamp().isAfter(this.lastNormal.getTimestamp())) {
                this.lastNormal = this.lastFault;
            }
        }
        if (this.lastOffnormal != null && !this.lastOffnormal.isNormal()) {
            this.lastOffnormal.setSourceState(BSourceState.normal);
            this.lastOffnormal.setNormalTime(toNormalTimestamp);
            if (this.lastNormal == null || this.lastOffnormal.getTimestamp().isAfter(this.lastNormal.getTimestamp())) {
                this.lastNormal = this.lastOffnormal;
            }
        }
        boolean all = this.alarmCount > 1 || this.firstNormal;
        Queue q = (Queue)Sys.getService((Type)BAlarmService.TYPE).fw(601, null, null, null, null);
        q.enqueue((Object)new ToNormalTransition(this.lastNormal, this.alarmClass, newFacets, all, toNormalTimestamp));
        this.firstNormal = false;
        this.alarmCount = 0;
    }

    public boolean ackAlarm(BAlarmRecord alarm) throws Exception {
        alarm.setAckTime(Clock.time());
        alarm.setAckState(BAckState.acked);
        alarm.setAckRequired(false);
        alarm.setAlarmClass(this.getAlarmClassName());
        if (this.lastTransition == BSourceState.normal && alarm.getSourceState() != BSourceState.normal) {
            alarm.setSourceState(BSourceState.normal);
        }
        boolean validAck = false;
        if (alarm.getAlarmTransition() == BSourceState.offnormal) {
            validAck = this.lastOffnormal == null || alarm.getUuid().equals((Object)this.lastOffnormal.getUuid());
        } else if (alarm.getAlarmTransition() == BSourceState.fault) {
            validAck = this.lastFault == null || alarm.getUuid().equals((Object)this.lastFault.getUuid());
        } else if (alarm.getAlarmTransition() == BSourceState.alert) {
            boolean bl = validAck = this.lastAlert == null || alarm.getUuid().equals((Object)this.lastAlert.getUuid());
        }
        if (this.getAlarmService() == null) {
            logger.severe("Cannot route alarm for " + this.getSourceOrd());
        } else {
            this.getAlarmService().routeAlarm(alarm);
        }
        return validAck;
    }

    public boolean isValidNormalAck(BAlarmRecord ackRequest) {
        return this.lastNormal == null || ackRequest.getUuid().equals((Object)this.lastNormal.getUuid());
    }

    public BAlarmRecord getLastNormal() {
        return this.lastNormal;
    }

    public BAlarmRecord getLastOffnormal() {
        return this.lastOffnormal;
    }

    public BAlarmRecord getLastFault() {
        return this.lastFault;
    }

    public BAlarmRecord getLastAlert() {
        return this.lastAlert;
    }

    private BAlarmService getAlarmService() {
        if (this.as == null) {
            try {
                this.as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                this.alarmClass = this.as.lookupAlarmClass(this.getAlarmClassName());
            }
            catch (NullPointerException npe) {
                logger.log(Level.SEVERE, "AlarmSupport could not resolve AlarmService");
                return null;
            }
        }
        return this.as;
    }

    private class ToNormalTransition
    implements Runnable {
        private final BAlarmRecord lastRecord;
        private final BAlarmClass alarmClass;
        private final boolean all;
        private final BFacets newFacets;
        private final BAbsTime toNormalTimestamp;

        ToNormalTransition(BAlarmRecord lastRecord, BAlarmClass alarmClass, BFacets newFacets, boolean all, BAbsTime toNormalTimestamp) {
            this.lastRecord = lastRecord;
            this.alarmClass = alarmClass;
            this.all = all;
            this.newFacets = newFacets;
            this.toNormalTimestamp = toNormalTimestamp;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            BAlarmRecord record;
            boolean ackRequired;
            BAlarmService alarmService;
            block20: {
                alarmService = AlarmSupport.this.getAlarmService();
                if (alarmService == null) {
                    logger.log(Level.SEVERE, "Error transitioning alarm to normal (" + AlarmSupport.this.getSourceOrd() + ')');
                    return;
                }
                ackRequired = this.alarmClass.getAckRequired().isToNormal();
                if (this.all) {
                    BAlarmRecord record2 = new BAlarmRecord(BUuid.make());
                    if (ackRequired) {
                        record2.setAckState(BAckState.unacked);
                    }
                    record2.setSource(AlarmSupport.this.getSourceOrd());
                    record2.setAlarmClass(AlarmSupport.this.getAlarmClassName());
                    record2.setNormalTime(this.toNormalTimestamp);
                    record2.setSourceState(BSourceState.normal);
                    record2.setAckRequired(ackRequired);
                    record2.setAlarmData(this.newFacets);
                    alarmService.getAlarmDb().toNormal(record2);
                    return;
                }
                if (this.lastRecord != null) {
                    try (AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);){
                        this.lastRecord.setSourceState(BSourceState.normal);
                        record = conn.getRecord(this.lastRecord.getUuid());
                        if (record == null) {
                            record = new BAlarmRecord(BUuid.DEFAULT);
                            record.setUuid(this.lastRecord.getUuid());
                        }
                        break block20;
                    }
                    catch (IOException ioe) {
                        logger.log(Level.SEVERE, "Unable to complete toNormal transition", ioe);
                        return;
                    }
                }
                record = new BAlarmRecord(BUuid.make());
            }
            if (ackRequired) {
                record.setAckState(BAckState.unacked);
            }
            record.setSource(AlarmSupport.this.getSourceOrd());
            record.setAlarmClass(AlarmSupport.this.getAlarmClassName());
            record.setNormalTime(this.toNormalTimestamp);
            record.setSourceState(BSourceState.normal);
            record.setAckRequired(record.getAckRequired() || ackRequired);
            record.setAlarmData(BFacets.make((BFacets)record.getAlarmData(), (BFacets)this.newFacets));
            BAlarmClass ac = alarmService.lookupAlarmClass(record.getAlarmClass());
            ac.doRouteAlarm(record);
            alarmService.fireAlarm(record);
            BOrdList list = AlarmSupport.this.getSourceOrd();
            BObject obj = list.get(0).resolve().get();
            if (!(obj instanceof BAlarmSourceExt)) return;
            BAlarmSourceExt ext = (BAlarmSourceExt)obj;
            ext.fireToNormal(record);
        }
    }
}

