/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.alarm;

import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
public class BAlarmClassFolder
extends BFolder
implements BIAlarmClassFolder {
    @Generated
    public static final Type TYPE = Sys.loadType(BAlarmClassFolder.class);
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"folder.png"), (BIcon)BIcon.std((String)"badges/alarm.png"));
    private BAlarmService alarmService;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkAdd(String newName, BValue value, int flags, BFacets facets, Context context) {
        if (this.isRunning() && value.getType().is(BAlarmClass.TYPE) && newName != null) {
            BAlarmService alarmService = (BAlarmService)BOrd.make((String)"service:alarm:AlarmService").get((BObject)this);
            BAlarmClass existingClass = alarmService.lookupAlarmClass(newName);
            if (newName.equals("defaultAlarmClass") || !existingClass.getName().equals("defaultAlarmClass")) {
                throw new LocalizableRuntimeException("alarm", "DuplicateAlarmClass", (Object[])new String[]{newName});
            }
        }
        super.checkAdd(newName, value, flags, facets, context);
    }

    public void checkRename(Property property, String newName, Context context) {
        if (property.getType().is(BAlarmClass.TYPE)) {
            BAlarmService alarmService = (BAlarmService)BOrd.make((String)"service:alarm:AlarmService").get((BObject)this);
            BAlarmClass existingClass = alarmService.lookupAlarmClass(newName);
            if (newName.equals("defaultAlarmClass") || !existingClass.getName().equals("defaultAlarmClass")) {
                throw new IllegalNameException("alarm", "DuplicateAlarmClass", (Object[])new String[]{newName});
            }
            alarmService.alarmClassDisplayNames.clear();
        }
        super.checkRename(property, newName, context);
    }

    public void changed(Property prop, Context cx) {
        if (this.alarmService != null && prop.getName().equals("displayNames")) {
            this.alarmService.alarmClassDisplayNames.clear();
        }
    }

    public void added(Property prop, Context cx) {
        if (this.alarmService != null && prop.getName().equals("displayNames")) {
            this.alarmService.alarmClassDisplayNames.clear();
        }
    }

    public void removed(Property prop, BValue oldValue, Context cx) {
        if (this.alarmService != null && prop.getName().equals("displayNames")) {
            this.alarmService.alarmClassDisplayNames.clear();
        }
    }

    protected BAlarmService getAlarmService() {
        if (this.alarmService == null) {
            this.alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        return this.alarmService;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAlarmService || parent instanceof BAlarmClassFolder;
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return icon;
    }
}

