/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.exporters;

import com.tridium.sys.Nre;
import java.io.PrintWriter;
import java.security.AccessController;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BCsvFile;
import javax.baja.io.BIEncodable;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;

@NiagaraType(agent={@AgentOn(types={"baja:ITable"}, requiredPermissions="r")})
@NiagaraProperties(value={@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="includeHeaders", type="boolean", defaultValue="true"), @NiagaraProperty(name="includeBOM", type="boolean", defaultValue="true"), @NiagaraProperty(name="encodeToString", type="boolean", defaultValue="false"), @NiagaraProperty(name="useCRLF", type="boolean", defaultValue="false", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(file:useCRLF.trueText)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(file:useCRLF.falseText)%\"")}), @NiagaraProperty(name="delimiter", type="String", defaultValue=",", facets={@Facet(name="BFacets.FIELD_WIDTH", value="4")})})
public class BITableToCsv
extends BExporter {
    @Generated
    public static final Property facets = BITableToCsv.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Property includeHeaders = BITableToCsv.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property includeBOM = BITableToCsv.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property encodeToString = BITableToCsv.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property useCRLF = BITableToCsv.newProperty((int)0, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(file:useCRLF.trueText)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(file:useCRLF.falseText)%")));
    @Generated
    public static final Property delimiter = BITableToCsv.newProperty((int)0, (String)",", (BFacets)BFacets.make((String)"fieldWidth", (int)4));
    @Generated
    public static final Type TYPE = Sys.loadType(BITableToCsv.class);
    public static final boolean LEGACY_CSV_ENCODING = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.export.legacyCsvEncoding"));
    public static final boolean PREVENT_CSV_INJECTION = AccessController.doPrivileged(() -> {
        String property = System.getProperty("niagara.export.preventCSVInjection");
        if (property == null) {
            return true;
        }
        return Boolean.parseBoolean(property);
    });

    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public boolean getIncludeHeaders() {
        return this.getBoolean(includeHeaders);
    }

    @Generated
    public void setIncludeHeaders(boolean v) {
        this.setBoolean(includeHeaders, v, null);
    }

    @Generated
    public boolean getIncludeBOM() {
        return this.getBoolean(includeBOM);
    }

    @Generated
    public void setIncludeBOM(boolean v) {
        this.setBoolean(includeBOM, v, null);
    }

    @Generated
    public boolean getEncodeToString() {
        return this.getBoolean(encodeToString);
    }

    @Generated
    public void setEncodeToString(boolean v) {
        this.setBoolean(encodeToString, v, null);
    }

    @Generated
    public boolean getUseCRLF() {
        return this.getBoolean(useCRLF);
    }

    @Generated
    public void setUseCRLF(boolean v) {
        this.setBoolean(useCRLF, v, null);
    }

    @Generated
    public String getDelimiter() {
        return this.getString(delimiter);
    }

    @Generated
    public void setDelimiter(String v) {
        this.setString(delimiter, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BCsvFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "csv";
    }

    public String getLineEnding() {
        return this.getUseCRLF() ? "\r\n" : "\n";
    }

    public void export(ExportOp op) throws Exception {
        PrintWriter out = new PrintWriter(op.getOutputStream());
        if (this.getIncludeBOM()) {
            out.print("\ufeff");
            out.flush();
        }
        this.export((BITable)op.get(), op);
    }

    public void export(BITable<?> table, ExportOp op) throws Exception {
        int i;
        if (this.delimiterContainsFunctionCharacter(this.getDelimiter())) {
            throw new IllegalArgumentException("+, -, =, @ cannot be part of delimiter");
        }
        op.mergeFacets(this.getFacets());
        PrintWriter out = new PrintWriter(op.getOutputStream());
        Column[] cols = table.getColumns().list();
        int colCount = cols.length;
        BFacets defaultFacets = BFacets.make((String)"unitConversion", (int)Nre.unitConversion);
        Context[] colCx = new Context[colCount];
        for (i = 0; i < colCx.length; ++i) {
            colCx[i] = new BasicContext((Context)op, BFacets.make((BFacets)defaultFacets, (BFacets)BFacets.make((BFacets)table.getTableFacets(), (BFacets)BFacets.make((BFacets)cols[i].getFacets(), (BFacets)op.getFacets()))));
        }
        if (this.getIncludeHeaders()) {
            for (i = 0; i < colCount; ++i) {
                String name = this.toHeaderDisplayName(cols[i], colCx[i]);
                if (i > 0) {
                    out.print(this.getDelimiter());
                }
                name = this.escapeFormulas(name);
                if (LEGACY_CSV_ENCODING) {
                    name = name.replace(',', '_');
                    name = name.replace('\"', '\'');
                    out.print(name);
                    continue;
                }
                this.printValue(name, out);
            }
            out.print(this.getLineEnding());
        }
        for (i = 0; i < colCx.length; ++i) {
            colCx[i] = new BasicContext(colCx[i], BFacets.make((String)"showUnits", (BIDataValue)BBoolean.FALSE));
        }
        boolean[] quote = new boolean[colCount];
        for (int i2 = 0; i2 < colCount && LEGACY_CSV_ENCODING; ++i2) {
            Type type = cols[i2].getType();
            quote[i2] = !type.is(BNumber.TYPE) && !type.is(BBoolean.TYPE) && !type.is(BRelTime.TYPE) && !type.is(BAbsTime.TYPE);
        }
        TableCursor cursor = table.cursor();
        while (cursor.next()) {
            for (int i3 = 0; i3 < colCount; ++i3) {
                BFacets cellFacets;
                BObject cell = (BObject)cursor.cell(cols[i3]).as(BObject.class);
                String text = this.encodeToString(cell) ? ((BIEncodable)cell).encodeToString() : ((cellFacets = cursor.row().getCellFacets(cols[i3])) != null && !cellFacets.isNull() ? (colCx[i3] != null ? cell.toString((Context)new BasicContext(colCx[i3], BFacets.make((BFacets)cellFacets, (BFacets)colCx[i3].getFacets()))) : cell.toString((Context)cellFacets)) : cell.toString(colCx[i3]));
                if (i3 != 0) {
                    out.print(this.getDelimiter());
                }
                text = this.escapeFormulas(text);
                if (LEGACY_CSV_ENCODING) {
                    if (quote[i3]) {
                        out.print('\"');
                        out.print(TextUtil.replace((String)text, (String)"\"", (String)"\"\""));
                        out.print('\"');
                        continue;
                    }
                    if (text.indexOf(44) >= 0) {
                        out.print('\"');
                        out.print(text);
                        out.print('\"');
                        continue;
                    }
                    out.print(text);
                    continue;
                }
                this.printValue(text, out);
            }
            out.print(this.getLineEnding());
        }
        out.flush();
    }

    protected final boolean delimiterContainsFunctionCharacter(String delimiter) {
        String allExceptFirst = delimiter.substring(1);
        return allExceptFirst.contains("=") || allExceptFirst.contains("+") || allExceptFirst.contains("-") || allExceptFirst.contains("@");
    }

    protected final String escapeFormulas(String text) {
        if (PREVENT_CSV_INJECTION) {
            char c;
            String results = text;
            if (text.length() > 0 && ((c = text.charAt(0)) == '=' || c == '@' || c == '+' || c == '-')) {
                results = " " + text;
            }
            return results;
        }
        return text;
    }

    private String toHeaderDisplayName(Column col, Context context) {
        BFacets colFacets = context.getFacets();
        BUnit units = (BUnit)colFacets.get("units");
        BObject sName = colFacets.get("SERIES_NAME");
        int colConvert = colFacets.geti("unitConversion", 0);
        BUnitConversion colConversion = BUnitConversion.make((int)colConvert);
        String name = col.getDisplayName(context);
        if (null != sName) {
            name = sName.toString(context);
        }
        if (null != units && units != BUnit.NULL) {
            units = colConversion.getDesiredUnit(units);
            name = name + " (" + units.toString(context) + ")";
        }
        return name;
    }

    protected boolean encodeToString(BObject cell) throws Exception {
        if (!(cell instanceof BIEncodable)) {
            return false;
        }
        if (LEGACY_CSV_ENCODING && (cell.getType() == BAbsTime.TYPE || cell.getType() == BUnit.TYPE || cell.getType().is(BNumber.TYPE))) {
            return false;
        }
        return this.getEncodeToString();
    }

    public void printValue(String text, PrintWriter out) {
        boolean hasDoubleQuote = text.contains("\"");
        if (hasDoubleQuote || text.contains(this.getDelimiter()) || text.contains(this.getLineEnding())) {
            out.print("\"");
            if (hasDoubleQuote) {
                text = TextUtil.replace((String)text, (String)"\"", (String)"\"\"");
            }
            out.print(text);
            out.print("\"");
        } else {
            out.print(text);
        }
    }
}

