/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.types.bog;

import com.tridium.file.types.bog.BBogSpace;
import com.tridium.file.types.bog.CannotLoadBogException;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.nre.util.FileLockException;
import com.tridium.util.PasswordUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.baja.file.BIComponentFile;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BSubSpaceFile;
import javax.baja.file.types.text.BIXmlFile;
import javax.baja.io.ValueDocDecoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractPasswordEncoder;
import javax.baja.security.BIPasswordValidator;
import javax.baja.security.BPassword;
import javax.baja.security.BReversiblePasswordEncoder;
import javax.baja.space.BSpace;
import javax.baja.space.Mark;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType(ext={@FileExt(name="bog")})
public class BBogFile
extends BSubSpaceFile
implements BIComponentFile,
BIXmlFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BBogFile.class);
    private static final BIcon icon = BIcon.std((String)"objectFile.png");
    private static final BIcon dirtyIcon = BIcon.std((String)"objectFileDirty.png");
    private Optional<BPassword> reversibleEncryptionPassPhrase = Optional.empty();
    private Optional<Version> bogVersion = Optional.empty();
    private BIPasswordValidator passPhraseValidator = BPassword.DEFAULT;
    private BogPasswordObjectEncoder bogPasswordObjectEncoder;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBogFile(BIFileStore store) {
        super(store);
    }

    public BBogFile() {
    }

    public List<SlotPath> forceChangeReversibleEncryptionPassPhrase(BPassword value) throws Exception {
        Objects.requireNonNull(value);
        this.initFromHeader();
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.none)) {
            this.setReversibleEncryptionPassPhrase(value);
            return Collections.emptyList();
        }
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
            throw new IllegalArgumentException("Bog file cannot use a pass phrase");
        }
        this.open();
        try (SecretChars valueChars = value.getSecretChars();){
            this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)valueChars);
            this.passPhraseValidator = BIPasswordValidator.fromPBEValidator((PBEValidator)this.bogPasswordObjectEncoder.getPbeEncodingInfo());
            this.getBogSpace().setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
            this.getBogSpace().modified = true;
        }
        this.getBogSpace().setReversibleEncryptionPassPhrase(value);
        List result = PasswordUtil.forceClearReversiblePasswords((BComponent)this.getBogSpace().getRootComponent());
        this.reversibleEncryptionPassPhrase = Optional.of(value);
        return result;
    }

    public List<SlotPath> forceClearReversibleEncryptionPassPhrase() throws Exception {
        this.initFromHeader();
        this.open();
        this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeNone();
        this.passPhraseValidator = BPassword.DEFAULT;
        this.getBogSpace().setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
        this.getBogSpace().modified = true;
        this.getBogSpace().clearReversibleEncryptionPassPhrase();
        List result = PasswordUtil.forceClearReversiblePasswords((BComponent)this.getBogSpace().getRootComponent());
        this.reversibleEncryptionPassPhrase = Optional.empty();
        return result;
    }

    public void setReversibleEncryptionPassPhrase(BPassword value) throws Exception {
        Objects.requireNonNull(value);
        this.initFromHeader();
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
            throw new IllegalArgumentException("Bog file cannot use a pass phrase");
        }
        if (this.validateReversibleEncryptionPassPhrase(value)) {
            if (!this.reversibleEncryptionPassPhrase.isPresent()) {
                Throwable throwable;
                if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.none)) {
                    throwable = null;
                    try (SecretChars valueChars = value.getSecretChars();){
                        this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)valueChars);
                        this.passPhraseValidator = BIPasswordValidator.fromPBEValidator((PBEValidator)this.bogPasswordObjectEncoder.getPbeEncodingInfo());
                        if (this.getBogSpace() != null) {
                            this.getBogSpace().setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
                            this.getBogSpace().modified = true;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                if (this.getBogSpace() != null) {
                    this.getBogSpace().setReversibleEncryptionPassPhrase(value);
                    throwable = null;
                    try (SecretChars passPhrase = value.getSecretChars();
                         ISecretBytesSupplier key = this.bogPasswordObjectEncoder.passPhraseToKey(passPhrase);){
                        PasswordUtil.PasswordPropertyUpdate passwordPropertyUpdate = password -> {
                            if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder && ((BReversiblePasswordEncoder)password.getPasswordEncoder()).usesExternalEncryptionKey()) {
                                BReversiblePasswordEncoder encoder = (BReversiblePasswordEncoder)password.getPasswordEncoder();
                                AccessController.doPrivileged(() -> {
                                    encoder.setExternalEncryptionKey((SecretBytes)key.get());
                                    return null;
                                });
                            }
                            return password;
                        };
                        for (BComponent c : () -> this.getBogSpace().iterateAllComponents()) {
                            PasswordUtil.updatePasswords((BComplex)c, (SlotPath)c.getSlotPath(), (PasswordUtil.PasswordPropertyUpdate)passwordPropertyUpdate);
                            Optional exception = passwordPropertyUpdate.exceptions().findFirst();
                            if (!exception.isPresent()) continue;
                            throw (RuntimeException)exception.get();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                this.reversibleEncryptionPassPhrase = Optional.of(value);
            }
        } else {
            throw new LocalizableRuntimeException("baja", "encryptionPassPhraseDoesntMatch");
        }
    }

    public void updateReversibleEncryptionPassPhrase(BPassword newValue) throws Exception {
        Objects.requireNonNull(newValue);
        this.initFromHeader();
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
            throw new IllegalArgumentException("Bog file does not use a pass phrase");
        }
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external) && !this.reversibleEncryptionPassPhrase.isPresent()) {
            throw new IllegalStateException("Original pass phrase has not been provided");
        }
        this.open();
        try (SecretChars valueChars = newValue.getSecretChars();){
            this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)valueChars);
            try (ISecretBytesSupplier key = this.bogPasswordObjectEncoder.passPhraseToKey(valueChars);){
                this.passPhraseValidator = BIPasswordValidator.fromPBEValidator((PBEValidator)this.bogPasswordObjectEncoder.getPbeEncodingInfo());
                this.getBogSpace().setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
                this.getBogSpace().modified = true;
                this.getBogSpace().setReversibleEncryptionPassPhrase(newValue);
                PasswordUtil.PasswordPropertyUpdate passwordPropertyUpdate = password -> {
                    if (password.getPasswordEncoder() instanceof BReversiblePasswordEncoder && ((BReversiblePasswordEncoder)password.getPasswordEncoder()).usesExternalEncryptionKey()) {
                        BReversiblePasswordEncoder oldEncoder = (BReversiblePasswordEncoder)password.getPasswordEncoder();
                        BReversiblePasswordEncoder newEncoder = (BReversiblePasswordEncoder)oldEncoder.getType().getInstance();
                        AccessController.doPrivileged(() -> {
                            newEncoder.setExternalEncryptionKey((SecretBytes)key.get());
                            return null;
                        });
                        try {
                            newEncoder.encode(AccessController.doPrivileged(() -> ((BReversiblePasswordEncoder)oldEncoder).getSecretChars()));
                        }
                        catch (Exception e) {
                            throw new BajaRuntimeException((Throwable)e);
                        }
                        return BPassword.make((BAbstractPasswordEncoder)newEncoder);
                    }
                    return password;
                };
                for (BComponent c : () -> this.getBogSpace().iterateAllComponents()) {
                    PasswordUtil.updatePasswords((BComplex)c, (SlotPath)c.getSlotPath(), (PasswordUtil.PasswordPropertyUpdate)passwordPropertyUpdate);
                    Optional exception = passwordPropertyUpdate.exceptions().findFirst();
                    if (!exception.isPresent()) continue;
                    throw (RuntimeException)exception.get();
                }
            }
        }
        this.reversibleEncryptionPassPhrase = Optional.of(newValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateReversibleEncryptionPassPhrase(BPassword value) throws Exception {
        if (value == null) return false;
        if (value.isNull()) {
            return false;
        }
        this.initFromHeader();
        if (!this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external)) return true;
        if (!this.passPhraseValidator.validate(AccessController.doPrivileged(() -> ((BPassword)value).getValue()))) return false;
        return true;
    }

    public boolean canUseReversibleEncryptionPassPhrase() throws Exception {
        this.initFromHeader();
        return !this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring);
    }

    public boolean usesKeyRingEncryption() throws Exception {
        this.initFromHeader();
        return this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring);
    }

    public boolean usesReversibleEncryptionPassPhrase() throws Exception {
        this.initFromHeader();
        return this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external);
    }

    public boolean isReversibleEncryptionPassPhraseAvailable() {
        return this.reversibleEncryptionPassPhrase.isPresent();
    }

    public PBEEncodingInfo getPBEEncodingInfo() throws Exception {
        this.initFromHeader();
        return this.bogPasswordObjectEncoder == null ? null : this.bogPasswordObjectEncoder.getPbeEncodingInfo();
    }

    public Version getBogVersion() throws Exception {
        this.initFromHeader();
        return this.bogVersion.get();
    }

    public BBogSpace getBogSpace() {
        return (BBogSpace)this.getSubSpace();
    }

    public boolean isModified() {
        BBogSpace bogSpace = this.getBogSpace();
        return bogSpace != null && bogSpace.isModified();
    }

    protected BSpace doOpen() {
        BBogSpace space = new BBogSpace(this);
        if (this.reversibleEncryptionPassPhrase.isPresent()) {
            space.setReversibleEncryptionPassPhrase(this.reversibleEncryptionPassPhrase.get());
        }
        try {
            space.checkLock();
            ValueDocDecoder decoder = this.getDecoder();
            BComponent root = (BComponent)decoder.decodeDocument();
            boolean shouldBeModified = this.processHeaderInformation(decoder, space);
            space.setRootComponent(root);
            BBogSpace.activateLinks(root);
            space.modified = shouldBeModified;
        }
        catch (FileLockException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotLoadBogException(this.getAbsoluteOrd().toString(), e);
        }
        return space;
    }

    protected void doSave() throws Exception {
        this.getBogSpace().save();
        this.updateHeaderVariablesFromSpace();
    }

    protected void doClose() {
        this.getBogSpace().close();
        this.bogVersion = Optional.empty();
        this.passPhraseValidator = BPassword.DEFAULT;
        this.bogPasswordObjectEncoder = null;
    }

    public Mark readComponents() throws Exception {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<BComponent> values = new ArrayList<BComponent>();
        BComponent root = (BComponent)this.getDecoder().decodeDocument();
        for (BComponent kid : root.getChildComponents()) {
            names.add(kid.getName());
            values.add(kid);
        }
        return new Mark(values.toArray(new BObject[0]), names.toArray(new String[0]));
    }

    public BOrd getNavOrd() {
        return BOrd.make((String)(this.getAbsoluteOrd().toString() + "|bog:|slot:/"));
    }

    private void initFromHeader() throws Exception {
        if (!this.bogVersion.isPresent()) {
            try (InputStream in = this.getInputStream();
                 BufferedInputStream bin = new BufferedInputStream(in);){
                ValueDocDecoder.BogDecoderPlugin plugin = new ValueDocDecoder.BogDecoderPlugin((InputStream)bin);
                this.bogVersion = Optional.of(plugin.readHeader());
                this.bogPasswordObjectEncoder = plugin.getPasswordObjectEncoder();
                this.passPhraseValidator = plugin.getPassPhraseValidator();
            }
        }
    }

    protected ValueDocDecoder getDecoder() throws Exception {
        ValueDocDecoder.BogDecoderPlugin plugin = new ValueDocDecoder.BogDecoderPlugin((BIFile)this);
        plugin.setPassPhrase(this.reversibleEncryptionPassPhrase);
        return new ValueDocDecoder((ValueDocDecoder.IDecoderPlugin)plugin);
    }

    protected boolean processHeaderInformation(ValueDocDecoder decoder, BBogSpace space) throws Exception {
        boolean shouldBeModified = false;
        this.bogVersion = Optional.of(decoder.getPlugin().getVersion());
        this.bogPasswordObjectEncoder = ((ValueDocDecoder.BogDecoderPlugin)decoder.getPlugin()).getPasswordObjectEncoder();
        if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.none) && this.reversibleEncryptionPassPhrase.isPresent()) {
            try (SecretChars passPhrase = this.reversibleEncryptionPassPhrase.get().getSecretChars();){
                this.bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeExternal((SecretChars)passPhrase);
            }
            this.passPhraseValidator = BIPasswordValidator.fromPBEValidator((PBEValidator)this.bogPasswordObjectEncoder.getPbeEncodingInfo());
            space.setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
            shouldBeModified = true;
        } else {
            this.passPhraseValidator = decoder.getPlugin().getPassPhraseValidator();
        }
        space.setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
        space.setBogVersion(this.bogVersion.get());
        return shouldBeModified;
    }

    protected void updateHeaderVariablesFromSpace() throws Exception {
        this.bogPasswordObjectEncoder = this.getBogSpace().getBogPasswordObjectEncoder();
        this.bogVersion = Optional.of(this.getBogSpace().getBogVersion());
    }

    public BIcon getIcon() {
        return this.getStore() != null && this.isModified() ? dirtyIcon : icon;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        BBogSpace bogSpace = this.getBogSpace();
        if (bogSpace != null) {
            out.w((Object)"<hr> <b>BogSpace</b>");
            bogSpace.spy(out);
        }
    }
}

