/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.types.bog;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.nre.util.FileLock;
import com.tridium.sys.engine.EngineUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.file.BLocalFileStore;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.MissingEncodingKeyException;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.space.BComponentSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType
public class BBogSpace
extends BComponentSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BBogSpace.class);
    BBogFile bogFile;
    boolean modified;
    long openTimestamp;
    FileLock lock;
    private Optional<BPassword> reversibleEncryptionPassPhrase = Optional.empty();
    private BogPasswordObjectEncoder bogPasswordObjectEncoder = BogPasswordObjectEncoder.makeNone();
    private Version bogVersion;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBogSpace(BBogFile bogFile) {
        super(bogFile.getFileName(), null, BOrd.make((BOrd)bogFile.getOrdInSession(), (String)"bog:"));
        this.bogFile = bogFile;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void modified(BComponent c, Context context) {
        this.modified = true;
    }

    public void childParented(BComponent c, Property property, BValue newChild, Context context) {
        BBoolean auto;
        if (context != null && (auto = (BBoolean)context.getFacet("niagaraAutoStart")) != null && !auto.getBoolean()) {
            return;
        }
        if (newChild instanceof BComponent) {
            BBogSpace.activateLinks((BComponent)newChild);
        } else if (newChild instanceof BLink) {
            EngineUtil.activate((BLink)((BLink)newChild));
        } else if (newChild instanceof BRelation) {
            EngineUtil.activate((BRelation)((BRelation)newChild));
        }
    }

    public void childUnparented(BComponent c, Property property, BValue oldChild, Context context) {
        if (oldChild instanceof BComponent) {
            BBogSpace.deactivateLinks((BComponent)oldChild);
        } else if (oldChild instanceof BLink) {
            EngineUtil.deactivate((BLink)((BLink)oldChild));
        }
    }

    public Transaction newTransaction(Context cx) {
        try {
            return new BogSpaceTransaction(this.getEncodingContext(cx));
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public Context getEncodingContext(Context base) {
        return PasswordEncodingContext.updateContext((Context)base, pContext -> {
            try {
                AccessController.doPrivileged(() -> {
                    if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.external) || this.reversibleEncryptionPassPhrase.isPresent()) {
                        if (this.reversibleEncryptionPassPhrase.isPresent()) {
                            try (SecretChars passPhrase = this.reversibleEncryptionPassPhrase.get().getSecretChars();){
                                pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.external, Optional.of(this.bogPasswordObjectEncoder.passPhraseToKey(passPhrase)));
                            }
                        } else {
                            pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.external, Optional.empty());
                        }
                    } else if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
                        pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.keyring, Optional.empty());
                    } else if (this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.none)) {
                        pContext.setEncryptionAndDecryptionKey(EncryptionKeySource.none, Optional.empty());
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw new BajaRuntimeException(pae.getCause());
            }
        });
    }

    public static void activateLinks(BComponent component) {
        EngineUtil.activateLinks((BComponent)component);
    }

    public static void deactivateLinks(BComponent component) {
        EngineUtil.deactivateLinks((BComponent)component);
    }

    public boolean isSpaceReadonly() {
        return this.bogFile != null && this.bogFile.isReadonly();
    }

    public boolean isMounted() {
        return this.bogFile != null;
    }

    public BHost getHost() {
        if (this.bogFile == null) {
            return null;
        }
        return this.bogFile.getHost();
    }

    public BISession getSession() {
        if (this.bogFile == null) {
            return null;
        }
        return this.bogFile.getSession();
    }

    public BOrd getAbsoluteOrd() {
        if (this.bogFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.bogFile.getAbsoluteOrd(), (String)"bog:");
    }

    public BOrd getOrdInHost() {
        if (this.bogFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.bogFile.getOrdInHost(), (String)"bog:");
    }

    public BOrd getOrdInSession() {
        if (this.bogFile == null) {
            return null;
        }
        return BOrd.make((BOrd)this.bogFile.getOrdInSession(), (String)"bog:");
    }

    public BINavNode getNavParent() {
        return this.getBogFile();
    }

    public final void clearReversibleEncryptionPassPhrase() {
        this.reversibleEncryptionPassPhrase = Optional.empty();
    }

    public final void setReversibleEncryptionPassPhrase(BPassword value) {
        this.reversibleEncryptionPassPhrase = Optional.of(value);
    }

    public final void setBogPasswordObjectEncoder(BogPasswordObjectEncoder value) {
        this.bogPasswordObjectEncoder = value;
    }

    public BogPasswordObjectEncoder getBogPasswordObjectEncoder() {
        return this.bogPasswordObjectEncoder;
    }

    public Version getBogVersion() {
        return this.bogVersion;
    }

    public void setBogVersion(Version value) {
        this.bogVersion = value;
    }

    public BBogFile getBogFile() {
        return this.bogFile;
    }

    void save() throws Exception {
        ValueDocEncoder encoder;
        ValueDocEncoder.BogEncoderPlugin plugin;
        this.checkLock();
        if (!this.reversibleEncryptionPassPhrase.isPresent() && !this.bogPasswordObjectEncoder.getKeySource().equals((Object)EncryptionKeySource.keyring)) {
            plugin = new ValueDocEncoder.BogEncoderPlugin(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
            plugin.setFailOnEncodingExceptions(false);
            encoder = new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)plugin);
            plugin.setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
            encoder.setZipped(true);
            encoder.encodeDocument((BValue)this.getRootComponent());
            encoder.close();
            Optional<Exception> keyException = encoder.getUnhandledEncodingExceptions().filter(e -> e instanceof MissingEncodingKeyException).findFirst();
            if (keyException.isPresent()) {
                throw keyException.get();
            }
        }
        plugin = new ValueDocEncoder.BogEncoderPlugin(this.bogFile.getOutputStream());
        plugin.setPassPhrase(this.reversibleEncryptionPassPhrase);
        encoder = new ValueDocEncoder((ValueDocEncoder.IEncoderPlugin)plugin);
        plugin.setBogPasswordObjectEncoder(this.bogPasswordObjectEncoder);
        encoder.setZipped(true);
        encoder.encodeDocument((BValue)this.getRootComponent());
        encoder.close();
        this.bogVersion = plugin.version();
        this.bogPasswordObjectEncoder = plugin.getBogPasswordObjectEncoder();
        this.modified = false;
    }

    void close() {
        this.bogFile = null;
        this.setRootComponent(null);
    }

    public void checkLock() throws Exception {
        if (this.bogFile.getStore() instanceof BLocalFileStore) {
            BLocalFileStore store = (BLocalFileStore)this.bogFile.getStore();
            File localFile = store.getLocalFile();
            if (BBogFile.log.isLoggable(Level.FINE)) {
                BBogFile.log.fine("Check lock " + localFile);
            }
            FileLock.check((File)localFile);
        }
    }

    private class BogSpaceTransaction
    extends Transaction {
        private BogSpaceTransaction(Context baseContext) throws IOException {
            super((BComponentSpace)BBogSpace.this, baseContext);
        }

        protected void checkAutoStart(BValue value) {
            if (value instanceof BComponent) {
                BBogSpace.activateLinks((BComponent)value);
            } else if (value instanceof BLink) {
                EngineUtil.activate((BLink)((BLink)value));
            } else if (value instanceof BRelation) {
                EngineUtil.activate((BRelation)((BRelation)value));
            }
        }
    }
}

