/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.file.types.bog;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.file.types.bog.BBogSpace;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.file.BIFileStore;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(ext={@FileExt(name="palette")})
public class BPaletteFile
extends BBogFile {
    @Generated
    public static final Type TYPE = Sys.loadType(BPaletteFile.class);
    private static final BIcon icon = BIcon.std((String)"palette.png");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPaletteFile(BIFileStore store) {
        super(store);
    }

    public BPaletteFile() {
    }

    @Override
    protected void doSave() throws Exception {
        BBogSpace space = this.getBogSpace();
        space.checkLock();
        WipePasswordCleanEncoder encoder = new WipePasswordCleanEncoder(space.bogFile.getOutputStream());
        encoder.setZipped(false);
        encoder.encodeDocument((BValue)space.getRootComponent());
        encoder.close();
        space.modified = false;
        this.updateHeaderVariablesFromSpace();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public void setReversibleEncryptionPassPhrase(BPassword value) throws Exception {
        throw new IllegalArgumentException("Palette file does not use a pass phrase");
    }

    @Override
    public boolean validateReversibleEncryptionPassPhrase(BPassword value) throws Exception {
        throw new IllegalArgumentException("Palette file does not use a pass phrase");
    }

    @Override
    public boolean canUseReversibleEncryptionPassPhrase() throws Exception {
        return false;
    }

    @Override
    public boolean isReversibleEncryptionPassPhraseAvailable() {
        return false;
    }

    @Override
    public boolean usesKeyRingEncryption() {
        return false;
    }

    @Override
    public void updateReversibleEncryptionPassPhrase(BPassword newValue) throws Exception {
        throw new IllegalArgumentException("Palette file does not use a pass phrase");
    }

    class WipePasswordCleanEncoder
    extends ValueDocEncoder {
        public WipePasswordCleanEncoder(OutputStream out) throws IOException {
            super((ValueDocEncoder.IEncoderPlugin)new ValueDocEncoder.BogEncoderPlugin(out), null);
        }

        public boolean isTypeBlackListed(Type type) {
            if (type.is(BPassword.TYPE) || type.is(BPasswordHistory.TYPE)) {
                return true;
            }
            return super.isTypeBlackListed(type);
        }
    }
}

